/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.util.eclipse;

import com.sap.portal.developmentTools.general.api.IFinishResult;
import com.sap.portal.developmentTools.general.api.IResult;
import com.sap.portal.util.Result;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.wsdl.InformationReport;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class FinishResult
implements IFinishResult {
    private Vector mm_messages;
    private Vector mm_listMarkers = null;
    private String mm_pluginName = null;
    private int mm_finalState = 2;

    public FinishResult(String pluginName) {
        this.mm_pluginName = pluginName;
        this.mm_messages = new Vector();
        this.mm_listMarkers = new Vector();
    }

    public void addInfo(String message) {
        Result result = new Result();
        result.setStatus(0);
        result.setMessage(message);
        this.mm_messages.add(result);
    }

    public void addError(String message) {
        Result result = new Result();
        result.setStatus(2);
        result.setMessage(message);
        this.mm_messages.add(result);
    }

    public void addWarning(String message) {
        Result result = new Result();
        result.setStatus(1);
        result.setMessage(message);
        this.mm_messages.add(result);
    }

    public void setFinalState(int status) {
        this.mm_finalState = status;
    }

    public int getFinalState() {
        return this.mm_finalState;
    }

    public Vector getFinishResults() {
        return this.mm_messages;
    }

    public void cleanReport() {
        this.mm_messages.clear();
        Enumeration enumeration = this.mm_listMarkers.elements();
        while (enumeration.hasMoreElements()) {
            IMarker result = (IMarker)enumeration.nextElement();
            try {
                result.delete();
            }
            catch (CoreException e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            }
        }
        this.mm_listMarkers.clear();
    }

    public void addInformationsInTaskView(Object project) {
        IProject eclipseproject = (IProject)project;
        Enumeration enumeration = this.mm_messages.elements();
        while (enumeration.hasMoreElements()) {
            try {
                IResult result = (IResult)enumeration.nextElement();
                IMarker marker = eclipseproject.createMarker("com.sap.ep.applicationDevelopment.pluginProblemMarker");
                marker.setAttribute("message", (Object)(this.mm_pluginName + ": " + result.getMessage()));
                switch (result.getStatus()) {
                    case 2: {
                        marker.setAttribute("severity", 2);
                        break;
                    }
                    case 0: {
                        marker.setAttribute("severity", 0);
                        break;
                    }
                    case 3: {
                        marker.setAttribute("severity", 2);
                        break;
                    }
                    case 1: {
                        marker.setAttribute("severity", 1);
                    }
                }
                marker.setAttribute("priority", 1);
                marker.setAttribute("org.eclipse.core.resources.marker", (Object)"org.eclipse.core.resources.textmarker");
                this.mm_listMarkers.add(marker);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void convertReport(Vector soapgenerator_report) {
        Enumeration enumeration = soapgenerator_report.elements();
        while (enumeration.hasMoreElements()) {
            InformationReport element = (InformationReport)enumeration.nextElement();
            switch (element.getState()) {
                case 2: {
                    this.addError(element.getMessage());
                    break;
                }
                case 3: {
                    this.addInfo(element.getMessage());
                    break;
                }
                case 0: {
                    this.addInfo(element.getMessage());
                    break;
                }
                case 1: {
                    this.addWarning(element.getMessage());
                }
            }
        }
    }

    public String getId() {
        return this.mm_pluginName;
    }
}

