/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.util;

import java.util.StringTokenizer;

public class JavaIdentifier {
    public static final boolean isValidJavaIdentifier(String identifier) {
        if (identifier == null) {
            return false;
        }
        char[] newAr = identifier.toCharArray();
        if (newAr.length == 0) {
            return false;
        }
        char c = newAr[0];
        if (!(c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A' || c == '_')) {
            return false;
        }
        int i = 1;
        while (i < newAr.length) {
            c = newAr[i];
            if (!(c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A' || c <= '9' && c >= '0' || c == '_')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String getGenerousIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (JavaIdentifier.isValidJavaIdentifier(identifier = identifier.trim())) {
            return identifier;
        }
        return null;
    }

    public static final String getGenerousPackageName(String packageName) {
        StringTokenizer st = new StringTokenizer(packageName, " .");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String ident = st.nextToken();
            if (!JavaIdentifier.isValidJavaIdentifier(ident)) {
                return null;
            }
            sb.append('.');
            sb.append(ident);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(1);
    }

    public static final String getGenerousPackageNameOrEmpty(String packageName) {
        if (packageName == null) {
            return "";
        }
        if (packageName.trim().equals("")) {
            return "";
        }
        return JavaIdentifier.getGenerousPackageName(packageName);
    }

    public static boolean isValidOrEmptyPackageName(String packageName) {
        if (packageName == null) {
            return true;
        }
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        while (st.hasMoreTokens()) {
            if (JavaIdentifier.isValidJavaIdentifier(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    private JavaIdentifier() {
    }
}

