/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.util;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.StringBufferPool;
import java.util.HashMap;

public class BaseStringBufferPool
extends StringBufferPool {
    protected static ReentrantWriterPreferenceReadWriteLock m_rwlock;
    protected String m_poolName;

    public static void init() {
        StringBufferPool.m_corePoolFactory = new BaseStringBufferPool(0, 0, 0);
        m_rwlock = new ReentrantWriterPreferenceReadWriteLock();
    }

    public static void shutdown() {
        StringBufferPool.m_corePoolFactory = null;
        StringBufferPool.mm_namedPools = null;
    }

    protected BaseStringBufferPool(int initialCapacity, int initialNbInstances, int maxSize) {
        super(initialCapacity, initialNbInstances, maxSize);
    }

    protected StringBufferPool createInstanceInternal(String poolName, int intialCapacity) {
        return this.createInstanceInternal(poolName, intialCapacity, 0, 50);
    }

    protected StringBufferPool createInstanceInternal(String poolName, int intialCapacity, int initialNbInstances) {
        return this.createInstanceInternal(poolName, intialCapacity, initialNbInstances, 50);
    }

    protected StringBufferPool createInstanceInternal(String poolName, int intialCapacity, int initialNbInstances, int maxPoolSize) {
        BaseStringBufferPool pool = (BaseStringBufferPool)((Object)StringBufferPool.mm_namedPools.get(poolName));
        if (pool == null) {
            HashMap hashMap = StringBufferPool.mm_namedPools;
            synchronized (hashMap) {
                pool = (BaseStringBufferPool)((Object)StringBufferPool.mm_namedPools.get(poolName));
                if (pool == null) {
                    pool = new BaseStringBufferPool(intialCapacity, initialNbInstances, maxPoolSize);
                    pool.m_poolName = poolName;
                    StringBufferPool.mm_namedPools.put(poolName, pool);
                }
            }
        }
        return pool;
    }

    protected StringBufferPool getInstanceInternal() {
        return this.getInstanceInternal("com.sap.portal.runtime.pool.StringBufferPool");
    }

    protected StringBufferPool getInstanceInternal(String poolName) {
        StringBufferPool pool = (StringBufferPool)StringBufferPool.mm_namedPools.get(poolName);
        if (pool == null) {
            pool = this.createInstanceInternal(poolName, 16, 0, 50);
        }
        return pool;
    }

    public synchronized void releasePoolObject(Object o) {
        super.releasePoolObject(o);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecyclableStringBuffer get(int size) {
        RecyclableStringBuffer buf = null;
        try {
            try {
                BaseStringBufferPool.getReadLock().acquire();
                buf = super.get(size);
            }
            catch (InterruptedException e) {
                buf = super.get(size);
                Object var5_4 = null;
                BaseStringBufferPool.getReadLock().release();
                return buf;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            BaseStringBufferPool.getReadLock().release();
            throw throwable;
        }
        BaseStringBufferPool.getReadLock().release();
        return buf;
    }

    protected Object createPoolObject() throws Exception {
        return super.createPoolObject();
    }

    protected void expirePoolObject(Object o) {
        super.expirePoolObject(o);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release(RecyclableStringBuffer rStrBuf) {
        try {
            try {
                BaseStringBufferPool.getReadLock().acquire();
                super.release(rStrBuf);
            }
            catch (InterruptedException e) {
                super.release(rStrBuf);
                Object var4_3 = null;
                BaseStringBufferPool.getReadLock().release();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            BaseStringBufferPool.getReadLock().release();
            throw throwable;
        }
        BaseStringBufferPool.getReadLock().release();
    }

    public static HashMap getNamedPools() {
        return StringBufferPool.mm_namedPools;
    }

    protected boolean validatePoolObject(Object o) {
        return super.validatePoolObject(o);
    }

    public static Sync getReadLock() {
        return m_rwlock.readLock();
    }

    public static Sync getWriteLock() {
        return m_rwlock.writeLock();
    }
}

