/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.webservices.MethodRep;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.WebServicesProcessEP6;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlChooserPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlPropertiesPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlWizard;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.wsdl.GenerateServiceFromWsdl;
import com.sapportals.portal.prt.service.soap.wsdl.InformationReport;
import java.io.File;
import java.net.MalformedURLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.DrillDownAdapter;

public class WebWsdlMethodPage
extends WizardPage
implements IWebservicesWizardStringLiterals,
ModifyListener {
    private static CheckboxTreeViewer mm_viewer;
    private static ViewContentProvider mm_content;
    private static GenerateServiceFromWsdl mm_generator;
    private Object mm_project;
    private boolean mm_emptyTree = false;
    private boolean mm_generateCustomsSerializer = false;
    private boolean mm_noWsdl = false;
    private File mm_currentProjectFolder;
    private WebWsdlChooserPage mm_interfacePage = null;
    private DrillDownAdapter mm_drillDownAdapter;
    private Vector mm_namemethods = new Vector();
    private Vector mm_checkedButtons = new Vector();
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();
    private WebWsdlWizard mm_wizard = null;

    public WebWsdlMethodPage(Object project, WebWsdlChooserPage interfacePage, WebWsdlWizard wizard) {
        super("");
        this.mm_project = project;
        this.mm_interfacePage = interfacePage;
        this.mm_generateCustomsSerializer = false;
        this.mm_wizard = wizard;
        this.setTitle("Portal Service from Wsdl file - Step 2");
        this.setDescription("Select the method(s) to expose:");
        this.setProject((IProject)project);
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        this.mm_currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
    }

    public GenerateServiceFromWsdl getGenerator() {
        return mm_generator;
    }

    public void createControl(Composite parent) {
        try {
            mm_generator = this.mm_interfacePage.getGenerator();
        }
        catch (MalformedURLException e1) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
            this.mm_guiSystem.showErrorMessage("Error", "Malformed Url Exception", e1);
            this.mm_noWsdl = true;
        }
        catch (Exception e1) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
            this.mm_guiSystem.showErrorMessage("Error", "Error reading the Wsdl File", e1);
            this.mm_noWsdl = true;
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPartControl(container);
        Button flatListButton = new Button(container, 8);
        flatListButton.setText("Select All");
        flatListButton.setLayoutData((Object)new GridData(256));
        flatListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] leaves = mm_content.getElements();
                int i = 0;
                while (i < leaves.length) {
                    mm_viewer.setChecked(leaves[i], true);
                    ++i;
                }
                WebWsdlMethodPage.this.setPageComplete(true);
            }
        });
        Button unselectButton = new Button(container, 8);
        unselectButton.setText("Unselect All");
        unselectButton.setLayoutData((Object)new GridData(256));
        unselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] leaves = mm_content.getElements();
                int i = 0;
                while (i < leaves.length) {
                    mm_viewer.setChecked(leaves[i], false);
                    ++i;
                }
                WebWsdlMethodPage.this.setPageComplete(true);
            }
        });
        this.setControl((Control)container);
        container.setFocus();
        this.modifyText(null);
    }

    public void modifyText(ModifyEvent e) {
    }

    public void checkPage() throws Exception {
    }

    public boolean[] getCheckedMethods() {
        Object[] leaves = mm_content.getElements();
        boolean[] index = new boolean[leaves.length];
        int i = 0;
        while (i < leaves.length) {
            boolean selected = mm_viewer.getChecked(leaves[i]);
            if (selected) {
                index[i] = true;
                if (leaves[i].toString().endsWith("**")) {
                    this.mm_generateCustomsSerializer = true;
                }
            } else {
                index[i] = false;
            }
            ++i;
        }
        return index;
    }

    public boolean performFinishMethods(GenerateServiceFromWsdl generator, int clientServer) {
        mm_generator = generator;
        WebServicesProcessEP6 process = null;
        WebWsdlPropertiesPage propertiesPage = (WebWsdlPropertiesPage)this.getNextPage();
        if (propertiesPage == null) {
            return false;
        }
        String alias = null;
        String serviceName = null;
        String packageName = null;
        boolean minOccurIsNillable = false;
        IDESettings is = IDESettings.getInstance();
        try {
            alias = propertiesPage.getAlias();
            is.setProperty("aliaswsdl", alias, this.mm_project);
            serviceName = propertiesPage.getServiceName();
            is.setProperty("servicewsdl", serviceName, this.mm_project);
            packageName = propertiesPage.getPackage();
            is.setProperty("packagenamewsdl", packageName, this.mm_project);
            minOccurIsNillable = propertiesPage.isMinOccurAsNillable();
            is.setProperty("minoccNill", "" + minOccurIsNillable, this.mm_project);
        }
        catch (RuntimeException e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            alias = "Alias";
            serviceName = "ServiceName";
            packageName = "com.company.global.enterprise.portal.wsdl.webservices.service.packagename";
        }
        mm_generator.setNamePackage(packageName);
        mm_generator.setNameService(serviceName);
        try {
            process = new WebServicesProcessEP6(WebWsdlChooserPage.mm_wsdlUrl, this.mm_project);
            process.setAlias(alias);
            process.setGeneratorWsdl(generator);
        }
        catch (Exception exc) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)exc);
            this.mm_guiSystem.showErrorMessage("Error", "Cannot load the web services process", exc);
        }
        String[] allMethods = mm_generator.getOperations();
        boolean[] checkedMethods = this.getCheckedMethods();
        Vector<Integer> am = new Vector<Integer>();
        int i = 0;
        while (i < checkedMethods.length) {
            if (checkedMethods[i]) {
                am.add(new Integer(i));
            }
            ++i;
        }
        boolean client = true;
        if (clientServer == 0) {
            client = false;
        }
        MessageDialog dialog = new MessageDialog(this.getShell(), "Clean Project", null, "Do you want to clean the project of the webservices files and references ?\nWarning, this operation may delete some files you want to keep.", 4, new String[]{"Proceed", "Skip"}, 1);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.performClean(alias);
        }
        try {
            process.generateServiceFromWSDL(this.mm_project, am, serviceName, client, false, minOccurIsNillable);
        }
        catch (Exception ex) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)ex);
            this.mm_guiSystem.showErrorMessage("Error", "Cannot process the methods", ex);
            GenerateServiceFromWsdl.REPORT_GENERATION.add(new InformationReport("Creation Portal Webservice is fail!", null, 2));
            return false;
        }
        GenerateServiceFromWsdl.REPORT_GENERATION.add(new InformationReport("Creation Portal Webservice is successful!", null, 0));
        return true;
    }

    public void performClean(String alias) {
        boolean result = true;
        try {
            WebServicesProcessEP6 processEp6 = new WebServicesProcessEP6();
            File currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(this.mm_project));
            File srcApi = OpentoolsFactory.getIDEInstance().getSrcPath(this.mm_project, 0);
            File portalapp = new File(currentProjectFolder, "dist" + File.separator + "PORTAL-INF" + File.separator + "portalapp.xml");
            if (portalapp.exists()) {
                result = processEp6.cleanWebServiceProject(alias, this.mm_project, currentProjectFolder, srcApi, portalapp);
            } else {
                this.mm_guiSystem.showErrorMessage("Error", "The portalapp.xml file does not exist.", new Exception("The clean failed."));
            }
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "An error occurred while deleting the wenservices files and references.", e, this.getShell());
        }
        if (!result) {
            this.mm_guiSystem.showErrorMessage("Error", "One of the Clean operations failed.", new Exception("The clean failed."));
        }
    }

    private void constructListMethod() {
        String[] methods = mm_generator.getOperations();
        this.mm_namemethods = new Vector();
        int i = 0;
        while (i < methods.length) {
            this.mm_namemethods.add(new MethodRep(methods[i]).getSignature());
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        Tree tree = null;
        tree = this.mm_noWsdl ? new Tree(parent, 0) : (mm_generator.getOperations().length > 0 ? new Tree(parent, 32) : new Tree(parent, 0));
        tree.addSelectionListener((SelectionListener)new MySelectionAdapter());
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 180;
        tree.setLayoutData((Object)data);
        mm_viewer = new CheckboxTreeViewer(tree);
        this.mm_drillDownAdapter = new DrillDownAdapter((TreeViewer)mm_viewer);
        mm_content = new ViewContentProvider();
        mm_viewer.setContentProvider((IContentProvider)mm_content);
        mm_viewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public boolean canFlipToNextPage() {
        try {
            boolean[] cheked = this.getCheckedMethods();
            int i = 0;
            while (i < cheked.length) {
                if (cheked[i]) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            return false;
        }
        return false;
    }

    static {
        mm_generator = null;
    }

    class MySelectionAdapter
    extends SelectionAdapter {
        MySelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            WebWsdlMethodPage.this.setPageComplete(false);
        }
    }

    class TreeObject
    implements IAdaptable {
        private String name;
        private TreeParent parent;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(ResourcesPlugin.getWorkspace())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object[] getElements() {
            return this.getElements(this.invisibleRoot);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            if (mm_generator != null) {
                this.invisibleRoot = new TreeParent("");
                if (!WebWsdlMethodPage.this.mm_noWsdl) {
                    WebWsdlMethodPage.this.constructListMethod();
                    Enumeration enumeration = WebWsdlMethodPage.this.mm_namemethods.elements();
                    while (enumeration.hasMoreElements()) {
                        String element = (String)enumeration.nextElement();
                        TreeParent methodButton = null;
                        WebWsdlMethodPage.this.mm_checkedButtons.add(methodButton);
                        methodButton = new TreeParent(element);
                        this.invisibleRoot.addChild(methodButton);
                    }
                    if (WebWsdlMethodPage.this.mm_namemethods.isEmpty()) {
                        WebWsdlMethodPage.this.mm_emptyTree = true;
                        TreeParent emptyWsdl = null;
                        emptyWsdl = new TreeParent("There is no services into the wsdl file");
                        this.invisibleRoot.addChild(emptyWsdl);
                    }
                } else {
                    TreeParent emptyWsdl = null;
                    emptyWsdl = new TreeParent("Cannot read the wsdl file - please check the URL");
                    this.invisibleRoot.addChild(emptyWsdl);
                }
            }
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children = new ArrayList();

        public TreeParent(String name) {
            super(name);
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            ((AbstractCollection)this.children).remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }
}

