/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.gui.swt.WebWsdlComposite;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlMethodPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlPropertiesPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webwsdl.WebWsdlWizard;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.wsdl.GenerateServiceFromWsdl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WebWsdlChooserPage
extends WizardPage
implements IWebservicesWizardStringLiterals,
ModifyListener {
    public static File mm_wsdlFile = null;
    public static URL mm_wsdlUrl = null;
    private WebWsdlComposite mm_classPackageComposite;
    private IProject mm_project;
    private File mm_currentProjectFolder;
    private WebWsdlWizard mm_wizard = null;
    private GenerateServiceFromWsdl mm_generator = null;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();
    private Composite mm_parent = null;
    private WebWsdlMethodPage mm_pageMethod = null;
    private WebWsdlPropertiesPage mm_pageProperties = null;
    private String mm_previousWsdl = "";

    public WebWsdlChooserPage(Object project, WebWsdlWizard wizard) {
        super("");
        this.mm_project = (IProject)project;
        this.mm_wizard = wizard;
        this.setTitle("Portal Service from Wsdl file - Step 1");
        this.setDescription("Enter the Url of the Wsdl to use (Internet/Computer) or Browse (Computer):");
        this.setProject((IProject)project);
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        this.mm_currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
        if (this.mm_classPackageComposite != null) {
            this.mm_classPackageComposite.setProject(project);
        }
        if (this.mm_pageMethod != null) {
            this.mm_pageMethod.setProject(project);
        }
        try {
            this.mm_project.refreshLocal(2, null);
        }
        catch (CoreException ce) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)ce);
            this.mm_guiSystem.showErrorMessage("Error", "Cannot refresh the project.", ce);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mm_classPackageComposite.setFocus();
        }
    }

    public void createControl(Composite parent) {
        this.mm_parent = parent;
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        container.setLayout((Layout)new GridLayout());
        this.mm_classPackageComposite = new WebWsdlComposite(container, 0, this.mm_project);
        this.mm_classPackageComposite.addModifyListener(this);
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        this.mm_classPackageComposite.setFocus();
        this.modifyText(null);
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(true);
    }

    public String getUrlWsdl() {
        return this.mm_classPackageComposite.getWsdlUrl();
    }

    public void checkPage() throws Exception {
    }

    public GenerateServiceFromWsdl getGenerator() throws MalformedURLException, Exception {
        String value = this.getUrlWsdl();
        if (!value.equals(this.mm_previousWsdl)) {
            this.mm_previousWsdl = value;
            URL urlwsdl = null;
            try {
                urlwsdl = new URL(value);
            }
            catch (Exception ex) {
                File filetest = new File(value);
                if (filetest.isFile()) {
                    urlwsdl = filetest.toURL();
                }
                MalformedURLException mue = new MalformedURLException("Cannot resolve the URL !");
                throw mue;
            }
            mm_wsdlUrl = urlwsdl;
            this.mm_generator = new GenerateServiceFromWsdl(this.mm_project.getLocation().toFile().getAbsolutePath(), urlwsdl.toString());
        }
        return this.mm_generator;
    }

    public boolean canFlipToNextPage() {
        return this.getUrlWsdl() != null && !this.getUrlWsdl().equalsIgnoreCase("");
    }

    public IWizardPage getNextPage() {
        IDESettings is = IDESettings.getInstance();
        is.setURLWSDL(this.mm_project, this.getUrlWsdl());
        this.mm_pageMethod = new WebWsdlMethodPage(this.mm_project, this, this.mm_wizard);
        this.mm_wizard.addPage((IWizardPage)this.mm_pageMethod);
        this.mm_pageProperties = new WebWsdlPropertiesPage(this.mm_project, this.mm_pageMethod);
        this.mm_wizard.addPage((IWizardPage)this.mm_pageProperties);
        return this.mm_pageMethod;
    }
}

