/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices;

import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.WebServicesProcessEP6;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesInterfaceChooserWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesMappingWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesPropertiesWizardPage;
import com.sap.portal.util.eclipse.FinishResult;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.mapping.InitMapping;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class WebServicesWizard
extends Wizard
implements INewWizard,
IPDKCustomComponentWizard,
IWebservicesWizardStringLiterals {
    public static String PROPERTIES_PAGE_NAME = "";
    private WebServicesInterfaceChooserWizardPage mm_interfacePage;
    private AbstractProfiles mm_profiles;
    private IProject mm_project = null;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();
    private Properties mm_mapping = null;
    static /* synthetic */ Class class$com$sapportals$portal$prt$service$soap$mapping$InitMapping;

    public WebServicesWizard() {
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        this.mm_project = firstElement != null && firstElement instanceof IResource ? ((IResource)firstElement).getProject() : Eclipse2IDE.getCurrentProject();
        InitMapping.getInstanceInit((InputStream)(class$com$sapportals$portal$prt$service$soap$mapping$InitMapping == null ? (class$com$sapportals$portal$prt$service$soap$mapping$InitMapping = WebServicesWizard.class$("com.sapportals.portal.prt.service.soap.mapping.InitMapping")) : class$com$sapportals$portal$prt$service$soap$mapping$InitMapping).getResourceAsStream("/types/soapTypes.xml"));
        this.mm_interfacePage = new WebServicesInterfaceChooserWizardPage(this.mm_project, this);
        this.addPage((IWizardPage)this.mm_interfacePage);
        this.setCurrentProject(this.mm_project);
        PortalPlugin.releaseCurrentReport();
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.mm_profiles = profiles;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page instanceof WebServicesPropertiesWizardPage && page.isPageComplete()) {
                return false;
            }
            if (page instanceof WebServicesMappingWizardPage && page.isPageComplete()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void performClean(String alias) {
        boolean result = true;
        try {
            WebServicesProcessEP6 processEp6 = new WebServicesProcessEP6();
            File currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(this.mm_project));
            File srcApi = OpentoolsFactory.getIDEInstance().getSrcPath(this.mm_project, 0);
            File portalapp = new File(currentProjectFolder, "dist" + File.separator + "PORTAL-INF" + File.separator + "portalapp.xml");
            if (portalapp.exists()) {
                result = processEp6.cleanWebServiceProject(alias, this.mm_project, currentProjectFolder, srcApi, portalapp);
            } else {
                this.mm_guiSystem.showErrorMessage("Error", "The portalapp.xml file does not exist.", new Exception("The clean failed."));
            }
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "An error occurred while deleting the webservices files and references.", e, this.getShell());
        }
        if (!result) {
            this.mm_guiSystem.showErrorMessage("Error", "One of the Clean operations failed.", new Exception("The clean failed."));
        }
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Generating Portal Web Service - ", 8);
                monitor.worked(1);
                monitor.subTask("Processing information: ");
                IWizardPage[] pages = WebServicesWizard.this.getPages();
                MessageDialog dialog = new MessageDialog(WebServicesWizard.this.getShell(), "Clean Project", null, "Do you want to clean the project of the webservices files and references ?\nWarning, this operation may delete some files you want to keep.", 4, new String[]{"Proceed", "Skip"}, 1);
                monitor.worked(1);
                int i = 0;
                while (i < pages.length) {
                    IWizardPage page = pages[i];
                    monitor.worked(1);
                    if (page instanceof WebServicesPropertiesWizardPage && page.isPageComplete()) {
                        monitor.subTask("Clean: ");
                        dialog.open();
                        WebServicesPropertiesWizardPage pageProperties = (WebServicesPropertiesWizardPage)page;
                        if (dialog.getReturnCode() == 0) {
                            WebServicesWizard.this.performClean(pageProperties.getAliasName());
                        }
                        monitor.worked(1);
                        monitor.subTask("Creating files: ");
                        pageProperties.finish();
                        monitor.worked(1);
                        try {
                            monitor.subTask("Refresh: ");
                            monitor.worked(1);
                            WebServicesWizard.this.mm_project.refreshLocal(2, null);
                        }
                        catch (CoreException ce) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)ce);
                            WebServicesWizard.this.mm_guiSystem.showErrorMessage("Error", "Cannot refresh the project.\n", ce);
                        }
                        monitor.worked(1);
                        monitor.done();
                        return;
                    }
                    if (page instanceof WebServicesMappingWizardPage && page.isPageComplete()) {
                        WebServicesMappingWizardPage pageMapping = (WebServicesMappingWizardPage)page;
                        monitor.subTask("Processing mapping: ");
                        pageMapping.finish();
                        monitor.worked(1);
                        monitor.subTask("Select and reveal: ");
                        try {
                            Eclipse2IDE.selectAndReveal((IResource)WebServicesWizard.this.mm_project, PortalPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
                        }
                        catch (Exception e) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                            WebServicesWizard.this.mm_guiSystem.showErrorMessage("Error", "An error has occured while refreshing the current view.", e, WebServicesWizard.this.getShell());
                        }
                        monitor.worked(1);
                        FinishResult report = PortalPlugin.getCurrentReport();
                        report.convertReport(JavaToWsdl.REPORT_GENERATION);
                        report.addInformationsInTaskView(WebServicesWizard.this.mm_project);
                        try {
                            monitor.subTask("Refresh: ");
                            monitor.worked(1);
                            WebServicesWizard.this.mm_project.refreshLocal(2, null);
                        }
                        catch (CoreException ce) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)ce);
                            WebServicesWizard.this.mm_guiSystem.showErrorMessage("Error", "Cannot refresh the project.\n", ce);
                        }
                        JavaToWsdl.REPORT_GENERATION.clear();
                        monitor.worked(1);
                        monitor.done();
                        return;
                    }
                    ++i;
                }
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
            return true;
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            return true;
        }
    }

    public void setCurrentProject(IProject project) {
        this.mm_project = project;
        this.mm_interfacePage.setProject(project);
    }

    public IProject getProject() {
        return this.mm_project;
    }

    public void setMapping(Properties properties) {
        this.mm_mapping = properties;
    }

    public Properties getMapping() {
        return this.mm_mapping;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

