/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.webservices.MethodRep;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesInterfaceChooserWizardPage;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import com.sapportals.portal.prt.service.soap.wsdl.MethodDesc;
import com.sapportals.portal.prt.service.soap.wsdl.ParamDesc;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.DrillDownAdapter;

public class WebServicesMethodWizardPage
extends WizardPage
implements IWebservicesWizardStringLiterals,
ModifyListener {
    private Object mm_project;
    private JavaToWsdl mm_generator = null;
    private boolean mm_generateCustomsSerializer = false;
    private File mm_currentProjectFolder;
    private WebServicesInterfaceChooserWizardPage mm_interfacePage = null;
    private CheckboxTreeViewer mm_viewer;
    private Tree mm_tree;
    private DrillDownAdapter mm_drillDownAdapter;
    private ViewContentProvider mm_content;
    private Vector mm_methods = null;
    private Vector mm_namemethods = new Vector();
    private Vector mm_checkedButtons = new Vector();
    private boolean mm_alreadyDisplayed = false;
    private Composite mm_container = null;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();

    public WebServicesMethodWizardPage(Object project, WebServicesInterfaceChooserWizardPage interfacePage) {
        super("");
        this.mm_project = project;
        this.mm_interfacePage = interfacePage;
        this.mm_generateCustomsSerializer = false;
        this.setTitle("Portal Web Service from Portal Service - Step 2");
        this.setDescription("Select the method(s) to expose:");
        this.setProject((IProject)project);
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        this.mm_currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
        if (this.mm_viewer != null && this.mm_tree != null) {
            this.mm_tree.removeAll();
            this.mm_content = new ViewContentProvider();
            this.mm_viewer.setContentProvider((IContentProvider)this.mm_content);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        try {
            this.mm_generator = this.mm_interfacePage.getGenerator();
        }
        catch (Exception e1) {
            this.mm_generator = null;
            this.setPageComplete(false);
        }
        this.mm_container = new Composite(parent, 0);
        this.mm_container.setLayout((Layout)new GridLayout());
        this.createPartControl(this.mm_container);
        Button flatListButton = new Button(this.mm_container, 8);
        flatListButton.setText("Select All");
        flatListButton.setLayoutData((Object)new GridData(256));
        flatListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] leaves = WebServicesMethodWizardPage.this.mm_content.getElements();
                int i = 0;
                while (i < leaves.length) {
                    WebServicesMethodWizardPage.this.mm_viewer.setChecked(leaves[i], true);
                    ++i;
                }
                WebServicesMethodWizardPage.this.setPageComplete(true);
            }
        });
        Button unselectButton = new Button(this.mm_container, 8);
        unselectButton.setText("Unselect All");
        unselectButton.setLayoutData((Object)new GridData(256));
        unselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] leaves = WebServicesMethodWizardPage.this.mm_content.getElements();
                int i = 0;
                while (i < leaves.length) {
                    WebServicesMethodWizardPage.this.mm_viewer.setChecked(leaves[i], false);
                    ++i;
                }
                WebServicesMethodWizardPage.this.setPageComplete(true);
            }
        });
        Text text = new Text(this.mm_container, 0);
        text.setText("** are for complex methods");
        Display display = this.getShell().getDisplay();
        text.setBackground(new Color((Device)display, 212, 208, 200));
        this.setControl((Control)this.mm_container);
        this.mm_container.setFocus();
        this.modifyText(null);
    }

    public void modifyText(ModifyEvent e) {
    }

    public void checkPage() throws Exception {
    }

    public boolean[] getCheckedMethods() {
        Object[] leaves = this.mm_content.getElements();
        boolean[] index = new boolean[leaves.length];
        int i = 0;
        while (i < leaves.length) {
            boolean selected = this.mm_viewer.getChecked(leaves[i]);
            if (selected) {
                index[i] = true;
                if (leaves[i].toString().endsWith("**")) {
                    this.mm_generateCustomsSerializer = true;
                }
            } else {
                index[i] = false;
            }
            ++i;
        }
        return index;
    }

    public boolean performFinishMethods(JavaToWsdl generator) {
        this.mm_generator = generator;
        Vector allowedMethods = new Vector();
        Vector restrictMethods = new Vector();
        Vector allMethods = new Vector();
        boolean[] index = this.getCheckedMethods();
        allMethods = this.mm_generator.getMethods();
        int i = 0;
        while (i < index.length) {
            if (index[i]) {
                allowedMethods.add(allMethods.get(i));
            } else {
                restrictMethods.add(allMethods.get(i));
            }
            ++i;
        }
        if (allowedMethods.size() > 0) {
            this.mm_generator.setAllowedMethods(allowedMethods);
            this.mm_generator.setDisallowedMethods(restrictMethods);
            return true;
        }
        return false;
    }

    public boolean useGeneratorSerializers() {
        return this.mm_generateCustomsSerializer;
    }

    private void constructListMethod() {
        if (this.mm_generator == null) {
            return;
        }
        this.mm_methods = this.mm_generator.getMethods();
        boolean complexMethod = false;
        int i = 0;
        while (i < this.mm_methods.size()) {
            complexMethod = false;
            MethodDesc m = (MethodDesc)this.mm_methods.get(i);
            String namemethod = m.getName();
            Vector params = m.getParameters();
            namemethod = namemethod + "( ";
            int j = 0;
            while (j < params.size()) {
                ParamDesc p = (ParamDesc)params.get(j);
                namemethod = namemethod + WebServicesMethodWizardPage.cleanNameClass(p.getType()) + " , ";
                if (!p.getType().isArray() && !ToolKit.existsSerializerForType((Class)p.getType())) {
                    complexMethod = true;
                }
                ++j;
            }
            if (params.size() > 0) {
                namemethod = namemethod.substring(0, namemethod.length() - 3);
            }
            namemethod = namemethod + " ) :" + WebServicesMethodWizardPage.cleanNameClass(m.getReturns().getType());
            if (!m.getReturns().getType().isArray()) {
                if (!ToolKit.existsSerializerForType((Class)m.getReturns().getType())) {
                    complexMethod = true;
                }
            } else {
                complexMethod = true;
            }
            MethodRep mrep = new MethodRep(namemethod);
            mrep.setComplexType(complexMethod);
            this.mm_namemethods.addElement(mrep);
            ++i;
        }
    }

    public static String cleanNameClass(Class clazz) {
        String type = clazz.getName();
        if (clazz.isArray()) {
            String newtype = "";
            switch (type.charAt(1)) {
                case 'B': {
                    newtype = "byte";
                    break;
                }
                case 'C': {
                    newtype = "char";
                    break;
                }
                case 'D': {
                    newtype = "double";
                    break;
                }
                case 'F': {
                    newtype = "float";
                    break;
                }
                case 'I': {
                    newtype = "int";
                    break;
                }
                case 'J': {
                    newtype = "long";
                    break;
                }
                case 'L': {
                    newtype = type.substring(2, type.length() - 1);
                    break;
                }
                case 'S': {
                    newtype = "short";
                    break;
                }
                case 'Z': {
                    newtype = "boolean";
                    break;
                }
                case 'V': {
                    newtype = "void";
                    break;
                }
                default: {
                    newtype = "String";
                }
            }
            return newtype + "[]";
        }
        StringTokenizer ps = new StringTokenizer(type, ".");
        if (ps.countTokens() > 1) {
            String newtype = "";
            while (ps.hasMoreElements()) {
                newtype = ps.nextToken();
            }
            return newtype;
        }
        return type;
    }

    public void createPartControl(Composite parent) {
        this.mm_tree = this.mm_generator == null ? new Tree(parent, 0) : (this.mm_generator.getMethods().isEmpty() ? new Tree(parent, 0) : new Tree(parent, 32));
        this.mm_tree.addSelectionListener((SelectionListener)new MySelectionAdapter());
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 180;
        this.mm_tree.setLayoutData((Object)data);
        this.mm_viewer = new CheckboxTreeViewer(this.mm_tree);
        this.mm_drillDownAdapter = new DrillDownAdapter((TreeViewer)this.mm_viewer);
        this.mm_content = new ViewContentProvider();
        this.mm_viewer.setContentProvider((IContentProvider)this.mm_content);
        this.mm_viewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public boolean canFlipToNextPage() {
        if (this.mm_generator == null) {
            return false;
        }
        boolean[] cheked = this.getCheckedMethods();
        Vector allMethods = new Vector();
        allMethods = this.mm_generator.getMethods();
        boolean flag = false;
        boolean returnFlag = false;
        if (WebServicesInterfaceChooserWizardPage.RIGHT_INTERFACE_EXTEND) {
            int i = 0;
            while (i < cheked.length) {
                if (cheked[i]) {
                    returnFlag = true;
                    MethodDesc signature = (MethodDesc)allMethods.get(i);
                    if (signature.getSignature().indexOf("IPortalComponentRequest") != -1) {
                        flag = true;
                    }
                }
                ++i;
            }
            if (returnFlag) {
                if (flag) {
                    this.mm_guiSystem.showErrorMessage("Error", "Cannot follow operations if a method contening IPortalComponentRequest is selected.", new Exception("The generated Portal Web Service will not be working."));
                    return false;
                }
                return true;
            }
            return false;
        }
        if (!this.mm_alreadyDisplayed) {
            this.mm_guiSystem.showErrorMessage("Error", "The selected interface does not extend IService.", new Exception());
            this.mm_alreadyDisplayed = true;
        }
        return false;
    }

    class MySelectionAdapter
    extends SelectionAdapter {
        MySelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            WebServicesMethodWizardPage.this.setPageComplete(false);
        }
    }

    class TreeObject
    implements IAdaptable {
        private String name;
        private TreeParent parent;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(ResourcesPlugin.getWorkspace())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object[] getElements() {
            return this.getElements(this.invisibleRoot);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            this.invisibleRoot = new TreeParent("");
            if (WebServicesMethodWizardPage.this.mm_generator == null) {
                TreeParent empty = null;
                empty = new TreeParent("Cannot perform reflection on the selected interface.");
                this.invisibleRoot.addChild(empty);
            } else {
                WebServicesMethodWizardPage.this.constructListMethod();
                Enumeration enumeration = WebServicesMethodWizardPage.this.mm_namemethods.elements();
                if (!WebServicesMethodWizardPage.this.mm_namemethods.isEmpty()) {
                    while (enumeration.hasMoreElements()) {
                        MethodRep element = (MethodRep)enumeration.nextElement();
                        TreeParent methodButton = null;
                        WebServicesMethodWizardPage.this.mm_checkedButtons.add(methodButton);
                        methodButton = element.getComplexType() ? new TreeParent(element.getSignature() + "**") : new TreeParent(element.getSignature());
                        this.invisibleRoot.addChild(methodButton);
                    }
                } else {
                    TreeParent empty = new TreeParent("The interface contains no methods.");
                    this.invisibleRoot.addChild(empty);
                }
            }
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children = new ArrayList();

        public TreeParent(String name) {
            super(name);
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            ((AbstractCollection)this.children).remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }
}

