/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.gui.swt.WebServicesInterfaceComposite;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesMethodWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesPropertiesWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webservices.WebServicesWizard;
import com.sap.portal.util.Stream;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WebServicesInterfaceChooserWizardPage
extends WizardPage
implements IWebservicesWizardStringLiterals,
ModifyListener {
    public static boolean RIGHT_INTERFACE_EXTEND = false;
    private WebServicesInterfaceComposite mm_classPackageComposite;
    private IProject mm_project;
    private File mm_currentProjectFolder;
    private File mm_allClassesJar = null;
    private WebServicesWizard mm_wizard = null;
    private JavaToWsdl mm_generator = null;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();
    private WebServicesMethodWizardPage mm_pageMethod = null;
    private WebServicesPropertiesWizardPage mm_pageProperties = null;

    public WebServicesInterfaceChooserWizardPage(Object project, WebServicesWizard wizard) {
        super("");
        this.mm_project = (IProject)project;
        this.mm_wizard = wizard;
        this.setTitle("Portal Web Service from Portal Service - Step 1");
        this.setDescription("Select the Portal Service Interface to publish:");
        this.setProject((IProject)project);
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        this.mm_currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
        if (this.mm_classPackageComposite != null) {
            this.mm_classPackageComposite.setProject(project);
        }
        if (this.mm_pageMethod != null) {
            this.mm_pageMethod.setProject(project);
        }
        if (this.mm_pageProperties != null) {
            this.mm_pageProperties.setProject(project);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mm_classPackageComposite.setFocus();
        }
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        container.setLayout((Layout)new GridLayout());
        this.mm_classPackageComposite = new WebServicesInterfaceComposite(container, 0, this.mm_project);
        this.mm_classPackageComposite.addModifyListener(this);
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        this.mm_classPackageComposite.setFocus();
        this.modifyText(null);
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(false);
    }

    public String getClassName() {
        return this.mm_classPackageComposite.getClassName();
    }

    public String getClassPackage() {
        return this.mm_classPackageComposite.getClassPackage();
    }

    public String getEnteredValue() {
        return this.mm_classPackageComposite.getEnteredValue();
    }

    public void checkPage() throws Exception {
    }

    public JavaToWsdl getGenerator() throws IOException, MalformedURLException, JavaModelException, Exception {
        if (!this.isCurrentPage()) {
            return this.mm_generator;
        }
        Eclipse2IDE eclipse = new Eclipse2IDE();
        File outFile = null;
        try {
            outFile = eclipse.getOutPath(this.mm_project, 0);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "No output path found. Please check your project", e);
            throw e;
        }
        String classPathString = null;
        try {
            classPathString = this.getClassPackage();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "No class path found.", e);
            throw e;
        }
        Class<?> clazz = null;
        JavaToWsdl generator = null;
        if (classPathString.equalsIgnoreCase("") || classPathString.equals(null)) {
            return null;
        }
        this.mm_allClassesJar = new File(outFile.getParent() + "tempClasses.jar");
        FileOutputStream out = null;
        try {
            this.mm_allClassesJar.createNewFile();
            out = new FileOutputStream(this.mm_allClassesJar);
        }
        catch (FileNotFoundException fnfe) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)fnfe);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to load the selected interface.", fnfe);
        }
        catch (IOException ioex) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)ioex);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to process the selected interface.", ioex);
        }
        ZipOutputStream classesZos = new ZipOutputStream(out);
        try {
            this.makeJar(null, classesZos, outFile);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to load the classes of the project.", e);
            throw e;
        }
        try {
            ((FilterOutputStream)classesZos).flush();
            classesZos.finish();
            classesZos.close();
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)ioe);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to process the classes of the project.\nPlease check that your project is compiled.", ioe);
            throw ioe;
        }
        URL classesURL = null;
        try {
            classesURL = this.mm_allClassesJar.toURL();
        }
        catch (MalformedURLException mue) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)mue);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to link the classes of the project.", mue);
            throw mue;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.mm_project);
        IClasspathEntry[] librariesEntries = null;
        try {
            librariesEntries = javaProject.getRawClasspath();
        }
        catch (JavaModelException jme) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)jme);
            this.mm_guiSystem.showErrorMessage("Error", "Cannot get the libraries of the project", jme);
            throw jme;
        }
        URL[] urls = new URL[librariesEntries.length + 1];
        urls[0] = classesURL;
        if (librariesEntries != null) {
            int i = 1;
            while (i < librariesEntries.length + 1) {
                IClasspathEntry classEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)librariesEntries[i - 1]);
                IPath classPath = classEntry.getPath();
                try {
                    urls[i] = classPath.toFile().toURL();
                }
                catch (MalformedURLException mue) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)mue);
                    this.mm_guiSystem.showErrorMessage("Error", "URL of" + classPath.toOSString() + " malformed", mue);
                    throw mue;
                }
                ++i;
            }
        }
        URLClassLoader UrlCl = new URLClassLoader(urls, this.getClass().getClassLoader());
        ClassLoader pluginClassLoader = this.getClass().getClassLoader();
        pluginClassLoader = UrlCl;
        try {
            this.getClass();
            clazz = Class.forName(classPathString, false, UrlCl);
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Class<?> interf = interfaces[i];
                if ("com.sapportals.portal.prt.service.IService".equals(interf.getName())) {
                    RIGHT_INTERFACE_EXTEND = true;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)ex);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to perform reflection on the selected interface.", ex);
            throw ex;
        }
        try {
            generator = new JavaToWsdl(clazz);
        }
        catch (Exception e1) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
            this.mm_guiSystem.showErrorMessage("Error", "Unable to load the selected interface. Please check the methods signatures.", e1);
            throw e1;
        }
        this.mm_generator = generator;
        return generator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeJar(String zipEntryNamePrefix, ZipOutputStream zos, File directory) throws Exception {
        zipEntryNamePrefix = zipEntryNamePrefix == null || zipEntryNamePrefix.trim().equals("") ? "" : zipEntryNamePrefix + "/";
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = zipEntryNamePrefix + file.getName();
            if (file.isDirectory()) {
                this.makeJar(name, zos, file);
            } else {
                Object var11_10;
                try {
                    try {
                        if (file.getAbsolutePath().endsWith(".class")) {
                            ZipEntry newEntry = new ZipEntry(name);
                            newEntry.setSize(file.length());
                            zos.putNextEntry(newEntry);
                            Stream.copyStream(new FileInputStream(file), zos);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    zos.closeEntry();
                    throw throwable;
                }
                zos.closeEntry();
            }
            ++i;
        }
        return;
    }

    public boolean canFlipToNextPage() {
        String test = this.mm_classPackageComposite.getEnteredValue();
        return test != null && !test.equalsIgnoreCase("");
    }

    public IWizardPage getNextPage() {
        if (this.isCurrentPage()) {
            this.mm_pageMethod = new WebServicesMethodWizardPage(this.mm_project, this);
            this.mm_pageProperties = new WebServicesPropertiesWizardPage(this.mm_project, this, this.mm_pageMethod, this.mm_wizard);
            this.mm_wizard.addPage((IWizardPage)this.mm_pageMethod);
            this.mm_wizard.addPage((IWizardPage)this.mm_pageProperties);
            return this.mm_pageMethod;
        }
        this.mm_pageMethod = new WebServicesMethodWizardPage(this.mm_project, this);
        try {
            this.getGenerator();
        }
        catch (Exception e) {
            return null;
        }
        return this.mm_pageMethod;
    }
}

