/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webserializer;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.gui.swt.WebSerializerComposite;
import com.sap.portal.developmentTools.general.wizards.webservices.IWebservicesWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.webserializer.WebSerializerWizard;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WebSerializerWizardPage
extends WizardPage
implements IWebservicesWizardStringLiterals,
ModifyListener {
    public static boolean RIGHT_INTERFACE_EXTEND = false;
    private WebSerializerComposite mm_classPackageComposite;
    private IProject mm_project;
    private File mm_currentProjectFolder;
    private WebSerializerWizard mm_wizard = null;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();

    public WebSerializerWizardPage(WebSerializerWizard wizard, IProject project) {
        super("");
        this.mm_project = project;
        this.mm_wizard = wizard;
        this.setTitle("Serializer");
        this.setDescription("Select the class or interface to serialize:");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mm_classPackageComposite.setProject(this.mm_project);
        if (visible) {
            this.mm_classPackageComposite.setFocus();
        }
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        this.mm_currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
        if (this.mm_classPackageComposite != null) {
            this.mm_classPackageComposite.setProject(project);
        }
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        container.setLayout((Layout)new GridLayout());
        this.mm_classPackageComposite = new WebSerializerComposite(container, 0, this.mm_project);
        this.mm_classPackageComposite.addModifyListener(this);
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        this.mm_classPackageComposite.setFocus();
        this.modifyText(null);
    }

    public void modifyText(ModifyEvent e) {
        String clazz = this.getClassValue();
        String alias = this.getAliasValue();
        if (clazz != null && !clazz.equalsIgnoreCase("") && alias != null && !alias.equalsIgnoreCase("")) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public String getClassName() {
        return this.mm_classPackageComposite.getClassName();
    }

    public String getClassPackage() {
        return this.mm_classPackageComposite.getClassPackage();
    }

    public String getClassValue() {
        return this.mm_classPackageComposite.getEnteredValue();
    }

    public String getAliasValue() {
        return this.mm_classPackageComposite.getAliasName();
    }

    public boolean getGetterSetter() {
        return this.mm_classPackageComposite.getGetterSetterLimitation();
    }

    public URL getWsdlUrl() {
        String path = this.mm_classPackageComposite.getWsdlPath();
        if (path == null || path == "") {
            return null;
        }
        File wsdl = new File(path);
        URL result = null;
        try {
            result = wsdl.toURL();
        }
        catch (MalformedURLException e) {
            this.mm_guiSystem.showErrorMessage("Error", "The path entered is not valid.\nNo reference will be added to any Wsdl.", e);
            SapPortalPluginsLogger.logWarning((Object)this, (Throwable)e);
        }
        return result;
    }

    public void checkPage() throws Exception {
    }
}

