/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapnewproject;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapnewproject.SAPNPWizardPage;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class SAPNSPWizard
extends Wizard
implements INewWizard,
ISAPNPWizardStringLiterals {
    private SAPNPWizardPage wpage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.wpage = new SAPNPWizardPage(true);
        this.setWindowTitle("New Portal Application Project");
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wpage);
    }

    public boolean performFinish() {
        try {
            Shell parentGUIThing = this.getShell();
            boolean success = true;
            IGUI guiSystem = OpentoolsFactory.getGuiSystem();
            try {
                IDESettings iset = IDESettings.getInstance();
                iset.setProjectRootRootFolder(this.wpage.getProjectRootRootFolderName());
            }
            catch (Exception e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
            }
            File f = new File(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
            if (f.exists()) {
                String errorMessage = "Folder " + this.wpage.getProjectName() + " already exists as subfolder of " + this.wpage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
                System.out.println(errorMessage);
                guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
                success = false;
            }
            if (success) {
                try {
                    OpentoolsFactory.getEPInstance().createNewServiceProject(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
                }
                catch (Exception fnfex) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)fnfex);
                    guiSystem.showErrorMessage("Error", "An error has occured while trying to create the project structure", fnfex, parentGUIThing);
                }
            }
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        return true;
    }
}

