/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapnewproject;

import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.ModifyListenerDelegator;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.ISAPNPWizardPage;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.SAPNewProjectWizardTemplate;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.util.Files;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class SAPNPWizardPage
extends WizardPage
implements ISAPNPWizardStringLiterals,
ISAPNPWizardPage,
ModifyListener {
    private LabeledTextField mm_projectNameField;
    private LabeledBrowsableTextField mm_projectRootFolderField;
    private List mm_allProjectNames = new ArrayList();
    String mm_projectRootRootFolderName = "";
    private boolean mm_configurationChecked = false;
    private boolean mm_isServiceProject;

    protected SAPNPWizardPage(boolean isServiceProject) {
        super("Portal Application Project");
        this.mm_isServiceProject = isServiceProject;
        try {
            IWorkspaceRoot root = PortalPlugin.getWorkspace().getRoot();
            IResource[] members = root.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IProject) {
                    this.mm_allProjectNames.add(member.getName());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        this.setTitle(this.mm_isServiceProject ? "New Portal Application Project" : "Portal Application Project");
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        container.setLayout((Layout)new GridLayout(1, false));
        this.mm_projectNameField = new LabeledTextField(container, 0, "Project name:");
        this.mm_projectNameField.setToolTipText("The name of your new project");
        this.mm_projectNameField.setValue(this.mm_isServiceProject ? "NewServiceProject" : "NewParProject");
        this.mm_projectRootFolderField = new LabeledBrowsableTextField(container, 0, "Project root folder:");
        this.mm_projectRootFolderField.setValue(this.mm_projectRootRootFolderName);
        this.mm_projectRootFolderField.setFileSelectionMode(1);
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.mm_projectNameField);
        labelGroup.add(this.mm_projectRootFolderField);
        labelGroup.alignTextFields();
        ModifyListenerDelegator validator = new ModifyListenerDelegator(this);
        this.mm_projectNameField.getTextField().addModifyListener((ModifyListener)validator);
        this.mm_projectRootFolderField.getTextField().addModifyListener((ModifyListener)validator);
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-newProject");
    }

    public void setVisible(boolean visible) {
        if (!this.mm_configurationChecked && !SAPNewProjectWizardTemplate.initializeWizardPage(this.getContainer().getShell(), this)) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"Error", (String)"Could not connect to PDK.\n\nPlease ensure that the PDK settings are correct, and that the connection to the PDK is working.\nThe PDK must be running for the connection to work!\n(You can change the settings in 'Window/Preferences')");
            this.getContainer().getShell().close();
        }
        this.mm_configurationChecked = true;
        super.setVisible(visible);
        if (visible) {
            this.mm_projectNameField.setFocus();
            Text textField = this.mm_projectNameField.getTextField();
            textField.setSelection(0, textField.getText().length());
        }
    }

    public void modifyText(ModifyEvent e) {
        String projectName = this.getProjectName();
        if (projectName == null || projectName.trim().equals("")) {
            this.setErrorMessage("Please specify a project name.");
            return;
        }
        if (this.mm_allProjectNames.contains(projectName)) {
            this.setErrorMessage("Project name " + projectName + " already exists in this workspace.");
            return;
        }
        String rootFolder = this.getProjectRootRootFolderName();
        File rootFolderFile = new File(rootFolder);
        if (rootFolderFile.exists() && rootFolderFile.isFile()) {
            this.setErrorMessage("Root folder " + rootFolder + " is a file, not a directory.");
            return;
        }
        File projectFolderFile = new File(rootFolderFile, projectName);
        String absolutePath = projectFolderFile.getAbsolutePath();
        if (!Files.isValidFileName(absolutePath)) {
            this.setErrorMessage(absolutePath + " is not a valid file name.");
            return;
        }
        if (projectFolderFile.exists()) {
            this.setErrorMessage("File/Folder " + projectFolderFile + " already exists.");
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String s) {
        super.setErrorMessage(s);
        this.setPageComplete(s == null);
    }

    public String getProjectName() {
        return this.mm_projectNameField.getValue();
    }

    public void setProjectRootRootFolderName(String name) {
        if (this.mm_projectRootFolderField != null) {
            this.mm_projectRootFolderField.setValue(name);
        }
        this.mm_projectRootRootFolderName = name;
    }

    public String getProjectRootRootFolderName() {
        return this.mm_projectRootFolderField.getValue();
    }
}

