/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapnewproject;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.SAPNewProjectWizardTemplate;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapnewproject.SAPNPWizardPage;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class SAPNPWizard
extends Wizard
implements INewWizard,
ISAPNPWizardStringLiterals {
    private SAPNPWizardPage mm_wpage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.mm_wpage = new SAPNPWizardPage(false);
        this.setWindowTitle("New");
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.setNeedsProgressMonitor(true);
        SAPNewProjectWizardTemplate.initializeWizardPage(this.getShell(), this.mm_wpage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mm_wpage);
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block12: {
                    IProject project = null;
                    IGUI guiSystem = OpentoolsFactory.getGuiSystem();
                    Shell parentGUIThing = SAPNPWizard.this.getShell();
                    monitor.beginTask("Processing Project Creation - ", 16);
                    monitor.worked(1);
                    monitor.subTask("Initialization: ");
                    monitor.worked(1);
                    try {
                        boolean success = true;
                        try {
                            IDESettings iset = IDESettings.getInstance();
                            iset.setProjectRootRootFolder(SAPNPWizard.this.mm_wpage.getProjectRootRootFolderName());
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                            guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
                        }
                        File f = new File(SAPNPWizard.this.mm_wpage.getProjectRootRootFolderName(), SAPNPWizard.this.mm_wpage.getProjectName());
                        if (f.exists()) {
                            String errorMessage = "Folder " + SAPNPWizard.this.mm_wpage.getProjectName() + " already exists as subfolder of " + SAPNPWizard.this.mm_wpage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
                            System.out.println(errorMessage);
                            guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
                            success = false;
                            monitor.worked(1);
                        }
                        monitor.subTask("Creating the project files: ");
                        monitor.worked(1);
                        success = SAPNewProjectWizardTemplate.finishNewProjectWizard(SAPNPWizard.this.mm_wpage, SAPNPWizard.this.getShell(), false);
                        if (!success) break block12;
                        project = (IProject)SAPNewProjectWizardTemplate.project;
                        IPreferenceStore store = PortalPlugin.getDefault().getPreferenceStore();
                        String libs = "true";
                        try {
                            libs = store.getString("com.sap.developmentTools.libs");
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        }
                        if (!libs.equalsIgnoreCase("true") && !libs.equalsIgnoreCase("")) break block12;
                        try {
                            monitor.subTask("Setting Classpath: ");
                            URL pluginUrl = PortalPlugin.getIPluginDescriptor().find((IPath)new Path(""));
                            String portalPluginPath = pluginUrl.getFile();
                            portalPluginPath = "ECLIPSE_HOME" + File.separator + portalPluginPath.substring(portalPluginPath.indexOf("plugins"));
                            String eclipsePath = System.getProperty("user.dir");
                            String[] sapIdePaths = new String[]{"com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib", "com.sap.security" + File.separator + "lib", "com.sap.ext.libs.webservices" + File.separator + "lib", "com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib", "com.sap.ext.libs.webservices" + File.separator + "lib", "com.tssap.sap.libs.xmltoolkit" + File.separator + "lib", "com.sap.engine.webservices" + File.separator + "lib"};
                            if (new File(eclipsePath + File.separator + "plugins" + File.separator + sapIdePaths[0]).isDirectory()) {
                                String[] portalLibs = new String[]{portalPluginPath + File.separator + "prtapi.jar", portalPluginPath + File.separator + "prttest.jar", portalPluginPath + File.separator + "com.sap.portal.runtime.application.soap_api.jar"};
                                String[] sapIdeLibs = new String[]{"activation.jar", "com.sap.security.api.jar", "jaxm-api.jar", "mail.jar", "saaj-api.jar", "sapxmltoolkit.jar", "webservices_lib.jar"};
                                monitor.worked(1);
                                OpentoolsFactory.getIDEInstance().addLibrariesReferences(project, portalLibs);
                                int i = 0;
                                while (i < sapIdeLibs.length) {
                                    String pluginPath = "ECLIPSE_HOME" + File.separator + "plugins" + File.separator;
                                    monitor.worked(1);
                                    OpentoolsFactory.getIDEInstance().addLibraryReference(project, pluginPath + sapIdePaths[i] + File.separator + sapIdeLibs[i]);
                                    ++i;
                                }
                            } else {
                                String[] allPortalLibs = new String[]{portalPluginPath + File.separator + "prtapi.jar", portalPluginPath + File.separator + "prttest.jar", portalPluginPath + File.separator + "com.sap.portal.runtime.application.soap_api.jar", portalPluginPath + File.separator + "sapxmltoolkit.jar", portalPluginPath + File.separator + "jaxm-api.jar", portalPluginPath + File.separator + "jaxp.jar", portalPluginPath + File.separator + "saaj-api.jar", portalPluginPath + File.separator + "com.sap.security.api.jar"};
                                monitor.worked(1);
                                OpentoolsFactory.getIDEInstance().addLibrariesReferences(project, allPortalLibs);
                            }
                        }
                        catch (Exception fnfex) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)fnfex);
                            guiSystem.showErrorMessage("Error", "An error has occured while tryi`ng to create the project classpath", fnfex, parentGUIThing);
                        }
                    }
                    catch (Exception e) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    }
                }
                monitor.worked(1);
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "An error has occured while running the performFinish method of the Wizard : " + e.toString(), e, this.getShell());
        }
        return true;
    }
}

