/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar;

import com.sap.netweaver.ep.core.preferences.Controller;
import com.sap.netweaver.ep.core.preferences.IServerConfigSelector;
import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledComboBox;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.sapmakepar.SAPMPWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCBuildWrapper;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCPropertiesHandler;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar.SAPMPWizard;
import com.sap.portal.util.Files;
import com.tssap.dii.component.DCUtil;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SAPMPWizardPage
extends WizardPage
implements SAPMPWizardStringLiterals,
ModifyListener,
SelectionListener {
    public static final String THIS_PROP_GROUP = "com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar";
    public static final String SAVE_BEFORE_PACKAGING_PROP_NAME = "saveBeforePackage";
    public static final String noShowName = "<don't launch any profile>";
    private String mm_parPathWithoutParMaking = "";
    private static String SAVED_PAR_PATH_WIHTOUT_PAR_MAKING = "";
    private String mm_parArchiveFileName;
    private boolean mm_zipArchiveSrc;
    private boolean mm_uploadArchive;
    private boolean mm_withoutParMaking;
    private String[] mm_quickstartPossibilities = new String[0];
    private String mm_quickstartSelection = "<don't launch any profile>";
    private Button mm_includeSrcButton;
    private Button mm_uploadButton;
    private LabeledBrowsableTextField mm_parNameField;
    private LabeledComboBox mm_quickstartProfileField;
    private IServerConfigSelector mm_selector;
    private Object mm_project;
    private boolean mm_dcProject = false;

    public SAPMPWizardPage() {
        super("PAR Export");
        this.setMessage("Specify the name of the PAR file for your Portal Application");
        this.setTitle("Create a PAR file from the Portal Application Project");
        this.setDescription("Specify the name of the PAR file for your Portal Application");
        this.mm_withoutParMaking = false;
    }

    public SAPMPWizardPage(boolean withoutParMaking, String parPath) {
        super("PAR Export");
        this.setMessage("Specify the location of the PAR file");
        this.setTitle("Upload a PAR file");
        this.setDescription("Specify the location of the PAR file");
        this.mm_withoutParMaking = true;
        this.mm_parPathWithoutParMaking = parPath;
    }

    public void setQuickstart(String[] quickstartPossibilities, String quickstartSelection) {
        if (this.mm_quickstartProfileField == null) {
            this.mm_quickstartPossibilities = quickstartPossibilities;
            this.mm_quickstartSelection = quickstartSelection;
        } else {
            this.mm_quickstartProfileField.setComboBoxItems(quickstartPossibilities, quickstartSelection);
        }
    }

    public String getQuickstartSelection() {
        if (this.mm_quickstartProfileField == null) {
            return this.mm_quickstartSelection;
        }
        Combo comboBox = this.mm_quickstartProfileField.getComboBox();
        return comboBox.getItems()[comboBox.getSelectionIndex()];
    }

    public void setParArchiveFileName(String parArchiveFileName) {
        if (this.mm_parNameField == null) {
            this.mm_parArchiveFileName = parArchiveFileName;
        } else {
            this.mm_parNameField.setValue(parArchiveFileName);
        }
    }

    public boolean isZipArchiveSrc() {
        return this.mm_includeSrcButton.getSelection();
    }

    public void setZipArchiveSrc(boolean zipIt) {
        this.mm_includeSrcButton.setSelection(zipIt);
    }

    public boolean isUploadArchive() {
        return this.mm_uploadButton.getSelection();
    }

    public void setUploadArchive(boolean uploadIt) {
        if (this.mm_uploadButton == null) {
            this.mm_uploadArchive = uploadIt;
        } else {
            if (this.mm_withoutParMaking) {
                this.mm_uploadButton.setSelection(true);
            } else {
                this.mm_uploadButton.setSelection(uploadIt);
            }
            this.mm_selector.setVisible(uploadIt);
        }
    }

    public void createControl(Composite composite) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(composite, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        this.mm_parNameField = new LabeledBrowsableTextField(container, 0, "PAR file:");
        this.mm_parNameField.setValue(this.mm_parArchiveFileName);
        this.mm_parNameField.setLayoutData(gd);
        this.mm_parNameField.getTextField().addModifyListener((ModifyListener)this);
        if (this.mm_withoutParMaking) {
            if (this.mm_parPathWithoutParMaking != null && this.mm_parPathWithoutParMaking != "") {
                this.mm_parNameField.setValue(this.mm_parPathWithoutParMaking);
            } else {
                this.mm_parNameField.setValue(SAVED_PAR_PATH_WIHTOUT_PAR_MAKING);
            }
        }
        this.mm_parNameField.setEditable(false);
        this.mm_includeSrcButton = new Button(container, 32);
        this.mm_includeSrcButton.setSelection(this.mm_zipArchiveSrc);
        this.mm_includeSrcButton.setText("Include the source code of the portal application");
        this.mm_includeSrcButton.setToolTipText("Check to Zip the source code into a private/srclib/parname.src.jar-file.");
        gd = new GridData(768);
        this.mm_includeSrcButton.setLayoutData((Object)gd);
        this.mm_uploadButton = new Button(container, 32);
        this.mm_uploadButton.setSelection(this.mm_uploadArchive);
        this.mm_uploadButton.setText("&Deploy PAR");
        this.mm_uploadButton.setToolTipText("Check to upload your PAR into your local portal.");
        this.mm_uploadButton.addSelectionListener((SelectionListener)this);
        gd = new GridData(768);
        this.mm_uploadButton.setLayoutData((Object)gd);
        if (this.mm_withoutParMaking) {
            this.mm_includeSrcButton.setVisible(false);
            this.mm_uploadButton.setVisible(false);
            this.mm_uploadButton.setSelection(true);
        }
        this.mm_selector = Controller.getInstance().includeServerConfigSelectorTo(container);
        container.setFocus();
        LabeledThingsGroup ltg = new LabeledThingsGroup();
        ltg.add(this.mm_parNameField);
        ltg.alignTextFields();
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-createPAR");
        this.mm_selector.addSelectionListener((SelectionListener)this);
        this.mm_selector.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                SAPMPWizardPage.super.getContainer().updateButtons();
            }
        });
        container.setFocus();
    }

    public void setVisible(boolean visible) {
        this.mm_project = ((SAPMPWizard)this.getWizard()).getSelectedProject();
        this.mm_dcProject = DCUtil.isDCProject((IProject)((IProject)this.mm_project));
        if (this.mm_dcProject) {
            this.mm_parNameField.setEditable(false);
            this.mm_parNameField.setEnabled(false);
            if (!DCBuildWrapper.checkModulePARProject((IProject)this.mm_project)) {
                System.out.println("not a PAR DC Project !! - Unable to upload");
                this.getWizard().performCancel();
            }
        } else {
            this.mm_parNameField.setEditable(true);
            this.mm_parNameField.setEnabled(true);
        }
        if (visible) {
            IDESettings iset = IDESettings.getInstance();
            if (!this.mm_withoutParMaking) {
                IProject project = ((SAPMPWizard)this.getWizard()).getSelectedProject();
                Shell guiThingForModalDialog = this.getContainer().getShell();
                IGUI guiSystem = OpentoolsFactory.getGuiSystem();
                IDE ideInstance = OpentoolsFactory.getIDEInstance();
                EP ep = OpentoolsFactory.getEPInstance();
                if (!this.mm_dcProject) {
                    this.mm_parArchiveFileName = iset.getArchiveName(project);
                    if (this.mm_parArchiveFileName == null) {
                        this.mm_parArchiveFileName = ideInstance.getCurrentProjectFolder(project) + File.separatorChar + ideInstance.getProjectName(project) + ".par";
                    } else if (!this.mm_parArchiveFileName.endsWith(".par")) {
                        this.mm_parArchiveFileName = this.mm_parArchiveFileName + ".par";
                    }
                } else {
                    String deployDir = DCBuildWrapper.getDeployFolder(project);
                    File deployDirFile = new File(deployDir);
                    String shortParFileName = DCPropertiesHandler.getParArchiveNameFromDcdef(project);
                    if (shortParFileName == null) {
                        shortParFileName = ideInstance.getProjectName(project);
                    }
                    this.mm_parArchiveFileName = deployDir + File.separator + shortParFileName + ".par";
                }
                this.setParArchiveFileName(this.mm_parArchiveFileName);
                this.setZipArchiveSrc(iset.isZipArchiveSrc(project));
                this.setUploadArchive(iset.isAutoUpload(project));
            } else if (this.mm_withoutParMaking) {
                if (this.mm_parPathWithoutParMaking != null && this.mm_parPathWithoutParMaking != "") {
                    this.setParArchiveFileName(this.mm_parPathWithoutParMaking);
                } else {
                    this.setParArchiveFileName(SAVED_PAR_PATH_WIHTOUT_PAR_MAKING);
                }
            }
        }
        super.setVisible(visible);
    }

    public void modifyText(ModifyEvent e) {
        String parName = this.mm_parNameField.getValue();
        if (this.mm_withoutParMaking) {
            if (!Files.isValidFileName(parName)) {
                this.setErrorMessage("PAR file: The portal archive file name must be a valid file name.");
                this.getContainer().updateButtons();
                return;
            }
        } else if (!parName.endsWith(".par")) {
            this.setErrorMessage("PAR file: The portal archive file extension must be .par.");
            this.getContainer().updateButtons();
            return;
        }
        this.mm_parArchiveFileName = parName;
        this.setErrorMessage(null);
        this.getContainer().updateButtons();
    }

    public void setSelectedProject(Object project) {
        this.mm_project = project;
    }

    private Object getSelectedProject() {
        return this.mm_project;
    }

    public IServerConfigSelector getServerConfigSelector() {
        return this.mm_selector;
    }

    public boolean isPageComplete() {
        boolean pageComplete;
        boolean bl = pageComplete = this.getErrorMessage() == null && this.mm_parArchiveFileName != null && !this.mm_parArchiveFileName.equals("");
        if (this.mm_uploadButton.getSelection()) {
            pageComplete &= this.mm_selector != null && this.mm_selector.getSelectedServerConfig() != null;
        }
        return pageComplete;
    }

    public void widgetSelected(SelectionEvent event) {
        this.mm_selector.setVisible(this.mm_uploadButton.getSelection());
        this.getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void setSavedParPathWihtoutParMaking(String parPath) {
        SAVED_PAR_PATH_WIHTOUT_PAR_MAKING = parPath;
    }

    public String getParArchiveFileName() {
        return this.mm_parArchiveFileName;
    }
}

