/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar;

import com.sap.netweaver.ep.core.preferences.IServerConfig;
import com.sap.netweaver.ep.core.preferences.IServerConfigSelector;
import com.sap.netweaver.ep.ui.EnterprisePortalPlugin;
import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.FileNotExistException;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IFinishResult;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.IParIdePlugin;
import com.sap.portal.developmentTools.general.api.IPropertySystem;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.iDE.AbstractIDE;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.sapmakepar.SAPMPWizardStringLiterals;
import com.sap.portal.developmentTools.general.wizards.upload.DeployEngine;
import com.sap.portal.developmentTools.general.wizards.upload.DeploymentException;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCBuildWrapper;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCPropertiesHandler;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar.SAPMPWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.selectProject.SelectAProjectWizardPage;
import com.sap.portal.util.eclipse.FinishResult;
import com.sap.portal.util.eclipse.FinishResultPool;
import com.sap.portal.util.eclipse.ProgressMonitors;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sap.tc.devconf.BuildException;
import com.tssap.dii.component.DCUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SAPMPWizard
extends Wizard
implements IExportWizard,
SAPMPWizardStringLiterals {
    protected IProject m_selectedProject;
    private boolean mm_status;
    private String mm_statusType;
    private String mm_statusMessage;
    private boolean mm_includeNonJavaSources = false;
    private boolean mm_shortNames = false;
    SAPMPWizardPage mm_myPage;
    SelectAProjectWizardPage mm_selectPage;
    private IServerConfig mm_server;
    private IServerConfigSelector mm_selector;
    private boolean mm_canceled = false;
    private boolean mm_withoutParMaking = false;
    private String mm_parPath;

    public SAPMPWizard() {
        this.mm_withoutParMaking = false;
    }

    public SAPMPWizard(boolean withoutParMaking, String parPath) {
        this.mm_withoutParMaking = withoutParMaking;
        this.mm_parPath = parPath;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.mm_myPage = this.mm_withoutParMaking ? new SAPMPWizardPage(this.mm_withoutParMaking, this.mm_parPath) : new SAPMPWizardPage();
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
    }

    public boolean performFinish() {
        this.mm_status = true;
        this.mm_selector = this.mm_myPage.getServerConfigSelector();
        IPreferenceStore store = EnterprisePortalPlugin.getDefault().getPreferenceStore();
        if (this.mm_myPage.isUploadArchive()) {
            this.mm_server = this.mm_selector.getSelectedServerConfig();
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block24: {
                    IDE ideInstance = OpentoolsFactory.getIDEInstance();
                    boolean shouldSaveAndRebuild = true;
                    Vector<IFinishResult> results = new Vector<IFinishResult>();
                    IGUI guiSystem = OpentoolsFactory.getGuiSystem();
                    try {
                        String fileName = SAPMPWizard.this.mm_myPage.getParArchiveFileName().trim();
                        boolean uploadArchive = SAPMPWizard.this.mm_myPage.isUploadArchive();
                        if (SAPMPWizard.this.mm_withoutParMaking) {
                            monitor.beginTask("Processing request...", 3);
                            monitor.worked(1);
                            boolean uploadSucceededOrOmitted = true;
                            try {
                                SAPMPWizard.this.mm_myPage.setSavedParPathWihtoutParMaking(fileName);
                                File prospectedParFile = new File(fileName);
                                monitor.worked(1);
                                this.processUpload(monitor, guiSystem, prospectedParFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                                uploadSucceededOrOmitted = true;
                                SAPMPWizard.this.mm_status = false;
                                SAPMPWizard.this.mm_statusMessage = e.getMessage();
                                SAPMPWizard.this.mm_statusType = e.getClass().getName();
                            }
                            monitor.worked(1);
                            if (uploadSucceededOrOmitted) {
                                SAPMPWizard.this.mm_status = true;
                            }
                            break block24;
                        }
                        SAPMPWizard.this.m_selectedProject = SAPMPWizard.this.getSelectedProject();
                        IDESettings is = IDESettings.getInstance();
                        IPropertySystem propSyst = OpentoolsFactory.getPropertySystemInstance();
                        is.setParArchiveName(SAPMPWizard.this.m_selectedProject, fileName);
                        is.setZipArchiveSrc(SAPMPWizard.this.mm_myPage.isZipArchiveSrc(), SAPMPWizard.this.m_selectedProject);
                        is.setAutoUpload(uploadArchive, SAPMPWizard.this.m_selectedProject);
                        propSyst.saveProperty("com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar", "saveBeforePackage", String.valueOf(shouldSaveAndRebuild), SAPMPWizard.this.m_selectedProject);
                        String parShortName = is.getParShortName(SAPMPWizard.this.m_selectedProject);
                        if (shouldSaveAndRebuild) {
                            monitor.beginTask("Processing request...", 4);
                            PortalPlugin.saveAllDirtyEditorsForProject(SAPMPWizard.this.m_selectedProject, ProgressMonitors.getTaskToSubtaskWrapper(monitor));
                            monitor.worked(1);
                        } else {
                            monitor.beginTask("Processing request...", 3);
                        }
                        monitor.subTask("Rebuilding the project...");
                        if (!ideInstance.rebuildCurrentProject(SAPMPWizard.this.m_selectedProject, new int[]{0}, 0)) {
                            SAPMPWizard.this.mm_status = false;
                            SAPMPWizard.this.mm_statusType = "Build error";
                            SAPMPWizard.this.mm_statusMessage = "Build of the project " + SAPMPWizard.this.m_selectedProject.getName() + " failed.";
                        }
                        if (SAPMPWizard.this.isDCProject()) {
                            DCPropertiesHandler.setZipSrc(SAPMPWizard.this.m_selectedProject, SAPMPWizard.this.mm_myPage.isZipArchiveSrc());
                            DCBuildWrapper dcBuilder = new DCBuildWrapper(monitor, SAPMPWizard.this.m_selectedProject);
                            dcBuilder.run();
                        }
                        if (!SAPMPWizard.this.mm_status) break block24;
                        monitor.worked(1);
                        boolean uploadSucceededOrOmitted = true;
                        try {
                            fileName = parShortName;
                            Enumeration enumeration = PortalPlugin.REGISTERED_PLUGINS.keys();
                            while (enumeration.hasMoreElements()) {
                                String pluginId = (String)enumeration.nextElement();
                                IParIdePlugin plugin = (IParIdePlugin)PortalPlugin.REGISTERED_PLUGINS.get(pluginId);
                                FinishResultPool.getInstance().release(pluginId);
                                IFinishResult result = FinishResultPool.getInstance().getReport(pluginId);
                                try {
                                    plugin.pack(SAPMPWizard.this.m_selectedProject, result);
                                }
                                catch (Throwable t) {
                                    result.setFinalState(2);
                                    result.addError("Additional Plugin Error - The Plugin \"" + pluginId + "\" caused an exception during the \"Pack\" operation.\nSee log for more details");
                                    MessageDialog.openError((Shell)SAPMPWizard.this.getShell(), (String)"Additional Plugin Error", (String)("The Plugin \"" + pluginId + "\" caused an exception during the \"Pack\" operation.\nSee log for more details"));
                                    SapPortalPluginsLogger.logError((Object)this, (Throwable)t, (String)("The Plugin \"" + pluginId + "\" caused an exception during the \"Pack\" operation"));
                                }
                                results.add(result);
                                ((FinishResult)result).addInformationsInTaskView(SAPMPWizard.this.m_selectedProject);
                                if (result.getFinalState() != 2) continue;
                                throw new Exception("Error in registered plugin \"" + pluginId + "\" !");
                            }
                            File prospectedParFile = new File(is.getArchiveName(SAPMPWizard.this.m_selectedProject) + ".par");
                            IPreferenceStore store = PortalPlugin.getDefault().getPreferenceStore();
                            String nonJavaSources = "false";
                            String shortNames = "false";
                            try {
                                nonJavaSources = store.getString("com.sap.developmentTools.sources");
                                shortNames = store.getString("com.sap.developmentTools.shortnames");
                            }
                            catch (Exception e) {
                                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                            }
                            if (nonJavaSources.equalsIgnoreCase("true")) {
                                SAPMPWizard.this.mm_includeNonJavaSources = true;
                            }
                            if (shortNames.equalsIgnoreCase("true")) {
                                SAPMPWizard.this.mm_shortNames = true;
                            }
                            monitor.subTask("Creating the archive...");
                            if (!SAPMPWizard.this.isDCProject()) {
                                EP epInstance = OpentoolsFactory.getEPInstance();
                                epInstance.makeParArchiveFromProject(SAPMPWizard.this.m_selectedProject, parShortName, prospectedParFile, is.isZipArchiveSrc(SAPMPWizard.this.m_selectedProject), SAPMPWizard.this.mm_includeNonJavaSources, SAPMPWizard.this.mm_shortNames);
                            }
                            monitor.worked(1);
                            if (uploadArchive) {
                                this.processUpload(monitor, guiSystem, prospectedParFile);
                            }
                        }
                        catch (FileNotExistException e) {
                            e.printStackTrace();
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                            uploadSucceededOrOmitted = true;
                            String fileNameRelativeToProjectRoot = AbstractIDE.getSlashSeparatedNameFromStringArray(e.getSegmentsInProject(), File.separatorChar);
                            SAPMPWizard.this.mm_status = false;
                            SAPMPWizard.this.mm_statusMessage = "Sorry, file " + e.getFile().getAbsolutePath() + " does not exist on harddisk,\nalthough it is referenced as " + fileNameRelativeToProjectRoot + " in the project.\nCancelling process.";
                            SAPMPWizard.this.mm_statusType = e.getClass().getName();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                            uploadSucceededOrOmitted = true;
                            SAPMPWizard.this.mm_status = false;
                            SAPMPWizard.this.mm_statusMessage = e.getMessage();
                            SAPMPWizard.this.mm_statusType = e.getClass().getName();
                        }
                        monitor.worked(1);
                        if (uploadSucceededOrOmitted) {
                            SAPMPWizard.this.mm_status = true;
                        }
                    }
                    catch (BuildException be) {
                        SAPMPWizard.this.mm_status = false;
                        SAPMPWizard.this.mm_statusType = "Build error";
                        SAPMPWizard.this.mm_statusMessage = "Build of the project " + SAPMPWizard.this.m_selectedProject.getName() + " failed.";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        SAPMPWizard.this.mm_status = false;
                        SAPMPWizard.this.mm_statusType = e.getClass().getName();
                        SAPMPWizard.this.mm_statusMessage = e.getMessage();
                    }
                }
                monitor.done();
            }

            private void processUpload(IProgressMonitor monitor, IGUI guiSystem, File prospectedParFile) {
                int uploadFinished = 0;
                monitor.subTask("Deploying archive...");
                do {
                    boolean uploadSucceededOrOmitted;
                    try {
                        DeployEngine deployEngine = new DeployEngine(SAPMPWizard.this.mm_server);
                        deployEngine.deploy(prospectedParFile);
                        uploadFinished = 0;
                    }
                    catch (UnknownHostException e) {
                        uploadFinished = guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "Operation failed: Unknown host \nPlease make sure the server '" + SAPMPWizard.this.mm_server.getAlias() + "' (" + SAPMPWizard.this.mm_server.getHost() + ":" + SAPMPWizard.this.mm_server.getPort() + ") exists and is running.", "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]);
                        if (uploadFinished == 0) {
                            SAPMPWizard.this.mm_canceled = true;
                        }
                        if (uploadFinished != 1) continue;
                        uploadSucceededOrOmitted = false;
                    }
                    catch (ConnectException e) {
                        e.printStackTrace();
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        uploadFinished = guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "Operation failed: " + e.getMessage() + "\nPlease make sure the server '" + SAPMPWizard.this.mm_server.getAlias() + "' (" + SAPMPWizard.this.mm_server.getHost() + ":" + SAPMPWizard.this.mm_server.getPort() + ") is running.", "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]);
                        if (uploadFinished == 0) {
                            SAPMPWizard.this.mm_canceled = true;
                        }
                        if (uploadFinished != 1) continue;
                        uploadSucceededOrOmitted = false;
                    }
                    catch (DeploymentException e) {
                        String response = e.getResponse();
                        String message = "";
                        if (e.getMessage() != null) {
                            message = e.getMessage();
                        }
                        SapPortalPluginsLogger.logError((Object)this, (String)("Upload Error message: " + e.getMessage()));
                        SapPortalPluginsLogger.logError((Object)this, (String)("Upload Response: " + response));
                        SapPortalPluginsLogger.logError((Object)this, (String)("Upload Target Component: " + e.getTargetComponent()));
                        uploadFinished = response != null ? (response.indexOf("<html>") != -1 ? guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "PAR upload failed: " + e.getTargetComponent() + ".\n" + "Please check the user ID and password.", "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]) : (response.indexOf("<?xml") != -1 ? guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "PAR upload failed: " + e.getTargetComponent() + ".\n" + "Please check the log (sap-plugin.log) for more detail.", "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]) : guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "PAR upload failed: " + e.getTargetComponent() + ".\n" + "No detail have been provided.", "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]))) : guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "PAR upload failed: " + e.getTargetComponent() + "." + "\nPlease make sure the server '" + SAPMPWizard.this.mm_server.getAlias() + "' (" + SAPMPWizard.this.mm_server.getHost() + ":" + SAPMPWizard.this.mm_server.getPort() + ") is running." + "\n" + message, "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]);
                        if (uploadFinished == 0) {
                            SAPMPWizard.this.mm_canceled = true;
                        }
                        if (uploadFinished != 1) continue;
                        uploadSucceededOrOmitted = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        uploadFinished = guiSystem.showOptionDialog(SAPMPWizard.this.getShell(), "Operation failed: Please make sure the server '" + SAPMPWizard.this.mm_server.getAlias() + "' (" + SAPMPWizard.this.mm_server.getHost() + ":" + SAPMPWizard.this.mm_server.getPort() + ") is running or check the log (" + SapPortalPluginsLogger.LOG_NAME + ") for more detail.", "Unable to connect to the Portal", 2, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS, SAPMPWizardStringLiterals.UPLOAD_NO_SUCCESS_OPTIONS[1]);
                        if (uploadFinished == 0) {
                            SAPMPWizard.this.mm_canceled = true;
                        }
                        if (uploadFinished != 1) continue;
                        uploadSucceededOrOmitted = false;
                    }
                } while (uploadFinished != 0);
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            if (cause != null) {
                cause.printStackTrace();
                SapPortalPluginsLogger.logError((Object)this, (Throwable)cause);
                this.mm_status = false;
                this.mm_statusType = cause.getClass().getName();
                this.mm_statusMessage = cause.getMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.mm_status = false;
            this.mm_statusType = e.getClass().getName();
            this.mm_statusMessage = e.getMessage();
        }
        if (!this.mm_status) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.mm_statusType, (String)this.mm_statusMessage);
        }
        if (this.mm_canceled) {
            this.mm_canceled = false;
            return false;
        }
        return true;
    }

    public IProject getSelectedProject() {
        if (this.mm_selectPage != null) {
            return this.mm_selectPage.getSelectedProject();
        }
        return null;
    }

    public void setSelectedProject(IProject project) {
        this.m_selectedProject = project;
    }

    public void addPages() {
        super.addPages();
        if (!this.mm_withoutParMaking) {
            this.mm_selectPage = new SelectAProjectWizardPage("Package a Portal Application into a PAR file", "Package a Portal Application into a PAR file", 3);
            this.addPage((IWizardPage)this.mm_selectPage);
        }
        this.addPage((IWizardPage)this.mm_myPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.mm_myPage && this.mm_myPage.isPageComplete();
    }

    public String getWindowTitle() {
        return "PAR Export";
    }

    public void setSAPMPWizardPage(SAPMPWizardPage wp) {
        this.mm_myPage = wp;
    }

    public SAPMPWizardPage getSAPMPWizardPage() {
        return this.mm_myPage;
    }

    public boolean isDCProject() {
        if (this.m_selectedProject != null && this.mm_selectPage != null && this.mm_selectPage.getSelectedProject() != null) {
            this.m_selectedProject = this.mm_selectPage.getSelectedProject();
        }
        return DCUtil.isDCProject((IProject)this.m_selectedProject);
    }
}

