/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakeeclipsezip;

import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.ModifyListenerDelegator;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.sapmakeeclipsezip.IEclipseZipStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakeeclipsezip.SAPMEZWizard;
import com.sap.portal.util.Files;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SAPMEZWizardPage
extends WizardPage
implements ModifyListener,
IEclipseZipStrings {
    private String mm_parArchivFileName;
    private Button mm_uploadButton;
    private Button mm_rememberButton;
    private LabeledTextField mm_parNameField;

    public SAPMEZWizardPage() {
        super("ETZ Export");
        this.setMessage("Create a Eclipse Template Project File (.etz)...");
        this.setTitle("Create a ETZ file from the Project configuration files");
        this.setDescription("Select a project");
    }

    public String getParArchiveFileName() {
        return this.mm_parNameField.getValue();
    }

    public void setParArchiveFileName(String parArchiveFileName) {
        if (this.mm_parNameField == null) {
            this.mm_parArchivFileName = parArchiveFileName;
        } else {
            this.mm_parNameField.setValue(parArchiveFileName);
        }
    }

    public void createControl(Composite composite) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(composite, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        this.mm_parNameField = new LabeledTextField(container, 0, "ETZ file:");
        this.mm_parNameField.setLayoutData(gd);
        this.mm_parNameField.getTextField().addModifyListener((ModifyListener)new ModifyListenerDelegator(this));
        LabeledThingsGroup ltg = new LabeledThingsGroup();
        ltg.add(this.mm_parNameField);
        ltg.alignTextFields();
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-createPAR");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IProject project = ((SAPMEZWizard)this.getWizard()).getSelectedProject();
            Shell guiThingForModalDialog = this.getContainer().getShell();
            IGUI guiSystem = OpentoolsFactory.getGuiSystem();
            IDE ideInstance = OpentoolsFactory.getIDEInstance();
            try {
                IDESettings iset = IDESettings.getInstance();
                String eclipseArchiveName = iset.getEtzArchiveName(project);
                if (eclipseArchiveName == null) {
                    eclipseArchiveName = ideInstance.getProjectName(project);
                }
                this.setParArchiveFileName(eclipseArchiveName);
            }
            catch (Exception e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                guiSystem.showErrorMessage("Error", "An error occurred during initalization", e, guiThingForModalDialog);
            }
        }
        super.setVisible(visible);
    }

    public void modifyText(ModifyEvent e) {
        if (!Files.isValidLocalFileName(this.mm_parNameField.getValue())) {
            this.setErrorMessage("ETZ file: The name must be a valid file name.");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    class MySelectionListener
    extends SelectionAdapter {
        MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (SAPMEZWizardPage.this.mm_uploadButton.getSelection()) {
                SAPMEZWizardPage.this.mm_rememberButton.setEnabled(true);
            } else {
                SAPMEZWizardPage.this.mm_rememberButton.setEnabled(false);
            }
        }
    }
}

