/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakeeclipsezip;

import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.sapmakeeclipsezip.IEclipseZipStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakeeclipsezip.SAPMEZProcess;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakeeclipsezip.SAPMEZWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.selectProject.SelectAProjectWizardPage;
import com.sap.portal.util.Strings;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SAPMEZWizard
extends Wizard
implements IExportWizard,
IEclipseZipStrings {
    boolean mm_status;
    String mm_statusType;
    String mm_statusMessage;
    SAPMEZWizardPage mm_myPage;
    SelectAProjectWizardPage mm_selectPage;
    SAPMEZWizard mm_wizard;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mm_myPage = new SAPMEZWizardPage();
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IProject selectedProject;
                block15: {
                    SAPMEZWizard.this.mm_status = true;
                    monitor.beginTask("Processing ETZ File - ", 6);
                    monitor.worked(1);
                    monitor.subTask("Initialization: ");
                    selectedProject = null;
                    try {
                        selectedProject = SAPMEZWizard.this.getSelectedProject();
                        IDE ideInstance = OpentoolsFactory.getIDEInstance();
                        IDESettings is = IDESettings.getInstance();
                        ZipOutputStream zosEclipseZip = null;
                        monitor.worked(1);
                        try {
                            try {
                                String fileName = SAPMEZWizard.this.mm_myPage.getParArchiveFileName().trim();
                                while (true) {
                                    if (!Strings.endsWithIgnoreCase(fileName, ".etz")) {
                                        is.setEtzArchiveName(selectedProject, fileName + ".etz");
                                        String projectFolder = ideInstance.getCurrentProjectFolder(selectedProject);
                                        File dotProject = new File(projectFolder, ".project");
                                        File dotClasspath = new File(projectFolder, ".classpath");
                                        zosEclipseZip = new ZipOutputStream(new FileOutputStream(new File(projectFolder, fileName + ".etz")));
                                        monitor.worked(1);
                                        SAPMEZProcess process = new SAPMEZProcess();
                                        if (zosEclipseZip != null) {
                                            monitor.subTask("Creating Archive: ");
                                            SAPMEZWizard.this.mm_status = process.zipEtz(zosEclipseZip, dotProject, dotClasspath);
                                        }
                                        monitor.worked(1);
                                        break;
                                    }
                                    fileName = fileName.substring(0, fileName.length() - ".etz".length());
                                    monitor.worked(1);
                                }
                            }
                            catch (Exception e) {
                                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                                SAPMEZWizard.this.mm_status = false;
                                SAPMEZWizard.this.mm_statusType = e.getClass().getName();
                                SAPMEZWizard.this.mm_statusMessage = e.getMessage();
                                Object var12_15 = null;
                                if (zosEclipseZip != null) {
                                    zosEclipseZip.close();
                                }
                                break block15;
                            }
                            Object var12_14 = null;
                            if (zosEclipseZip == null) break block15;
                        }
                        catch (Throwable throwable) {
                            Object var12_16 = null;
                            if (zosEclipseZip != null) {
                                zosEclipseZip.close();
                            }
                            throw throwable;
                        }
                        zosEclipseZip.close();
                    }
                    catch (Exception e) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        SAPMEZWizard.this.mm_status = false;
                        SAPMEZWizard.this.mm_statusType = e.getClass().getName();
                        SAPMEZWizard.this.mm_statusMessage = e.getMessage();
                    }
                }
                try {
                    monitor.subTask("Refresh: ");
                    selectedProject.refreshLocal(2, null);
                    monitor.worked(1);
                }
                catch (CoreException ce) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)ce);
                    SAPMEZWizard.this.mm_status = false;
                    SAPMEZWizard.this.mm_statusType = ((Object)((Object)ce)).getClass().getName();
                    SAPMEZWizard.this.mm_statusMessage = ce.getMessage();
                }
                if (!SAPMEZWizard.this.mm_status) {
                    MessageDialog.openError((Shell)SAPMEZWizard.this.getShell(), (String)SAPMEZWizard.this.mm_statusType, (String)SAPMEZWizard.this.mm_statusMessage);
                }
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        return true;
    }

    public IProject getSelectedProject() {
        return this.mm_selectPage.getSelectedProject();
    }

    public void addPages() {
        super.addPages();
        this.mm_selectPage = new SelectAProjectWizardPage("Select a project", "Select a project", null, 1);
        this.addPage((IWizardPage)this.mm_selectPage);
        this.addPage((IWizardPage)this.mm_myPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.mm_myPage && this.mm_myPage.isPageComplete();
    }

    public String getWindowTitle() {
        return "ETZ Export";
    }
}

