/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards;

import com.sap.portal.developmentTools.general.gui.swt.ClassBrowserComposite;
import com.sap.portal.developmentTools.general.gui.swt.FileBrowserComposite;
import com.sap.portal.developmentTools.general.gui.swt.MultiValuePropertyComposite;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappEditorsStrings;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Node;

public class EditPropertyDialog
extends Dialog
implements PortalappEditorsStrings,
ModifyListener {
    private Node mm_node;
    private Hashtable mm_propertyHTable;
    private StyledText mm_descriptionText;
    private Group mm_descriptionGroup;
    private Text mm_propertyNameText;
    private String mm_propertyName;
    private String mm_propertyValue;
    private Text mm_textValue;
    private Combo mm_comboValue;
    private ClassBrowserComposite mm_classBrowser;
    private FileBrowserComposite mm_fileBrowser;
    private MultiValuePropertyComposite mm_multiValuePropertyComposite;
    private IProject mm_currentProject;
    private boolean mm_userDefinedProperty;
    private String mm_valueFormat;
    private String mm_admissibleValues;
    private String mm_defaultValue;

    public EditPropertyDialog(IProject project, String propertyName, Hashtable properyHTable, String value) {
        super(null);
        this.mm_propertyHTable = properyHTable;
        this.mm_propertyValue = value;
        this.mm_currentProject = project;
        if (properyHTable == null) {
            this.mm_userDefinedProperty = true;
        } else {
            this.mm_propertyName = propertyName;
            this.mm_valueFormat = (String)this.mm_propertyHTable.get("format");
            this.mm_admissibleValues = (String)this.mm_propertyHTable.get("admissibleValue");
            this.mm_defaultValue = (String)this.mm_propertyHTable.get("defaultValue");
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 350;
        gridData.heightHint = 250;
        parent.setLayoutData((Object)gridData);
        Composite nameComposite = new Composite(parent, 0);
        nameComposite.setLayout((Layout)new GridLayout());
        gridData = new GridData(768);
        gridData.heightHint = 20;
        nameComposite.setLayoutData((Object)gridData);
        Label nameLabel = new Label(nameComposite, 0);
        nameLabel.setText("Value of \"" + this.mm_propertyName + "\" property");
        gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        Label label = new Label(nameComposite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(this.mm_propertyName);
        Composite valueComposite = new Composite(parent, 0);
        valueComposite.setLayout((Layout)new GridLayout());
        gridData = new GridData(768);
        gridData.heightHint = 50;
        valueComposite.setLayoutData((Object)gridData);
        if (this.mm_valueFormat != null && this.mm_valueFormat.equals("class")) {
            this.mm_classBrowser = new ClassBrowserComposite(valueComposite, 0, this.mm_propertyName, this.mm_currentProject);
            this.mm_classBrowser.addModifyListener(this);
            if (this.mm_propertyValue != null) {
                this.mm_classBrowser.setValue(this.mm_propertyValue);
            }
        } else if (this.mm_valueFormat != null && this.mm_valueFormat.equals("file")) {
            String projectPath = this.mm_currentProject.getLocation().toOSString();
            if (!projectPath.endsWith("\\")) {
                projectPath = projectPath + "\\";
            }
            String startBrowsingPath = projectPath + "dist" + File.separator + "PORTAL-INF";
            this.mm_fileBrowser = new FileBrowserComposite(valueComposite, 0, this.mm_propertyName, this.mm_currentProject, startBrowsingPath);
            this.mm_fileBrowser.addModifyListener(this);
            if (this.mm_propertyValue != null) {
                this.mm_fileBrowser.setValue(this.mm_propertyValue);
            }
        } else if (this.mm_valueFormat != null && this.mm_valueFormat.equals("library")) {
            gridData = new GridData(1808);
            gridData.widthHint = 350;
            gridData.heightHint = 350;
            parent.setLayoutData((Object)gridData);
            gridData = new GridData(768);
            gridData.heightHint = 160;
            valueComposite.setLayoutData((Object)gridData);
            this.mm_multiValuePropertyComposite = new MultiValuePropertyComposite(valueComposite, 0, this.mm_propertyValue);
            gridData = new GridData(1810);
            this.mm_multiValuePropertyComposite.setLayoutData(gridData);
            this.mm_multiValuePropertyComposite.setLayout((Layout)new GridLayout());
            this.mm_multiValuePropertyComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    EditPropertyDialog.this.mm_propertyValue = EditPropertyDialog.this.mm_multiValuePropertyComposite.getValue();
                }
            });
            this.mm_multiValuePropertyComposite.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    EditPropertyDialog.this.mm_propertyValue = EditPropertyDialog.this.mm_multiValuePropertyComposite.getValue();
                }
            });
        } else if (this.mm_admissibleValues != null) {
            this.mm_comboValue = new Combo(valueComposite, 8);
            this.mm_comboValue.setLayoutData((Object)new GridData(768));
            this.mm_comboValue.addModifyListener((ModifyListener)this);
            StringTokenizer stk = new StringTokenizer(this.mm_admissibleValues, ",");
            while (stk.hasMoreTokens()) {
                String value = stk.nextToken();
                this.mm_comboValue.add(value);
            }
            if (this.mm_propertyValue != null) {
                this.mm_comboValue.setText(this.mm_propertyValue);
            } else if (this.mm_defaultValue != null) {
                this.mm_comboValue.setText(this.mm_defaultValue);
            }
        } else {
            this.mm_textValue = new Text(valueComposite, 2048);
            this.mm_textValue.setLayoutData((Object)new GridData(768));
            this.mm_textValue.addModifyListener((ModifyListener)this);
            if (this.mm_propertyValue != null) {
                this.mm_textValue.setText(this.mm_propertyValue);
            } else if (this.mm_defaultValue != null) {
                this.mm_textValue.setText(this.mm_defaultValue);
            }
        }
        Group mm_descGroup = new Group(parent, 0);
        mm_descGroup.setText("Description");
        mm_descGroup.setLayout((Layout)new GridLayout());
        GridData descGridData = new GridData(1808);
        descGridData.horizontalSpan = 2;
        descGridData.heightHint = 80;
        descGridData.widthHint = 150;
        mm_descGroup.setLayoutData((Object)descGridData);
        this.mm_descriptionText = new StyledText((Composite)mm_descGroup, 0);
        this.mm_descriptionText.setLayoutData((Object)new GridData(1808));
        this.mm_descriptionText.setWordWrap(true);
        this.mm_descriptionText.setBounds(mm_descGroup.getBounds());
        this.mm_descriptionText.setBackground(parent.getBackground());
        this.mm_descriptionText.setEditable(false);
        String description = this.mm_propertyHTable.get("description") != null ? (String)this.mm_propertyHTable.get("description") : "No description available.";
        this.mm_descriptionText.setText(description);
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit property");
        Rectangle displayBounds = Display.getCurrent().getBounds();
        newShell.setLocation((displayBounds.width - newShell.getSize().x) / 2, (displayBounds.height - newShell.getSize().y) / 2);
    }

    public String getPropertyName() {
        return this.mm_propertyName;
    }

    public String getPropertyValue() {
        return this.mm_propertyValue;
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource().equals(this.mm_propertyNameText)) {
            this.mm_propertyName = this.mm_propertyNameText.getText();
        } else if (event.getSource().equals(this.mm_textValue)) {
            this.mm_propertyValue = this.mm_textValue.getText();
        } else if (event.getSource().equals(this.mm_comboValue)) {
            this.mm_propertyValue = this.mm_comboValue.getText();
        } else if (this.mm_classBrowser != null) {
            this.mm_propertyValue = this.mm_classBrowser.getValue();
        } else if (this.mm_fileBrowser != null) {
            this.mm_propertyValue = this.mm_fileBrowser.getValue();
        }
        Button oKButton = this.getButton(0);
        if (oKButton != null) {
            if (this.mm_propertyValue == null || this.mm_propertyValue.trim().equalsIgnoreCase("")) {
                oKButton.setEnabled(false);
            } else {
                oKButton.setEnabled(true);
            }
        }
    }
}

