/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards;

import com.sap.portal.developmentTools.general.editors.EditorsStrings;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappEditorsStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappManager;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards.AddPropertyWizard;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards.AddStdPropertyDialog;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards.CreatePropertyDialog;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards.EditPropertyDialog;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddPropertyWizardPage
extends WizardPage
implements SelectionListener,
EditorsStrings,
PortalappEditorsStrings {
    private PortalappManager mm_portalAppManager;
    private Node mm_node;
    private String mm_componentName;
    private Hashtable mm_presentPropertiesHTable = new Hashtable();
    private Hashtable mm_currentPropertyHTable;
    private Table mm_addedPropertiesTable;
    private TableViewer mm_addedPropertiesTableViewer;
    private Button mm_addStdPropertyButon;
    private Button mm_createPropertyButon;
    private Button mm_editPropertyButton;
    private Button mm_removePropertyButton;
    private AddPropertyWizard mm_wizard;
    private IProject mm_currentProject;
    private String mm_nodeName;
    private boolean mm_subProperty;
    private MultiPageEditorPart mm_editorPart;
    private PropertiesContentProvider mm_provider;
    private static final String[] mm_columnName = new String[]{"name", "value"};

    public AddPropertyWizardPage(Node node, AddPropertyWizard parentWizard, PortalappManager portalappManager, MultiPageEditorPart editorPart) {
        super("");
        this.mm_node = node;
        this.mm_wizard = parentWizard;
        this.mm_portalAppManager = portalappManager;
        this.mm_editorPart = editorPart;
        this.mm_currentProject = ((FileEditorInput)this.mm_editorPart.getEditorInput()).getFile().getProject();
        this.mm_nodeName = this.mm_node.getNodeName();
        this.mm_provider = new PropertiesContentProvider();
        this.mm_componentName = this.mm_portalAppManager.getComponentName(this.mm_node);
        if (this.mm_nodeName.equals("property")) {
            this.mm_subProperty = true;
            this.mm_nodeName = ((Element)this.mm_node).getAttribute("name");
        } else {
            this.mm_subProperty = false;
        }
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite composite = sappoEclipseStylePanel.getContentPane();
        if (this.mm_subProperty) {
            this.setTitle("Add sub-property to " + this.mm_componentName);
        } else {
            this.setTitle("Properties of " + this.mm_componentName);
        }
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite contentComposite = new Composite(composite, 0);
        GridLayout listsLayout = new GridLayout();
        listsLayout.numColumns = 2;
        contentComposite.setLayout((Layout)listsLayout);
        GridData gridData = new GridData(256);
        contentComposite.setLayoutData((Object)gridData);
        Label label1 = new Label(contentComposite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label1.setLayoutData((Object)gridData);
        label1.setText("Properties present in " + this.mm_nodeName + " of \"" + this.mm_componentName + "\"");
        Composite listComposite = new Composite(contentComposite, 0);
        listComposite.setLayout((Layout)new GridLayout());
        listComposite.setLayoutData((Object)new GridData(1808));
        Composite buttonsComposite = new Composite(contentComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout());
        buttonsComposite.setLayoutData((Object)new GridData(1808));
        this.mm_addedPropertiesTable = new Table(listComposite, 68098);
        gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 120;
        this.mm_addedPropertiesTable.setLayoutData((Object)gridData);
        this.mm_addedPropertiesTable.setHeaderVisible(true);
        this.mm_addedPropertiesTable.setLinesVisible(true);
        this.mm_addedPropertiesTable.addSelectionListener((SelectionListener)this);
        this.mm_addedPropertiesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                AddPropertyWizardPage.this.handleEditProperty();
            }
        });
        TableColumn nameColumn = new TableColumn(this.mm_addedPropertiesTable, 0, 0);
        nameColumn.setText(mm_columnName[0]);
        nameColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(this.mm_addedPropertiesTable, 0, 1);
        valueColumn.setText(mm_columnName[1]);
        valueColumn.setWidth(250);
        this.mm_presentPropertiesHTable = this.mm_portalAppManager.getPresentProperties(this.mm_node);
        this.mm_addedPropertiesTableViewer = new TableViewer(this.mm_addedPropertiesTable);
        this.mm_addedPropertiesTableViewer.setContentProvider((IContentProvider)this.mm_provider);
        this.mm_addedPropertiesTableViewer.setLabelProvider((IBaseLabelProvider)this.mm_provider);
        this.mm_addedPropertiesTableViewer.setInput((Object)this.mm_presentPropertiesHTable);
        this.mm_addedPropertiesTableViewer.setColumnProperties(mm_columnName);
        this.mm_addStdPropertyButon = new Button(buttonsComposite, 0);
        this.mm_addStdPropertyButon.setLayoutData((Object)new GridData(1280));
        this.mm_addStdPropertyButon.addSelectionListener((SelectionListener)this);
        this.mm_addStdPropertyButon.setText("Add standard...");
        this.mm_addStdPropertyButon.setToolTipText("Add a predefined property to portalapp.xml");
        this.mm_createPropertyButon = new Button(buttonsComposite, 0);
        this.mm_createPropertyButon.setLayoutData((Object)new GridData(1280));
        this.mm_createPropertyButon.addSelectionListener((SelectionListener)this);
        this.mm_createPropertyButon.setText("New...");
        this.mm_createPropertyButon.setToolTipText("Create a user-defined property");
        this.mm_editPropertyButton = new Button(buttonsComposite, 0);
        this.mm_editPropertyButton.setLayoutData((Object)new GridData(1280));
        this.mm_editPropertyButton.addSelectionListener((SelectionListener)this);
        this.mm_editPropertyButton.setText("Edit...");
        this.mm_editPropertyButton.setToolTipText("Edit the selected property value");
        this.mm_editPropertyButton.setEnabled(false);
        this.mm_removePropertyButton = new Button(buttonsComposite, 0);
        this.mm_removePropertyButton.setLayoutData((Object)new GridData(1280));
        this.mm_removePropertyButton.addSelectionListener((SelectionListener)this);
        this.mm_removePropertyButton.setText("Remove");
        this.mm_removePropertyButton.setToolTipText("Remove the selected property from portalapp.xml");
        this.mm_removePropertyButton.setEnabled(false);
        this.updateAddStdPropertyAction();
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        composite.setFocus();
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.mm_addStdPropertyButon) {
            this.handleAddStdProperty();
        } else if (event.widget == this.mm_createPropertyButon) {
            this.handleCreateProperty();
        } else if (event.widget == this.mm_editPropertyButton) {
            this.handleEditProperty();
        } else if (event.widget == this.mm_removePropertyButton) {
            this.handleRemoveProperty();
        } else if (event.widget == this.mm_addedPropertiesTable) {
            this.handleSelectProperty();
        }
        this.mm_wizard.getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    private void handleAddStdProperty() {
        Hashtable propertiesTable = this.mm_portalAppManager.getProperties(this.mm_node);
        AddStdPropertyDialog newPropertyDialog = new AddStdPropertyDialog(this.getShell(), this.mm_currentProject, propertiesTable, this.getAddedProperties());
        if (newPropertyDialog.open() == 0) {
            Hashtable propertyHTable;
            EditPropertyDialog editDialog;
            String name = newPropertyDialog.getPropertyName();
            String value = "";
            if (name != null && (editDialog = new EditPropertyDialog(this.mm_currentProject, name, propertyHTable = this.mm_portalAppManager.getPropertyDefinition(this.mm_node, name), null)).open() == 0) {
                value = editDialog.getPropertyValue();
                this.mm_provider.addProperty(name, value);
            }
        }
        this.updateAddStdPropertyAction();
    }

    private void handleRemoveProperty() {
        TableItem[] selections = this.mm_addedPropertiesTable.getSelection();
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                String[] property = (String[])selections[i].getData();
                this.mm_provider.removeProperty(property[0]);
                selections[i].dispose();
                ++i;
            }
        }
        this.updateAddStdPropertyAction();
    }

    private void handleEditProperty() {
        String[] selectedProperty;
        EditPropertyDialog editDialog;
        TableItem[] selections = this.mm_addedPropertiesTable.getSelection();
        if (selections != null && selections.length == 1 && (editDialog = new EditPropertyDialog(this.mm_currentProject, (selectedProperty = (String[])selections[0].getData())[0], this.mm_currentPropertyHTable, selectedProperty[1])).open() == 0) {
            this.mm_provider.addProperty(editDialog.getPropertyName(), editDialog.getPropertyValue());
        }
        this.updatePropertiesButtons();
    }

    private void handleSelectProperty() {
        this.updatePropertiesButtons();
        TableItem[] selections = this.mm_addedPropertiesTable.getSelection();
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                String[] selectedProperty = (String[])selections[i].getData();
                this.mm_currentPropertyHTable = this.mm_portalAppManager.getPropertyDefinition(this.mm_node, selectedProperty[0]);
                String mandatory = (String)this.mm_currentPropertyHTable.get("mandatory");
                if (mandatory != null && mandatory.equalsIgnoreCase("true")) {
                    this.mm_removePropertyButton.setEnabled(false);
                    this.setMessage("This is a mandatory property");
                    return;
                }
                ++i;
            }
            this.mm_removePropertyButton.setEnabled(true);
            this.setMessage(null);
        } else {
            this.mm_removePropertyButton.setEnabled(false);
        }
    }

    private void handleCreateProperty() {
        CreatePropertyDialog newPropertyDialog = new CreatePropertyDialog();
        if (newPropertyDialog.open() == 0) {
            String name = newPropertyDialog.getPropertyName();
            String value = newPropertyDialog.getPropertyValue();
            this.mm_provider.addProperty(name, value);
        }
        this.updatePropertiesButtons();
    }

    public Hashtable getAddedProperties() {
        return this.mm_presentPropertiesHTable;
    }

    private void updateAddStdPropertyAction() {
        Hashtable propertiesHTable = this.mm_portalAppManager.getProperties(this.mm_node);
        Enumeration enumeration = propertiesHTable.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (this.mm_presentPropertiesHTable.containsKey(name)) continue;
            this.updatePropertiesButtons();
            this.mm_addStdPropertyButon.setEnabled(true);
            return;
        }
        this.updatePropertiesButtons();
        this.mm_addStdPropertyButon.setEnabled(false);
    }

    private void updatePropertiesButtons() {
        int selectionCount = this.mm_addedPropertiesTable.getSelectionCount();
        if (selectionCount == 0) {
            this.mm_editPropertyButton.setEnabled(false);
            this.mm_removePropertyButton.setEnabled(false);
        } else if (selectionCount == 1) {
            this.mm_editPropertyButton.setEnabled(true);
        } else {
            this.mm_editPropertyButton.setEnabled(false);
        }
    }

    class PropertiesContentProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        PropertiesContentProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object element, int col) {
            String[] property = (String[])element;
            return property[col];
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return true;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Object[] getElements(Object element) {
            Object[] properties = new Object[AddPropertyWizardPage.this.mm_presentPropertiesHTable.size()];
            Enumeration enumeration = AddPropertyWizardPage.this.mm_presentPropertiesHTable.keys();
            int i = 0;
            while (i < properties.length) {
                String propertyName = (String)enumeration.nextElement();
                String propertyValue = (String)AddPropertyWizardPage.this.mm_presentPropertiesHTable.get(propertyName);
                properties[i] = new String[]{propertyName, propertyValue};
                ++i;
            }
            return properties;
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
        }

        public void addProperty(String name, String value) {
            if (value == null) {
                value = "";
            }
            AddPropertyWizardPage.this.mm_presentPropertiesHTable.remove(name);
            AddPropertyWizardPage.this.mm_presentPropertiesHTable.put(name, value);
            AddPropertyWizardPage.this.mm_addedPropertiesTableViewer.setInput((Object)AddPropertyWizardPage.this.mm_presentPropertiesHTable);
        }

        public void removeProperty(String name) {
            AddPropertyWizardPage.this.mm_presentPropertiesHTable.remove(name);
        }
    }
}

