/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager;

import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledComboBox;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.wizards.parServiceRefManager.IProfileWizardStringLiterals;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddProfileOpeningMiniDialog
extends Dialog
implements IProfileWizardStringLiterals {
    static final RegularExpression profileNameCheck = new RegularExpression("[a-zA-Z0-9_]+", "X");
    final AbstractProfiles profiles;
    LabeledTextField nameField;
    LabeledComboBox copyField;
    Composite errorPane;
    Label errorMessage;
    private String newProfileName = "";
    private String copyProfileName = "";
    private String[] profileNames;
    private Image image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
    private static final String WRONG_NAME_SYNTAX_MSG = "The profile name must comply to the pattern [a-zA-Z0-9_]+";
    private Button invokeProfileEditorCheckbox;
    private boolean invokeProfileEditor;

    public AddProfileOpeningMiniDialog(Shell parentShell, AbstractProfiles profiles) {
        super(parentShell);
        this.setShellStyle(48);
        this.profiles = profiles;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Add a new Profile");
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout(1, true));
        Label please = new Label(content, 4);
        please.setImage(this.image);
        please.setText("Please provide a name for the new profile");
        please.setLayoutData((Object)new GridData(32));
        this.nameField = new LabeledTextField(content, 0, "New Profile Name:");
        this.nameField.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddProfileOpeningMiniDialog.this.newProfileName = AddProfileOpeningMiniDialog.this.nameField.getValue();
                AddProfileOpeningMiniDialog.this.validate();
            }
        });
        Label copyThis = new Label(content, 0);
        copyThis.setText("Optionally select an existing profile as template");
        copyThis.setLayoutData((Object)new GridData(32));
        List pList = this.profiles.getProfiles();
        this.profileNames = new String[pList.size() + 1];
        this.profileNames[0] = "";
        int index = 1;
        Iterator pIt = pList.iterator();
        while (pIt.hasNext()) {
            AbstractProfile profile = (AbstractProfile)pIt.next();
            this.profileNames[index++] = profile.getName();
        }
        this.copyField = new LabeledComboBox(content, 0, "Copy From Profile", this.profileNames, "", false);
        this.copyField.getComboBox().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddProfileOpeningMiniDialog.this.copyProfileName = AddProfileOpeningMiniDialog.this.copyField.getComboBox().getText();
            }
        });
        LabeledThingsGroup ltg = new LabeledThingsGroup();
        ltg.add(this.nameField);
        ltg.add(this.copyField);
        ltg.alignTextFields();
        this.errorPane = new Composite(content, 0);
        this.errorPane.setLayoutData((Object)new GridData(768));
        this.errorPane.setLayout((Layout)new GridLayout(2, false));
        Label errorImage = new Label(this.errorPane, 0);
        errorImage.setImage(this.image);
        errorImage.setLayoutData((Object)new GridData(32));
        this.errorMessage = new Label(this.errorPane, 64);
        this.errorMessage.setLayoutData((Object)new GridData(768));
        this.errorMessage.setText(WRONG_NAME_SYNTAX_MSG);
        Text textField = this.nameField.getTextField();
        textField.setFocus();
        textField.setSelection(0);
        return content;
    }

    protected void okPressed() {
        this.invokeProfileEditor = this.invokeProfileEditorCheckbox.getSelection();
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.invokeProfileEditorCheckbox = new Button(composite, 32);
        this.invokeProfileEditorCheckbox.setText("Invoke Profile Editor after creation");
        this.invokeProfileEditorCheckbox.setSelection(this.invokeProfileEditor);
        this.invokeProfileEditor = true;
        super.createButtonBar(composite);
        return composite;
    }

    public void setSelectedInvokeProfileEditorAfterCreation(boolean selected) {
        this.invokeProfileEditor = selected;
    }

    private void validate() {
        String name = this.nameField.getValue();
        if (name == null) {
            this.setErrorMessage(WRONG_NAME_SYNTAX_MSG);
            return;
        }
        if (!profileNameCheck.matches(name = name.trim())) {
            this.setErrorMessage(WRONG_NAME_SYNTAX_MSG);
            return;
        }
        int i = 0;
        while (i < this.profileNames.length) {
            String pName = this.profileNames[i];
            if (pName.equalsIgnoreCase(name)) {
                this.setErrorMessage("This profile name already exists.");
                return;
            }
            ++i;
        }
        this.setErrorMessage(null);
    }

    private void setErrorMessage(String message) {
        Button okButton = this.getButton(0);
        if (message == null) {
            this.errorPane.setVisible(false);
            okButton.setEnabled(true);
            this.invokeProfileEditorCheckbox.setEnabled(true);
        } else {
            this.errorMessage.setText(message);
            this.errorPane.setVisible(true);
            okButton.setEnabled(false);
            this.invokeProfileEditorCheckbox.setEnabled(false);
        }
    }

    public boolean invokeProfileEditorEnabled() {
        return this.invokeProfileEditor;
    }

    public void create() {
        super.create();
        this.validate();
    }

    public AbstractProfile createTheNewProfile() throws Exception {
        AbstractProfile newProfile = null;
        if (this.copyProfileName != null && !this.copyProfileName.trim().equals("")) {
            newProfile = this.profiles.getProfileByName(this.copyProfileName).deepClone();
            newProfile.setName(this.newProfileName);
            this.profiles.addProfile(newProfile);
        } else {
            newProfile = this.profiles.addProfile(this.newProfileName);
        }
        return newProfile;
    }
}

