/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.openeclipsezip;

import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.wizards.sapmakeeclipsezip.IEclipseZipStrings;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenEclipseZipWizardPage
extends WizardPage
implements IEclipseZipStrings {
    LabeledBrowsableTextField mm_parNameField;
    LabeledBrowsableTextField mm_dirNameField;
    private int mm_type;
    private String mm_parName;
    private String mm_dirPath;
    private Label mm_info;
    private Label mm_line;
    private Label mm_labelFile;
    private Label mm_labelDir;
    private Button mm_buttonFile;
    private Button mm_buttonDir;

    public OpenEclipseZipWizardPage(int type) {
        super("Portal Application Project from a ETZ file", "Portal Application Project from a ETZ file", SAPImageDescriptors.SAP_LOGO);
        this.mm_type = type;
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite content = sappoEclipseStylePanel.getContentPane();
        this.setTitle("Portal Application Project from a ETZ file");
        this.setDescription("A new project is created from an existing ETZ file.\n");
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.mm_info = new Label(content, 0x1000000);
        this.mm_info.setText("Specify your ETZ filename to import OR the directory to inspect:");
        this.mm_line = new Label(content, 256);
        Composite fileComp = new Composite(content, 0);
        RowLayout lbRowLayout = new RowLayout(256);
        lbRowLayout.pack = true;
        lbRowLayout.type = 256;
        lbRowLayout.marginLeft = 5;
        lbRowLayout.marginTop = 5;
        lbRowLayout.marginRight = 5;
        lbRowLayout.marginBottom = 5;
        lbRowLayout.spacing = 5;
        fileComp.setLayout((Layout)lbRowLayout);
        this.mm_buttonFile = new Button(fileComp, 16);
        this.mm_buttonFile.setSelection(true);
        this.mm_labelFile = new Label(fileComp, 16384);
        this.mm_labelFile.setText("Import an ETZ File:");
        this.mm_parNameField = new LabeledBrowsableTextField(content, 0, "Eclipse Portal Archive name: ");
        this.mm_buttonFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean b = OpenEclipseZipWizardPage.this.mm_buttonFile.getSelection();
                if (b) {
                    OpenEclipseZipWizardPage.this.mm_buttonDir.setSelection(!b);
                    OpenEclipseZipWizardPage.this.checkFilename();
                }
                OpenEclipseZipWizardPage.this.mm_parNameField.setEditable(b);
                OpenEclipseZipWizardPage.this.mm_dirNameField.setEditable(!b);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Composite dirComp = new Composite(content, 0);
        RowLayout dirLayout = new RowLayout(256);
        dirLayout.pack = true;
        dirLayout.type = 256;
        dirLayout.marginLeft = 5;
        dirLayout.marginTop = 5;
        dirLayout.marginRight = 5;
        dirLayout.marginBottom = 5;
        dirLayout.spacing = 5;
        dirComp.setLayout((Layout)dirLayout);
        this.mm_buttonDir = new Button(dirComp, 16);
        this.mm_buttonDir.setSelection(false);
        this.mm_labelDir = new Label(dirComp, 16384);
        this.mm_labelDir.setText("Inspect ETZ file(s) in a directory:");
        this.mm_dirNameField = new LabeledBrowsableTextField(content, 0, "Directory to inspect: ");
        this.mm_dirNameField.setEditable(false);
        this.mm_buttonDir.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean b = OpenEclipseZipWizardPage.this.mm_buttonDir.getSelection();
                if (b) {
                    OpenEclipseZipWizardPage.this.mm_buttonFile.setSelection(!b);
                    OpenEclipseZipWizardPage.this.checkDirectory();
                }
                OpenEclipseZipWizardPage.this.mm_parNameField.setEditable(!b);
                OpenEclipseZipWizardPage.this.mm_dirNameField.setEditable(b);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        if (this.mm_type == 0) {
            this.mm_parNameField.setFileSelectionMode(0);
        } else {
            this.mm_parNameField.setFileSelectionMode(1);
        }
        this.mm_parNameField.setFilterNames(new String[]{"*.etz - Eclipse Template Zip"});
        this.mm_parNameField.setFilterExtensions(new String[]{"*.etz"});
        this.mm_dirNameField.setFileSelectionMode(1);
        this.mm_parNameField.setDialogFlags(4096);
        this.mm_parNameField.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OpenEclipseZipWizardPage.this.checkFilename();
            }
        });
        this.mm_dirNameField.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OpenEclipseZipWizardPage.this.checkDirectory();
            }
        });
        LabeledThingsGroup ltg = new LabeledThingsGroup();
        ltg.add(this.mm_parNameField);
        ltg.add(this.mm_dirNameField);
        ltg.alignTextFields();
        DropTarget dropTarget = new DropTarget((Control)parent, 21);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String filename = ((String[])event.data)[0];
                OpenEclipseZipWizardPage.this.mm_parNameField.getTextField().setText(filename);
            }
        });
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-openPar");
        this.setPageComplete(new File(this.mm_dirNameField.getValue().trim()).isDirectory());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mm_parNameField.setFocus();
    }

    public String getParName() {
        return this.mm_parNameField.getValue();
    }

    public String getDirPath() {
        return this.mm_dirNameField.getValue();
    }

    public void setDirPath(String v) {
        this.mm_dirPath = v;
    }

    public boolean canFlipToNextPage() {
        if (this.mm_buttonDir.getSelection()) {
            String dir = this.getDirPath().trim();
            return !dir.equals("") && new File(dir).isDirectory();
        }
        return false;
    }

    private void checkFilename() {
        this.mm_parName = this.mm_parNameField.getValue();
        this.setPageComplete(this.mm_parName.trim().endsWith(".etz"));
        if (this.mm_parName == null || this.mm_parName.trim().equals("")) {
            this.setErrorMessage("Please specify the name of the archive you want to open");
        } else {
            File f = new File(this.mm_parName);
            if (!f.exists()) {
                this.setErrorMessage("File or folder does not exist!");
            } else if (this.mm_parName.trim().endsWith(".etz")) {
                this.setErrorMessage(null);
                this.setMessage("ETZ filename is valid: Click Finish button to import");
            } else {
                this.setErrorMessage("Illegal name of ETZ!");
            }
        }
    }

    private void checkDirectory() {
        this.mm_dirPath = this.mm_dirNameField.getValue();
        this.setPageComplete(new File(this.mm_dirPath.trim()).isDirectory());
        if (this.mm_dirPath == null || this.mm_dirPath.trim().equals("")) {
            this.setErrorMessage("Please specify the name of the directory you want to inspect");
        } else {
            File f = new File(this.mm_dirPath);
            if (!f.exists()) {
                this.setErrorMessage("File or folder does not exist!");
            } else if (f.isDirectory()) {
                this.setErrorMessage(null);
                this.setMessage("Directory is valid: Click Next button to inspect");
            } else {
                this.setErrorMessage("Illegal name of directory!");
            }
        }
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public Button getFileButton() {
        return this.mm_buttonFile;
    }

    public Button getDirButton() {
        return this.mm_buttonDir;
    }
}

