/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.openeclipsezip;

import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.wizards.sapmakeeclipsezip.IEclipseZipStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.openeclipsezip.OpenEclipseZipWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.selectProject.SelectAZipWizardPage;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class OpenEclipseZipWizard
extends Wizard
implements IImportWizard,
IEclipseZipStrings {
    private static final String ERROR_TITLE = "Import ETZ file(s) failed";
    private static final String DEFAULT_MESSAGE = "Error during ETZ file(s) import";
    OpenEclipseZipWizardPage mm_myPage;
    IWorkbench mm_workbench;
    private IProjectDescription mm_description;
    private int mm_type;
    private SelectAZipWizardPage mm_selectZipPage;
    private File[] mm_filesToImport;
    private IProject mm_project;
    private MultiStatus mm_multiStatus;
    private boolean mm_hasErrorStatus = false;

    public OpenEclipseZipWizard(int type) {
        this.mm_type = type;
    }

    public boolean performFinish() {
        if (this.mm_filesToImport != null) {
            IWorkspaceRoot root = this.getWorkspace().getRoot();
            this.mm_multiStatus = new MultiStatus(PortalPlugin.getPluginID(), 0, ERROR_TITLE, null);
            int i = 0;
            while (i < this.mm_filesToImport.length) {
                block8: {
                    WorkspaceModifyOperation op = null;
                    try {
                        File eclipseZipFile = this.mm_filesToImport[i];
                        this.unzipEclipseZip(eclipseZipFile);
                        Path eclipseZipPath = new Path(eclipseZipFile.getParent() + File.separator + ".project");
                        this.mm_description = this.getWorkspace().loadProjectDescription((IPath)eclipseZipPath);
                        String projectToImportName = this.mm_description.getName();
                        this.mm_project = root.getProject(projectToImportName);
                        op = new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException {
                                monitor.beginTask("Creating project", 2000);
                                OpenEclipseZipWizard.this.mm_project.create(OpenEclipseZipWizard.this.mm_description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                OpenEclipseZipWizard.this.mm_project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                            }
                        };
                    }
                    catch (CoreException exception) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)exception);
                    }
                    try {
                        this.getContainer().run(true, true, op);
                    }
                    catch (InterruptedException e) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)t);
                        if (!(t instanceof CoreException)) break block8;
                        this.addToStatus(this.mm_multiStatus, DEFAULT_MESSAGE, (CoreException)t);
                        this.mm_hasErrorStatus = true;
                    }
                }
                ++i;
            }
        }
        if (this.mm_hasErrorStatus) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"ETZ Import", (String)"ETZ import finished with errors. See details for additional information", (IStatus)this.mm_multiStatus);
        }
        return true;
    }

    public void unzipEclipseZip(File eclipseZipFile) {
        EP ep = OpentoolsFactory.getEPInstance();
        try {
            ep.unpackZipArchive(eclipseZipFile.getParentFile(), eclipseZipFile);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"IOExceptionError", (String)("Failed to unzip the ETZ file :\n" + e));
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mm_myPage = new OpenEclipseZipWizardPage(this.mm_type);
        this.mm_workbench = workbench;
        this.setWindowTitle("Import");
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mm_myPage);
        this.mm_selectZipPage = new SelectAZipWizardPage("Select ETZ file(s) to import");
        this.addPage((IWizardPage)this.mm_selectZipPage);
    }

    public boolean canFinish() {
        if (this.mm_myPage.isCurrentPage()) {
            if (this.mm_myPage.getFileButton().getSelection()) {
                boolean res = this.mm_myPage.getParName().trim().endsWith(".etz");
                if (res) {
                    this.mm_filesToImport = new File[]{new File(this.mm_myPage.getParName())};
                }
                return res;
            }
            return false;
        }
        if (this.mm_selectZipPage.isCurrentPage()) {
            this.mm_filesToImport = this.mm_selectZipPage.getFilesToImport();
            boolean res = this.mm_filesToImport != null && this.mm_filesToImport.length > 0;
            return res;
        }
        return false;
    }

    private IWorkspace getWorkspace() {
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        return workspace;
    }

    public File getDirToInspect() {
        return new File(this.mm_myPage.getDirPath());
    }

    private void addToStatus(MultiStatus ms, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        ms.add(status);
    }
}

