/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.openPar;

import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.wizards.openArchive.IOpenArchiveStringLiterals;
import com.sap.portal.developmentTools.general.wizards.openArchive.IOpenArchiveWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.util.Files;
import com.sap.portal.util.eclipse.ProjectNameValidator;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenParWizardPage
extends WizardPage
implements IOpenArchiveStringLiterals,
IOpenArchiveWizardPage,
ModifyListener {
    LabeledBrowsableTextField mm_parNameField;
    LabeledTextField mm_projectNameField;
    LabeledBrowsableTextField mm_rootFolderField;
    private ProjectNameValidator mm_pnValid = new ProjectNameValidator(PortalPlugin.getWorkspace());
    private String mm_projectRootFolderName;
    private String mm_openParFolder;

    public OpenParWizardPage() {
        super("Portal Application Project from a PAR file", "Portal Application Project from a PAR file", SAPImageDescriptors.SAP_LOGO);
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite content = sappoEclipseStylePanel.getContentPane();
        this.setTitle("Portal Application Project from a PAR file");
        this.setDescription("A new project is created from an existing PAR or ZAR file.\n");
        content.setLayout((Layout)new GridLayout(1, true));
        this.mm_parNameField = new LabeledBrowsableTextField(content, 0, "Archive file name:");
        this.mm_parNameField.setToolTipText("The absolute path of the .par/.zar file to open");
        this.mm_parNameField.setFileSelectionMode(0);
        this.mm_parNameField.setFilterNames(new String[]{"*.par - portal archive", "*.par.bak - portal archive backup", "*.zar - service archive", "*.zar.bak - service archive backup"});
        this.mm_parNameField.setFilterExtensions(new String[]{"*.par", "*.par.bak", "*.zar", "*.zar.bak"});
        if (this.mm_openParFolder != null) {
            this.mm_parNameField.setInitalDirectory(this.mm_openParFolder);
        }
        this.mm_parNameField.getTextField().addModifyListener((ModifyListener)this);
        this.mm_parNameField.setDialogFlags(4096);
        this.mm_parNameField.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }
        });
        this.mm_projectNameField = new LabeledTextField(content, 0, "Project name:");
        this.mm_projectNameField.setToolTipText("the name of your new project");
        this.mm_projectNameField.setValue("NewParProject");
        this.mm_projectNameField.getTextField().addModifyListener((ModifyListener)this);
        this.mm_rootFolderField = new LabeledBrowsableTextField(content, 0, "Project root folder:");
        this.mm_rootFolderField.setToolTipText("the folder in which your project will reside");
        this.mm_rootFolderField.setValue(this.mm_projectRootFolderName);
        this.mm_rootFolderField.setFileSelectionMode(1);
        this.mm_rootFolderField.setDialogFlags(4096);
        this.mm_rootFolderField.addModifyListener(this);
        LabeledThingsGroup ltg = new LabeledThingsGroup();
        ltg.add(this.mm_parNameField);
        ltg.add(this.mm_projectNameField);
        ltg.add(this.mm_rootFolderField);
        ltg.alignTextFields();
        DropTarget dropTarget = new DropTarget((Control)parent, 21);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String filename = ((String[])event.data)[0];
                OpenParWizardPage.this.mm_parNameField.getTextField().setText(filename);
            }
        });
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-openPar");
        this.modifyText(null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mm_projectNameField.setFocus();
        this.mm_projectNameField.selectAll();
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(newMessage == null);
    }

    public boolean checkParField() {
        return true;
    }

    public String getFilePath() {
        return this.mm_parNameField.getValue();
    }

    public String getProjectRootFolderName() {
        return this.mm_rootFolderField.getValue();
    }

    public String getProjectName() {
        return this.mm_projectNameField.getValue();
    }

    public void setOpenParFolder(String openParFolder) {
        this.mm_openParFolder = openParFolder;
    }

    public void setProjectRootRootFolder(String projectRootRootFolder) {
        this.mm_projectRootFolderName = projectRootRootFolder;
    }

    public void modifyText(ModifyEvent e) {
        String parName = this.mm_parNameField.getValue();
        String projectName = this.mm_projectNameField.getValue();
        String projectRootRootFolder = this.mm_rootFolderField.getValue();
        if (parName == null || parName.trim().equals("")) {
            this.setErrorMessage("Please specify the name of the archive you want to open");
            return;
        }
        File f = new File(parName);
        if (!f.exists() || f.isDirectory()) {
            this.setErrorMessage("File does not exist!");
            return;
        }
        if (!Files.isValidLocalFileName(projectName)) {
            this.setErrorMessage(projectName + " is not a valid file name");
            return;
        }
        if (!Files.isValidFileName(projectRootRootFolder)) {
            this.setErrorMessage(projectRootRootFolder + " is not a valid folder name");
            return;
        }
        File file = new File(projectRootRootFolder, projectName);
        if (file.exists()) {
            this.setErrorMessage("File/Folder " + file.getAbsolutePath() + " already exists.\nPlease choose a different location or project name.");
            return;
        }
        try {
            if (projectName == null || projectName.trim().equals("")) {
                this.setErrorMessage("Project name is missing.");
                return;
            }
            if (this.mm_pnValid.existsProjectNameInScope(projectName)) {
                this.setErrorMessage("Project name " + projectName + " exists already in the workspace.");
                return;
            }
        }
        catch (CoreException ex) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)ex);
        }
        this.setErrorMessage(null);
    }
}

