/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.openPar;

import com.sap.portal.developmentTools.general.api.IFinishResult;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.IParIdePlugin;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.wizards.openArchive.OpenArchiveWizardTemplate;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.openPar.OpenParWizardPage;
import com.sap.portal.util.eclipse.FinishResult;
import com.sap.portal.util.eclipse.FinishResultPool;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class OpenParWizard
extends Wizard
implements IImportWizard {
    OpenParWizardPage mm_myPage;
    IWorkbench mm_workbench;
    boolean mm_result;
    private String mm_statusType;
    private String mm_statusMessage;

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Opening Par - ", 21);
                IGUI guiSystem = OpentoolsFactory.getGuiSystem();
                monitor.worked(1);
                monitor.subTask("Extracting Par: ");
                OpenParWizard.this.mm_result = OpenArchiveWizardTemplate.finishOpenArchivePage(OpenParWizard.this.mm_myPage, OpenParWizard.this.getShell()) != null;
                monitor.worked(1);
                monitor.subTask("Creating Project: ");
                IProject project = (IProject)OpenArchiveWizardTemplate.project;
                monitor.worked(1);
                Enumeration enumeration = PortalPlugin.REGISTERED_PLUGINS.keys();
                while (enumeration.hasMoreElements()) {
                    String pluginId = (String)enumeration.nextElement();
                    FinishResultPool.getInstance().release(pluginId);
                    IParIdePlugin plugin = (IParIdePlugin)PortalPlugin.REGISTERED_PLUGINS.get(pluginId);
                    IFinishResult result = FinishResultPool.getInstance().getReport(pluginId);
                    try {
                        plugin.unpack(project, result);
                    }
                    catch (Throwable t) {
                        result.setFinalState(2);
                        result.addError("Additional Plugin Error - The Plugin \"" + pluginId + "\" caused an exception during the \"Unpack\" operation.\nSee log for more details");
                        MessageDialog.openError((Shell)OpenParWizard.this.getShell(), (String)"Additional Plugin Error", (String)("The Plugin \"" + pluginId + "\" caused an exception during the \"Unpack\" operation.\nSee log for more details"));
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)t, (String)("The Plugin \"" + pluginId + "\" caused an exception during the \"Unpack\" operation"));
                    }
                    ((FinishResult)result).addInformationsInTaskView(project);
                    if (result.getFinalState() != 2) continue;
                    throw new InterruptedException("Error in registered plugin \"" + pluginId + "\" !");
                }
                monitor.worked(1);
                URL pluginUrl = PortalPlugin.getIPluginDescriptor().find((IPath)new Path(""));
                monitor.worked(1);
                String pluginPath = pluginUrl.getFile();
                monitor.worked(1);
                pluginPath = "ECLIPSE_HOME" + File.separator + pluginPath.substring(pluginPath.indexOf("plugins"));
                monitor.worked(1);
                IPreferenceStore store = PortalPlugin.getDefault().getPreferenceStore();
                monitor.worked(1);
                String libs = "true";
                monitor.worked(1);
                try {
                    libs = store.getString("com.sap.developmentTools.libs");
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    guiSystem.showErrorMessage("Error", "An error has occured getting the stored information.", e, OpenParWizard.this.getShell());
                }
                monitor.worked(1);
                if (libs.equalsIgnoreCase("true") || libs.equalsIgnoreCase("")) {
                    try {
                        monitor.subTask("Setting Classpath: ");
                        String portalPluginPath = pluginUrl.getFile();
                        portalPluginPath = "ECLIPSE_HOME" + File.separator + portalPluginPath.substring(portalPluginPath.indexOf("plugins"));
                        String eclipsePath = System.getProperty("user.dir");
                        String[] sapIdePaths = new String[]{"com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib", "com.sap.security" + File.separator + "lib", "com.sap.ext.libs.webservices" + File.separator + "lib", "com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib", "com.sap.ext.libs.webservices" + File.separator + "lib", "com.tssap.sap.libs.xmltoolkit" + File.separator + "lib", "com.sap.engine.webservices" + File.separator + "lib"};
                        if (new File(eclipsePath + File.separator + "plugins" + File.separator + sapIdePaths[0]).isDirectory()) {
                            String[] portalLibs = new String[]{portalPluginPath + File.separator + "prtapi.jar", portalPluginPath + File.separator + "prttest.jar", portalPluginPath + File.separator + "com.sap.portal.runtime.application.soap_api.jar"};
                            String[] sapIdeLibs = new String[]{"activation.jar", "com.sap.security.api.jar", "jaxm-api.jar", "mail.jar", "saaj-api.jar", "sapxmltoolkit.jar", "webservices_lib.jar"};
                            monitor.worked(1);
                            OpentoolsFactory.getIDEInstance().addLibrariesReferences(project, portalLibs);
                            int i = 0;
                            while (i < sapIdeLibs.length) {
                                String pluginPathSep = "ECLIPSE_HOME" + File.separator + "plugins" + File.separator;
                                monitor.worked(1);
                                OpentoolsFactory.getIDEInstance().addLibraryReference(project, pluginPathSep + sapIdePaths[i] + File.separator + sapIdeLibs[i]);
                                ++i;
                            }
                        } else {
                            String[] allPortalLibs = new String[]{portalPluginPath + File.separator + "prtapi.jar", portalPluginPath + File.separator + "prttest.jar", portalPluginPath + File.separator + "com.sap.portal.runtime.application.soap_api.jar", portalPluginPath + File.separator + "sapxmltoolkit.jar", portalPluginPath + File.separator + "jaxm-api.jar", portalPluginPath + File.separator + "jaxp.jar", portalPluginPath + File.separator + "saaj-api.jar", portalPluginPath + File.separator + "com.sap.security.api.jar"};
                            monitor.worked(1);
                            OpentoolsFactory.getIDEInstance().addLibrariesReferences(project, allPortalLibs);
                        }
                    }
                    catch (Exception e) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    }
                }
                monitor.worked(1);
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e);
            this.mm_result = false;
            this.mm_statusType = e.getClass().getName();
            this.mm_statusMessage = e.getMessage();
        }
        if (!this.mm_result) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.mm_statusType, (String)this.mm_statusMessage);
        }
        return this.mm_result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mm_myPage = new OpenParWizardPage();
        this.mm_workbench = workbench;
        this.setWindowTitle("Import");
        OpenArchiveWizardTemplate.initalizeWizardPage(this.getShell(), this.mm_myPage);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mm_myPage);
    }
}

