/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newProjectFromExisting;

import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.api.StringBasedFileFilter;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newProjectFromExisting.NewProjectFromExistingPage;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class NewProjectFromExistingProjectWizard
extends Wizard
implements IImportWizard {
    private NewProjectFromExistingPage mm_myPage;
    private IWorkbench mm_workbench;
    private IGUI mm_guiSystem = OpentoolsFactory.getGuiSystem();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mm_workbench = workbench;
        this.setWindowTitle("Import");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mm_myPage = new NewProjectFromExistingPage();
        this.addPage((IWizardPage)this.mm_myPage);
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Opening -  ", 22);
                monitor.subTask("Creating Project");
                monitor.worked(1);
                String projectName = NewProjectFromExistingProjectWizard.this.mm_myPage.getEnteredProjectName();
                Object project = null;
                File selectedFolder = null;
                EP epInstance = null;
                IDE ideInstance = null;
                try {
                    selectedFolder = NewProjectFromExistingProjectWizard.this.mm_myPage.getSelectedFolder();
                    monitor.worked(1);
                    File dotProject = new File(selectedFolder, ".project");
                    monitor.subTask("Creating .project");
                    monitor.worked(1);
                    File dotClasspath = new File(selectedFolder, ".classpath");
                    monitor.subTask("Creating .classpath");
                    monitor.worked(1);
                    if (dotProject.exists()) {
                        dotProject.delete();
                    }
                    if (dotClasspath.exists()) {
                        dotClasspath.delete();
                    }
                    monitor.subTask("Executing Refresh and Compilation - Please Wait");
                    monitor.worked(1);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    NewProjectFromExistingProjectWizard.this.mm_guiSystem.showErrorMessage("Error", "Cannot create the project configuration files.\nPlease check that you do not have a .project and/or a .classpath file in the selected folder.", e);
                }
                try {
                    epInstance = OpentoolsFactory.getEPInstance();
                    monitor.worked(1);
                    ideInstance = OpentoolsFactory.getIDEInstance();
                    String[] initialSrcPathFolderNameSegments = new String[]{"src.api"};
                    String[] initialOutPathFolderNameSegments = new String[]{"classes.api"};
                    String[] srcPathFolderNameSegments = new String[]{"src.core"};
                    project = ideInstance.prepareNewProject(selectedFolder, initialSrcPathFolderNameSegments, initialOutPathFolderNameSegments, projectName);
                    ideInstance.addSrcPathInProject(project, srcPathFolderNameSegments);
                    ideInstance.updateProjectFromFilesSystem(project, new StringBasedFileFilter(this, initialOutPathFolderNameSegments, initialSrcPathFolderNameSegments, srcPathFolderNameSegments){
                        private final /* synthetic */ String[] val$initialOutPathFolderNameSegments;
                        private final /* synthetic */ String[] val$initialSrcPathFolderNameSegments;
                        private final /* synthetic */ String[] val$srcPathFolderNameSegments;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$initialOutPathFolderNameSegments = val$initialOutPathFolderNameSegments;
                            this.val$initialSrcPathFolderNameSegments = val$initialSrcPathFolderNameSegments;
                            this.val$srcPathFolderNameSegments = val$srcPathFolderNameSegments;
                        }

                        public boolean accept(String[] segments, boolean isDir) throws IOException {
                            return !segments.equals(this.val$initialOutPathFolderNameSegments) && !segments.equals(this.val$initialSrcPathFolderNameSegments) && !segments.equals(this.val$srcPathFolderNameSegments);
                        }
                    });
                    monitor.worked(1);
                    epInstance.doCoreClassPathSettings(project);
                    monitor.worked(1);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    NewProjectFromExistingProjectWizard.this.mm_guiSystem.showErrorMessage("Error", "Cannot configure this project.", e);
                }
                try {
                    monitor.worked(1);
                    Eclipse2IDE.selectAndReveal((IResource)project, NewProjectFromExistingProjectWizard.this.mm_workbench.getActiveWorkbenchWindow());
                    monitor.worked(1);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    NewProjectFromExistingProjectWizard.this.mm_guiSystem.showErrorMessage("Error", "Cannot update this project", e);
                }
                monitor.worked(1);
                IProject iProject = (IProject)project;
                URL pluginUrl = PortalPlugin.getIPluginDescriptor().find((IPath)new Path(""));
                String pluginPath = pluginUrl.getFile();
                pluginPath = "ECLIPSE_HOME" + File.separator + pluginPath.substring(pluginPath.indexOf("plugins"));
                IPreferenceStore store = PortalPlugin.getDefault().getPreferenceStore();
                String libs = "true";
                try {
                    libs = store.getString("com.sap.developmentTools.libs");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (libs.equalsIgnoreCase("true") || libs.equalsIgnoreCase("")) {
                    try {
                        monitor.subTask("Setting Classpath: ");
                        String portalPluginPath = pluginUrl.getFile();
                        portalPluginPath = "ECLIPSE_HOME" + File.separator + portalPluginPath.substring(portalPluginPath.indexOf("plugins"));
                        String eclipsePath = System.getProperty("user.dir");
                        String[] sapIdePaths = new String[]{"com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib", "com.sap.security" + File.separator + "lib", "com.sap.ext.libs.webservices" + File.separator + "lib", "com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib", "com.sap.ext.libs.webservices" + File.separator + "lib", "com.tssap.sap.libs.xmltoolkit" + File.separator + "lib", "com.sap.engine.webservices" + File.separator + "lib"};
                        if (new File(eclipsePath + File.separator + "plugins" + File.separator + sapIdePaths[0]).isDirectory()) {
                            String[] portalLibs = new String[]{portalPluginPath + File.separator + "prtapi.jar", portalPluginPath + File.separator + "prttest.jar", portalPluginPath + File.separator + "com.sap.portal.runtime.application.soap_api.jar"};
                            String[] sapIdeLibs = new String[]{"activation.jar", "com.sap.security.api.jar", "jaxm-api.jar", "mail.jar", "saaj-api.jar", "sapxmltoolkit.jar", "webservices_lib.jar"};
                            monitor.worked(1);
                            OpentoolsFactory.getIDEInstance().addLibrariesReferences(project, portalLibs);
                            int i = 0;
                            while (i < sapIdeLibs.length) {
                                String pluginPathSep = "ECLIPSE_HOME" + File.separator + "plugins" + File.separator;
                                monitor.worked(1);
                                OpentoolsFactory.getIDEInstance().addLibraryReference(project, pluginPathSep + sapIdePaths[i] + File.separator + sapIdeLibs[i]);
                                ++i;
                            }
                        } else {
                            String[] allPortalLibs = new String[]{portalPluginPath + File.separator + "prtapi.jar", portalPluginPath + File.separator + "prttest.jar", portalPluginPath + File.separator + "com.sap.portal.runtime.application.soap_api.jar", portalPluginPath + File.separator + "sapxmltoolkit.jar", portalPluginPath + File.separator + "jaxm-api.jar", portalPluginPath + File.separator + "jaxp.jar", portalPluginPath + File.separator + "saaj-api.jar", portalPluginPath + File.separator + "com.sap.security.api.jar"};
                            monitor.worked(1);
                            OpentoolsFactory.getIDEInstance().addLibrariesReferences(project, allPortalLibs);
                        }
                    }
                    catch (Exception e) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                        NewProjectFromExistingProjectWizard.this.mm_guiSystem.showErrorMessage("Error", "Cannot set the libraries for this project", e);
                    }
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e);
        }
        return true;
    }
}

