/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newProjectFromExisting;

import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.FileBrowsePanel;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewProjectFromExistingPage
extends WizardPage
implements ModifyListener {
    public static final String EPPAR = "eppar";
    private EP epinstance = OpentoolsFactory.getEPInstance();
    private FileBrowsePanel fbp;
    private Label projectNameInputField;
    private Label projectNameUserEnteredLabel;
    private Text projectNameUserEntered;
    final HashSet existingProjectNames = new HashSet();

    public NewProjectFromExistingPage() {
        super("Portal Application Project from existing file system structure.", "Portal Application Project from existing file system structure.", SAPImageDescriptors.SAP_LOGO);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(control, 0);
        l.setText("Please select the location of your existing portal application structure.");
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        l.setLayoutData((Object)layoutData);
        FileFilter onlyDirsFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        this.fbp = new FileBrowsePanel(control, 0, onlyDirsFilter);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        this.fbp.getControl().setLayoutData((Object)layoutData);
        this.fbp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewProjectFromExistingPage.this.checkState();
            }
        });
        Label projectNameDescriptionLabel = new Label(control, 0);
        projectNameDescriptionLabel.setLayoutData((Object)new GridData(32));
        projectNameDescriptionLabel.setText("Prospective project name:");
        this.projectNameInputField = new Label(control, 0);
        this.projectNameInputField.setLayoutData((Object)new GridData(768));
        this.projectNameInputField.setText("?");
        this.projectNameUserEnteredLabel = new Label(control, 0);
        this.projectNameUserEnteredLabel.setLayoutData((Object)new GridData(32));
        this.projectNameUserEnteredLabel.setText("Enter a project name:");
        this.projectNameUserEntered = new Text(control, 0);
        this.projectNameUserEntered.setLayoutData((Object)new GridData(768));
        this.projectNameUserEntered.setText("?");
        this.projectNameUserEntered.addModifyListener((ModifyListener)this);
        FontData fontData = this.projectNameInputField.getFont().getFontData()[0];
        this.projectNameInputField.setFont(new Font((Device)this.getShell().getDisplay(), fontData.getName(), fontData.getHeight(), 1));
        try {
            IResource[] existingProjects = PortalPlugin.getWorkspace().getRoot().members(4);
            int i = 0;
            while (i < existingProjects.length) {
                this.existingProjectNames.add(existingProjects[i].getName());
                ++i;
            }
        }
        catch (CoreException e) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e);
        }
        this.setControl((Control)control);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-newFromExisting");
        WorkbenchHelp.setHelp((Control)this.fbp.getControl(), (String)"com.sap.ep.applicationDevelopment.help-newFromExisting");
    }

    public void performHelp() {
        super.performHelp();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fbp.getControl().setFocus();
        }
    }

    private void checkState() {
        File folder = this.getSelectedFolder();
        if (!this.epinstance.isPossibleComponentRootFolder(folder)) {
            this.projectNameInputField.setText("?");
            this.projectNameUserEntered.setText("?");
            this.setErrorMessage("This folder doesn't look like a portal application structure.");
            this.setPageComplete(false);
            return;
        }
        String name = folder.getName();
        if (name.equalsIgnoreCase(EPPAR)) {
            name = folder.getParentFile().getName();
        }
        this.projectNameInputField.setText(name);
        this.projectNameUserEntered.setText(name);
        if (this.existingProjectNames.contains(this.projectNameUserEntered.getText())) {
            this.setErrorMessage("A project of the same name already exists.");
            this.setPageComplete(false);
            return;
        }
        File selectedFolder = this.getSelectedFolder();
        File dotProject = new File(selectedFolder, ".project");
        File dotClasspath = new File(selectedFolder, ".classpath");
        if (dotProject.exists()) {
            this.setErrorMessage("A project definition already exists in this folder.");
            this.setPageComplete(false);
            return;
        }
        if (dotClasspath.exists()) {
            this.setErrorMessage("A classpath definition already exists in this folder.");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public File getSelectedFolder() {
        return (File)this.fbp.getSelection().getFirstElement();
    }

    public String getEnteredProjectName() {
        return this.projectNameUserEntered.getText();
    }

    public void modifyText(ModifyEvent arg0) {
        File selectedFolder = this.getSelectedFolder();
        File dotProject = new File(selectedFolder, ".project");
        File dotClasspath = new File(selectedFolder, ".classpath");
        File folder = this.getSelectedFolder();
        if (!this.epinstance.isPossibleComponentRootFolder(folder)) {
            this.setErrorMessage("This folder doesn't look like a portal application structure.");
            this.setPageComplete(false);
        } else if (this.existingProjectNames.contains(this.projectNameUserEntered.getText())) {
            this.setErrorMessage("A project of the same name already exists.");
            this.setPageComplete(false);
        } else if (dotProject.exists()) {
            this.setErrorMessage("A project definition already exists in this folder.");
            this.setPageComplete(false);
        } else if (dotClasspath.exists()) {
            this.setErrorMessage("A classpath definition already exists in this folder.");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

