/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard;

import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PDKCustomComponentExtension {
    private String name;
    private String id;
    private String description;
    private String className;
    private String imageKey;
    private String category;
    private IExtension extension;

    public PDKCustomComponentExtension(IExtension extension) throws Exception {
        try {
            IConfigurationElement wizardElement = extension.getConfigurationElements()[0];
            if (!wizardElement.getName().toLowerCase().equals("wizard")) {
                throw new Exception("Top element must be 'wizard'");
            }
            this.extension = extension;
            this.name = wizardElement.getAttribute("name");
            this.id = wizardElement.getAttribute("id");
            this.className = wizardElement.getAttribute("class");
            this.category = wizardElement.getAttribute("category");
            String iconLocation = wizardElement.getAttribute("icon");
            this.imageKey = this.name + iconLocation;
            URL absoluteImageURL = new URL(PortalPlugin.getDefault().getDescriptor().getInstallURL(), iconLocation);
            try {
                PortalPlugin.getDefault().getImageRegistry().put(this.imageKey, ImageDescriptor.createFromURL((URL)absoluteImageURL));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.description = "";
            IConfigurationElement[] children = wizardElement.getChildren();
            if (children.length > 0) {
                if (!children[0].getName().toLowerCase().equals("description")) {
                    throw new Exception("Children element must be 'description'");
                }
                this.description = children[0].getValue();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            throw new Exception("Error in plugin.xml: A component from extension point 'PDKCustomPortalComponent' is misconfigured!!!\nThis component will be ignored.\n\nMessage: " + e.getMessage());
        }
    }

    public Image getIconFromImageRegistry() {
        return PortalPlugin.getDefault().getImageRegistry().get(this.imageKey);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public IExtension getExtension() {
        return this.extension;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }
}

