/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard;

import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.api.IPropertySystem;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.wizards.newGenericWizard.INewGenericWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.NewGenericWizard;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.PDKCustomComponentExtension;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.PDKCustomComponentExtensionPoint;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.PDKExtensionPointContentAndLabelProvider;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class NewGenericWizardPage
extends WizardPage
implements INewGenericWizardStringLiterals {
    private static final String THIS_PROP_GROUP = "com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard";
    private static final String SELECTED_WIZARD_PROP = "selectedCustomWizard";
    private AbstractProfiles profiles;
    private IProject lastSelectedProject;
    private PDKCustomComponentExtensionPoint pdkExtensionPoint = null;
    private StyledText text;
    private int mm_filterType = 0;
    private PDKCustomComponentExtension selectedPDKExtension;
    private HashMap extensionObjectToWizard = new HashMap();
    private Tree tree;
    private TreeViewer treeViewer;

    public NewGenericWizardPage(String pageName) {
        this(pageName, 0);
    }

    public NewGenericWizardPage(String pageName, int filterType) {
        super(pageName);
        this.setTitle("Portal Application Object");
        this.setDescription("Create a Portal Application Object");
        this.mm_filterType = filterType;
    }

    public boolean canFlipToNextPage() {
        return this.selectedPDKExtension != null && !this.selectedPDKExtension.getId().equals("com.sap.developmentTools.wizard.NewComponent") && !this.selectedPDKExtension.getId().equals("com.sap.developmentTools.wizard.NewWebService");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.tree.setFocus();
            IProject selectedProject = ((NewGenericWizard)this.getWizard()).getSelectedProject();
            IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
            try {
                String wizardName = propSystem.loadProperty(THIS_PROP_GROUP, SELECTED_WIZARD_PROP, selectedProject);
                PDKCustomComponentExtension[] extensions = this.pdkExtensionPoint.getExtensions(null);
                int i = 0;
                while (i < extensions.length) {
                    PDKCustomComponentExtension extension = extensions[i];
                    if (extension.getName().equals(wizardName)) {
                        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)extension));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            }
        }
    }

    public IWizardPage getNextPage() {
        if (this.selectedPDKExtension == null) {
            return this;
        }
        IPDKCustomComponentWizard pdkCustomComponentWizard = (IPDKCustomComponentWizard)this.extensionObjectToWizard.get(this.selectedPDKExtension);
        IProject selectedProject = ((NewGenericWizard)this.getWizard()).getSelectedProject();
        if (selectedProject != this.lastSelectedProject) {
            try {
                this.profiles = OpentoolsFactory.getEPInstance().getCurrentProfiles(selectedProject);
            }
            catch (Exception e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occurred reading the profiles of project " + selectedProject.getName()));
                this.getContainer().getShell().close();
                return null;
            }
        }
        if (pdkCustomComponentWizard == null) {
            IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
            try {
                propSystem.saveProperty(THIS_PROP_GROUP, SELECTED_WIZARD_PROP, this.selectedPDKExtension.getName(), selectedProject);
            }
            catch (Exception e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            }
            String wizardsClassName = this.selectedPDKExtension.getClassName();
            ClassLoader wizardsClassLoader = this.selectedPDKExtension.getExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
            try {
                pdkCustomComponentWizard = (IPDKCustomComponentWizard)wizardsClassLoader.loadClass(wizardsClassName).newInstance();
            }
            catch (Exception e) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error on selected wizard", (String)("An error occurred during creation of the selected wizard.\nException(" + e.getClass().getName() + "): " + e.getMessage()));
                e.printStackTrace();
                return null;
            }
            StructuredSelection projectSelection = new StructuredSelection((Object)selectedProject);
            pdkCustomComponentWizard.setContainer(this.getContainer());
            pdkCustomComponentWizard.setProfiles(this.profiles);
            pdkCustomComponentWizard.init(PortalPlugin.getDefault().getWorkbench(), (IStructuredSelection)projectSelection);
            pdkCustomComponentWizard.addPages();
            this.extensionObjectToWizard.put(this.selectedPDKExtension, pdkCustomComponentWizard);
        }
        this.lastSelectedProject = selectedProject;
        if (pdkCustomComponentWizard.getProject() != selectedProject) {
            pdkCustomComponentWizard.setCurrentProject(selectedProject);
            pdkCustomComponentWizard.setProfiles(this.profiles);
        }
        return pdkCustomComponentWizard.getStartingPage();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        main.setLayout((Layout)gl);
        Composite treeComposite = new Composite(main, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 290;
        treeComposite.setLayoutData((Object)gd);
        treeComposite.setLayout((Layout)new GridLayout());
        Composite descriptionComposite = new Composite(main, 0);
        descriptionComposite.setLayoutData((Object)new GridData(1808));
        descriptionComposite.setLayout((Layout)new GridLayout());
        Label treeLabel = new Label(treeComposite, 0);
        treeLabel.setText("Please select a template");
        IExtensionPoint extensionPoint = PortalPlugin.getDefault().getDescriptor().getExtensionPoint("PDKCustomPortalComponent");
        try {
            this.pdkExtensionPoint = new PDKCustomComponentExtensionPoint(extensionPoint);
            this.pdkExtensionPoint.getExtensions("com.sap.developmentTools.wizard.NewWebService");
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            MessageDialog.openError((Shell)main.getShell(), (String)"Error", (String)e.getMessage());
        }
        this.tree = new Tree(treeComposite, 2048);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(this.tree);
        PDKExtensionPointContentAndLabelProvider provider = new PDKExtensionPointContentAndLabelProvider();
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.treeViewer.setInput((Object)this.pdkExtensionPoint);
        if (this.mm_filterType == 1) {
            this.treeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    PDKCustomComponentExtension componentExtension = (PDKCustomComponentExtension)element;
                    return componentExtension.getId().equals("com.sap.developmentTools.wizard.NewComponent") || componentExtension.getCategory() != null;
                }
            });
            this.treeViewer.expandAll();
        } else if (this.mm_filterType == 2) {
            this.treeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    PDKCustomComponentExtension componentExtension = (PDKCustomComponentExtension)element;
                    return componentExtension.getId().equals("com.sap.developmentTools.wizard.NewService") || componentExtension.getId().equals("com.sap.developmentTools.wizard.NewWebService") || componentExtension.getCategory() != null;
                }
            });
            this.treeViewer.expandAll();
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                PDKCustomComponentExtension selection = null;
                if (selectedObject instanceof PDKCustomComponentExtension) {
                    selection = (PDKCustomComponentExtension)selectedObject;
                    if (selection.getId() != null && !selection.getId().equals("com.sap.developmentTools.wizard.NewComponent") && !selection.getId().equals("com.sap.developmentTools.wizard.NewWebService")) {
                        NewGenericWizardPage.this.selectedPDKExtension = selection;
                        NewGenericWizardPage.this.text.setText(NewGenericWizardPage.this.selectedPDKExtension.getDescription());
                        NewGenericWizardPage.super.getContainer().updateButtons();
                    } else {
                        NewGenericWizardPage.this.selectedPDKExtension = null;
                    }
                }
            }
        });
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NewGenericWizardPage.super.getContainer().showPage(NewGenericWizardPage.this.getNextPage());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent clickEvent) {
                Object selectedObject = ((IStructuredSelection)clickEvent.getSelection()).getFirstElement();
                if (selectedObject instanceof PDKCustomComponentExtension) {
                    PDKCustomComponentExtension selection = (PDKCustomComponentExtension)selectedObject;
                    boolean expandedState = NewGenericWizardPage.this.treeViewer.getExpandedState((Object)selection);
                    if (!expandedState) {
                        NewGenericWizardPage.this.treeViewer.expandToLevel((Object)selection, 1);
                    } else {
                        NewGenericWizardPage.this.treeViewer.collapseToLevel((Object)selection, 1);
                    }
                }
            }
        });
        Label descLabel = new Label(descriptionComposite, 0);
        descLabel.setText("Description:");
        this.text = new StyledText(descriptionComposite, 2048);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setEditable(false);
        this.text.setEnabled(false);
        this.text.setWordWrap(true);
        this.text.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
        this.text.setText("No thing selected yet.");
        this.setControl((Control)main);
    }
}

