/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards;

import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.portal.developmentTools.general.gui.swt.LabeledFileTextField;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.gui.swt.SpecifyClassAndPackageComposite;
import com.sap.portal.developmentTools.general.iDE.AbstractIDE;
import com.sap.portal.developmentTools.general.wizards.newComponentWizards.INewJSPDynPageWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards.NewJSPDynPageWizardPageTwo;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewJSPDynPageWizardPageOne
extends WizardPage
implements INewJSPDynPageWizardStringLiterals,
ModifyListener {
    private Object project;
    private SpecifyClassAndPackageComposite classPackageComposite;
    private LabeledFileTextField jspFileNameField;
    private Set forbiddenClassNames = new HashSet();
    private File currentProjectFolder;

    public NewJSPDynPageWizardPageOne(Object project) {
        super("");
        this.setTitle("New JSPDynPage");
        this.setDescription("Create a PageProcessorComponent subclass using a JSPDynPage and a corresponding JSP file");
        this.setProject((IProject)project);
    }

    public void setProject(IProject project) {
        this.project = project;
        this.currentProjectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.classPackageComposite.setFocus();
        }
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        container.setLayout((Layout)new GridLayout());
        this.classPackageComposite = new SpecifyClassAndPackageComposite(0, container, 0, this.project);
        this.classPackageComposite.setClassLabel("JSPDynPage class name: ");
        this.classPackageComposite.setPackageLabel("JSPDynPage package name: ");
        this.classPackageComposite.addModifyListener(this);
        this.classPackageComposite.setForbiddenClassNames(this.forbiddenClassNames);
        this.jspFileNameField = new LabeledFileTextField(container, 0, "JSP Filename: ");
        this.jspFileNameField.setToolTipText("Specify the JSP's filename. It will be created in \"private/pagelet\".");
        this.jspFileNameField.setEmptyFileNameAllowed(false);
        this.jspFileNameField.addModifyListener(this);
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.classPackageComposite);
        labelGroup.add(this.jspFileNameField);
        labelGroup.alignTextFields();
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        this.classPackageComposite.setFocus();
        this.modifyText(null);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-newjspDynPage");
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(newMessage == null);
    }

    public void modifyText(ModifyEvent e) {
        String errorMessage = this.classPackageComposite.validate();
        if (errorMessage == null) {
            errorMessage = this.jspFileNameField.validate();
        }
        if (errorMessage == null && this.currentProjectFolder != null) {
            String[] privateResourcePath = OpentoolsFactory.getEPInstance().getPrivateResourcePath();
            String[] jspSegments = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(AbstractIDE.cleanJSPFileName(this.jspFileNameField.getValue()));
            ArrayList<String> absoluteSegmentsList = new ArrayList<String>(Arrays.asList(privateResourcePath));
            absoluteSegmentsList.add("pagelet");
            absoluteSegmentsList.addAll(Arrays.asList(jspSegments));
            String[] absoluteSegments = absoluteSegmentsList.toArray(new String[absoluteSegmentsList.size()]);
            try {
                File jspFile = OpentoolsFactory.getIDEInstance().getFileObjectFor(this.project, absoluteSegments);
                if (jspFile.exists()) {
                    errorMessage = "File " + jspFile.getAbsolutePath() + " already exists.";
                }
            }
            catch (IOException e1) {
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
            }
        }
        this.setErrorMessage(errorMessage);
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = super.getNextPage();
        if (nextPage instanceof NewJSPDynPageWizardPageTwo) {
            NewJSPDynPageWizardPageTwo newJSPDynPageWizardPageTwo = (NewJSPDynPageWizardPageTwo)nextPage;
            HashSet<String> pageTwoForbiddenNames = new HashSet<String>(this.forbiddenClassNames);
            pageTwoForbiddenNames.add(this.classPackageComposite.getFullyQualifiedClassName());
            newJSPDynPageWizardPageTwo.setForbiddenClassNames(pageTwoForbiddenNames);
        }
        return nextPage;
    }

    public String getClassName() {
        return this.classPackageComposite.getClassName();
    }

    public String getPackageName() {
        return this.classPackageComposite.getPackageName();
    }

    public String getFullyQualifiedClassName() {
        return this.classPackageComposite.getFullyQualifiedClassName();
    }

    public String getLocationField() {
        return this.classPackageComposite.getLocationField();
    }

    public String getJSPName() {
        return this.jspFileNameField.getValue();
    }

    public void setForbiddenClassNames(Set forbiddenClassNames) {
        this.forbiddenClassNames = forbiddenClassNames;
        if (this.classPackageComposite != null) {
            this.classPackageComposite.setForbiddenClassNames(forbiddenClassNames);
            this.modifyText(null);
        }
    }

    public boolean canFlipToNextPage() {
        return this.classPackageComposite.validate() == null && this.jspFileNameField.validate() == null && this.currentProjectFolder != null;
    }
}

