/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards;

import com.sap.portal.developmentTools.ePSpecific.EP6;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.general.iDE.AbstractIDE;
import com.sap.portal.developmentTools.general.wizards.newComponentWizards.INewJSPDynPageWizardStringLiterals;
import com.sap.portal.developmentTools.general.wizards.sapwizard.ISAPWWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards.NewJSPDynPageWizardPageOne;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards.NewJSPDynPageWizardPageTwo;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import com.sap.portal.util.Templating;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewJSPDynPageWizard
extends Wizard
implements INewWizard,
IPDKCustomComponentWizard,
INewJSPDynPageWizardStringLiterals,
ISAPWWizardStringLiterals {
    private NewJSPDynPageWizardPageOne pageOne;
    private NewJSPDynPageWizardPageTwo pageTwo;
    private AbstractProfiles profiles;
    private URL pluginInstallURL;
    private IProject project = null;
    private Set forbiddenClassNames = new HashSet();

    public NewJSPDynPageWizard() {
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.pluginInstallURL = PortalPlugin.getDefault().getDescriptor().getInstallURL();
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New JSPDynPage");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        this.project = firstElement != null && firstElement instanceof IResource ? ((IResource)firstElement).getProject() : Eclipse2IDE.getCurrentProject();
        this.pageOne = new NewJSPDynPageWizardPageOne(this.project);
        this.pageTwo = new NewJSPDynPageWizardPageTwo(this.project);
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
        this.setCurrentProject(this.project);
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.profiles = profiles;
        if (this.pageOne != null) {
            // empty if block
        }
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String jspDynPageClassName = NewJSPDynPageWizard.this.pageOne.getClassName();
                String jspDynPagePackageName = NewJSPDynPageWizard.this.pageOne.getPackageName();
                String jspDynPageFullyQualifiedClassName = NewJSPDynPageWizard.this.pageOne.getFullyQualifiedClassName();
                String apiOrCore = NewJSPDynPageWizard.this.pageOne.getLocationField();
                String beanClassName = "";
                String beanFullyQualifiedClassName = "";
                String beanScope = "";
                String beanName = "";
                String beanApiOrCore = "";
                String jspFilename = AbstractIDE.cleanJSPFileName(NewJSPDynPageWizard.this.pageOne.getJSPName());
                IDE ideInstance = OpentoolsFactory.getIDEInstance();
                int taskCount = 3;
                boolean generateBeanStatements = NewJSPDynPageWizard.this.pageTwo.isGenerateBeanStatements();
                boolean useExistingBean = NewJSPDynPageWizard.this.pageTwo.isUseExistingBean();
                if (generateBeanStatements && !useExistingBean) {
                    ++taskCount;
                }
                monitor.beginTask("Processing requested operation...", taskCount);
                if (generateBeanStatements) {
                    beanName = NewJSPDynPageWizard.this.pageTwo.getBeanName();
                    String beanPackageName = NewJSPDynPageWizard.this.pageTwo.getBeanPackageName();
                    beanClassName = NewJSPDynPageWizard.this.pageTwo.getBeanClassName();
                    beanApiOrCore = NewJSPDynPageWizard.this.pageTwo.getLocation();
                    beanFullyQualifiedClassName = NewJSPDynPageWizard.this.pageTwo.getBeanFullyQualifiedClassName();
                    beanScope = NewJSPDynPageWizard.this.pageTwo.getBeanScope();
                    if (!useExistingBean) {
                        monitor.subTask("Creating bean source");
                        HashMap<String, String> beanTemplateMap = new HashMap<String, String>();
                        if (beanPackageName == null) {
                            beanPackageName = "";
                        }
                        beanPackageName = beanPackageName.trim();
                        beanTemplateMap.put("package", beanPackageName);
                        beanTemplateMap.put("class-name", beanClassName);
                        try {
                            if (beanApiOrCore.equals("Core")) {
                                PortalPlugin.createJavaFileFromTemplateAndOpenIt(NewJSPDynPageWizard.this.project, beanFullyQualifiedClassName, "templates/SimpleBeanTemplate.xml", beanTemplateMap, 1);
                            } else {
                                PortalPlugin.createJavaFileFromTemplateAndOpenIt(NewJSPDynPageWizard.this.project, beanFullyQualifiedClassName, "templates/SimpleBeanTemplate.xml", beanTemplateMap, 0);
                            }
                        }
                        catch (Exception e) {
                            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                            MessageDialog.openError((Shell)NewJSPDynPageWizard.this.getShell(), (String)"Error", (String)("Couldn't create/open bean class !!!\n\nError message: " + e.getMessage()));
                        }
                        monitor.worked(1);
                    }
                }
                monitor.subTask("Updating portalapp.xml");
                EP6 ep = new EP6();
                File portalapp = null;
                try {
                    portalapp = OpentoolsFactory.getIDEInstance().createFileInProject(NewJSPDynPageWizard.this.project, new String[]{"dist", "PORTAL-INF", "portalapp.xml"}, true);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                }
                try {
                    ep.addJSPComponent(NewJSPDynPageWizard.this.pageOne.getFullyQualifiedClassName(), NewJSPDynPageWizard.this.pageOne.getClassName(), "pagelet/" + jspFilename, portalapp);
                    ep.addSharingReference("com.sap.portal.htmlb", portalapp, "PrivateSharingReference");
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    MessageDialog.openWarning((Shell)NewJSPDynPageWizard.this.getShell(), (String)"Warning", (String)"Couldn't create .java file or modify the portalapp.xml.");
                }
                monitor.worked(1);
                monitor.subTask("Creating DynPage source");
                HashMap<String, String> dynPageClassMap = new HashMap<String, String>();
                if (jspDynPagePackageName == null) {
                    jspDynPagePackageName = "";
                }
                jspDynPagePackageName = jspDynPagePackageName.trim();
                dynPageClassMap.put("package", jspDynPagePackageName);
                dynPageClassMap.put("class-name", jspDynPageClassName);
                dynPageClassMap.put("scope", beanScope);
                dynPageClassMap.put("bean-class-name", beanClassName);
                dynPageClassMap.put("bean-full-class-name", beanFullyQualifiedClassName);
                dynPageClassMap.put("bean-name", beanName);
                dynPageClassMap.put("jsp-name", jspFilename);
                try {
                    if (apiOrCore.equalsIgnoreCase("core")) {
                        PortalPlugin.createJavaFileFromTemplateAndOpenIt(NewJSPDynPageWizard.this.project, jspDynPageFullyQualifiedClassName, "templates/JSPDynPageClassTemplate.xml", dynPageClassMap, 1);
                    } else {
                        PortalPlugin.createJavaFileFromTemplateAndOpenIt(NewJSPDynPageWizard.this.project, jspDynPageFullyQualifiedClassName, "templates/JSPDynPageClassTemplate.xml", dynPageClassMap, 0);
                    }
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    MessageDialog.openError((Shell)NewJSPDynPageWizard.this.pageOne.getShell(), (String)"Error", (String)("Couldn't create/open DynPage source file !!!\n\nError message: " + e.getMessage()));
                }
                monitor.worked(1);
                monitor.subTask("Creating JSP source");
                String[] publicResourcePath = OpentoolsFactory.getEPInstance().getPublicResourcePath();
                String[] jspSegments = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(jspFilename);
                ArrayList<String> absoluteSegmentsList = new ArrayList<String>(Arrays.asList(publicResourcePath));
                absoluteSegmentsList.add("pagelet");
                absoluteSegmentsList.addAll(Arrays.asList(jspSegments));
                String[] absoluteSegments = absoluteSegmentsList.toArray(new String[absoluteSegmentsList.size()]);
                try {
                    File jspFile = ideInstance.createFileInProject(NewJSPDynPageWizard.this.project, absoluteSegments, true);
                    FileWriter jspWriter = new FileWriter(jspFile);
                    InputStream jspTemplateStream = new URL(NewJSPDynPageWizard.this.pluginInstallURL, "templates/NewJSPDynPage_JSP.xml").openStream();
                    HashMap<String, String> jspMap = new HashMap<String, String>();
                    jspMap.put("bean-name", beanName);
                    jspMap.put("bean-class", beanFullyQualifiedClassName);
                    jspMap.put("scope", beanScope);
                    Templating.writeTemplateToWriter(jspMap, jspTemplateStream, jspWriter);
                    jspTemplateStream.close();
                    jspWriter.close();
                    ideInstance.openFileInEditor(NewJSPDynPageWizard.this.project, absoluteSegments);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    MessageDialog.openError((Shell)NewJSPDynPageWizard.this.pageOne.getShell(), (String)"Error", (String)("Couldn't create/open JSP file !!!\n\nError message: " + e.getMessage()));
                }
                monitor.worked(1);
                URL pluginUrl = PortalPlugin.getIPluginDescriptor().find((IPath)new Path(""));
                String pluginPath = pluginUrl.getFile();
                pluginPath = "ECLIPSE_HOME" + File.separator + pluginPath.substring(pluginPath.indexOf("plugins"));
                IPreferenceStore store = PortalPlugin.getDefault().getPreferenceStore();
                String libs = "true";
                try {
                    libs = store.getString("com.sap.developmentTools.libs");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (libs.equalsIgnoreCase("true") || libs.equalsIgnoreCase("")) {
                    try {
                        monitor.subTask("Setting Classpath: ");
                        String eclipsePath = System.getProperty("user.dir");
                        String eclipsePluginsPath = "ECLIPSE_HOME" + File.separator + "plugins";
                        String sapIdePath = "com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib";
                        if (new File(eclipsePath + File.separator + "plugins" + File.separator + sapIdePath).isDirectory()) {
                            String htmlbLib = eclipsePluginsPath + File.separator + "com.sap.tc.ap" + File.separator + "comp" + File.separator + "SAP_JTECHS" + File.separator + "DCs" + File.separator + "sap.com" + File.separator + "com.sapportals.htmlb" + File.separator + "_comp" + File.separator + "gen" + File.separator + "default" + File.separator + "public" + File.separator + "default" + File.separator + "lib" + File.separator + "java" + File.separator + "htmlb.jar";
                            OpentoolsFactory.getIDEInstance().addLibraryReference(NewJSPDynPageWizard.this.project, htmlbLib);
                            String htmlb_apiLib = pluginPath + File.separator + "com.sap.portal.htmlb_api.jar";
                            OpentoolsFactory.getIDEInstance().addLibraryReference(NewJSPDynPageWizard.this.project, htmlb_apiLib);
                            String servletLib = eclipsePluginsPath + File.separator + "com.tssap.ext.libs.j2ee_1.3" + File.separator + "lib" + File.separator;
                            servletLib = servletLib + "servlet.jar";
                            OpentoolsFactory.getIDEInstance().addLibraryReference(NewJSPDynPageWizard.this.project, servletLib);
                        }
                    }
                    catch (Exception e) {
                        SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    }
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        return true;
    }

    public void setCurrentProject(IProject project) {
        this.project = project;
        try {
            this.forbiddenClassNames = PortalPlugin.getAllFullyQualifiedClassNamesInProject(project);
        }
        catch (JavaModelException e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.forbiddenClassNames = new HashSet();
        }
        if (this.pageOne != null) {
            this.pageOne.setProject(project);
            this.pageOne.setForbiddenClassNames(this.forbiddenClassNames);
        }
        if (this.pageTwo != null) {
            this.pageTwo.setProject(project);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean canFinish() {
        return this.pageOne != null && this.pageOne.canFlipToNextPage() && this.pageTwo != null && this.pageTwo.validate() == null;
    }
}

