/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.dcproject;

import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.portal.developmentTools.ePSpecific.EP6;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.wizards.dcproject.INewDCProjectPage;
import com.sap.portal.developmentTools.general.wizards.dcproject.IPortalDCStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCPropertiesHandler;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PortalAppProjectCreator
implements IRunnableWithProgress,
IPortalDCStrings {
    private IStartCreateProjectWizard mm_startWizard;
    private INewDCProjectPage mm_newDCPage;

    public PortalAppProjectCreator(IStartCreateProjectWizard startWizard, INewDCProjectPage wPage) {
        this.mm_startWizard = startWizard;
        this.mm_newDCPage = wPage;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.mm_startWizard == null || this.mm_newDCPage == null) {
            return;
        }
        IProject project = this.mm_startWizard.getProjectHandle();
        IProjectDescription description = this.mm_startWizard.getProjectDescription();
        DCPropertiesHandler.checkNatureOrAddIt(description, "org.eclipse.jdt.core.javanature");
        DCPropertiesHandler.checkNatureOrAddIt(description, PortalPlugin.getPortalNatureID());
        EP6 epInstance = (EP6)OpentoolsFactory.getEPInstance();
        boolean isImportingPar = this.mm_newDCPage.isImportingPar();
        try {
            project.create(description, monitor);
            project.open(monitor);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        DCPropertiesHandler.addJRELib(project);
        ICommand command = this.mm_startWizard.getProjectDescription().newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        try {
            DCPropertiesHandler.setJavaCommand(this.mm_startWizard.getProjectDescription(), command);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        DCController controller = ((ProjectWizard)this.mm_startWizard).getDCController();
        Properties props = this.createProperties(this.mm_newDCPage);
        IStatus status = controller.fillProject(project, props, ((ProjectWizard)this.mm_startWizard).getActivity(), monitor);
        if (status.getSeverity() == 4) {
            throw new InvocationTargetException(new CoreException(status));
        }
        try {
            controller.getProject().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        DCPropertiesHandler.setParArchiveNameToDcdef(project, this.mm_newDCPage.getParArchiveName());
        if (this.mm_newDCPage.getSdaType() != null) {
            DCPropertiesHandler.setFlatDcdefProperty(project, "http://xml.sap.com/2004/06/PortalPlatform", "sda-type", this.mm_newDCPage.getSdaType());
        }
        DCPropertiesHandler.setFlatDcdefProperty(project, "http://xml.sap.com/2004/06/PortalPlatform", "package-sources", "false");
        IFolder srcFolder = project.getFolder("src");
        try {
            if (srcFolder.exists()) {
                srcFolder.delete(true, monitor);
            }
        }
        catch (CoreException e4) {
            e4.printStackTrace();
        }
        try {
            IFolder apiFolder = project.getFolder("src.api");
            IFolder coreFolder = project.getFolder("src.core");
            IFolder distFolder = project.getFolder("dist");
            apiFolder.create(true, true, monitor);
            coreFolder.create(true, true, monitor);
            distFolder.create(true, true, monitor);
            epInstance.createIViewProjectFileAndFolderStructure(project.getLocation().removeLastSegments(1).toOSString(), "_comp");
            if (isImportingPar) {
                System.out.println("Par to open: " + this.mm_newDCPage.getImportedParName());
                epInstance.createNewIViewProjectFromPar(project, new File(this.mm_newDCPage.getImportedParName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mm_startWizard.isLocal() || this.mm_startWizard.getActivity() == null) {
            return;
        }
        IVfsActivity activity = this.mm_startWizard.getActivity();
        if (activity == null) {
            return;
        }
        try {
            IVfsActivityRecordedFolderItem[] items = activity.getElementsFromOpenActivity();
            int i = 0;
            while (i < items.length) {
                IVfsActivityRecordedFolderItem item = items[i];
                if (item.getName().equals("src")) {
                    item.uncheckout();
                }
                ++i;
            }
        }
        catch (VfsException e2) {
            e2.printStackTrace();
        }
    }

    private void checkNatureOrAddIt(IProjectDescription desc, String nature) {
        String[] natures = desc.getNatureIds();
        if (!desc.hasNature(nature)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = nature;
            desc.setNatureIds(newNatures);
        }
    }

    private Properties createProperties(INewDCProjectPage wPage) {
        String dcSubType = wPage.getDCSubType();
        String parArchiveName = wPage.getParArchiveName();
        String sdaType = wPage.getSdaType();
        Properties props = new Properties();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("src.api");
        list.add("src.core");
        ((Hashtable)props).put("DCPackageFolder", list);
        list = new ArrayList();
        list.add("dist");
        ((Hashtable)props).put("DCSourceFolder", list);
        System.out.println(dcSubType);
        if (dcSubType.equals("Portal Application Standalone")) {
            list = new ArrayList();
            list.add(new String[]{"API", "compilation"});
            ((Hashtable)props).put("DCPublicParts", list);
            list = new ArrayList();
            list.add(new String[]{"API", "Portal API", "Portal API"});
            ((Hashtable)props).put("DCPublicPartEntity", list);
        } else if (dcSubType.equals("Portal Application Module")) {
            list = new ArrayList();
            list.add(new String[]{"API", "compilation", "Portal API", ""});
            list.add(new String[]{"PAR", "assembly", "PAR", ""});
            ((Hashtable)props).put("DCPublicParts", list);
            list = new ArrayList();
            list = new ArrayList();
            list.add(new String[]{"API", "Portal API", "Portal API"});
            list.add(new String[]{"PAR", "PAR", "PAR"});
            ((Hashtable)props).put("DCPublicPartEntity", list);
        }
        return props;
    }
}

