/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.dcproject;

import com.sap.portal.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.portal.developmentTools.general.wizards.dcproject.INewDCProjectPage;
import com.sap.portal.developmentTools.general.wizards.dcproject.IPortalDCStrings;
import com.sap.portal.developmentTools.general.wizards.openArchive.IOpenArchiveWizardPage;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.ISAPNPWizardPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.dcproject.AbstractNewEPProjectWizard;
import com.sap.portal.util.Files;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewEPModuleProjectWizardPage
extends WizardPage
implements ModifyListener,
IOpenArchiveWizardPage,
ISAPNPWizardPage,
INewDCProjectPage,
IPortalDCStrings {
    private Text mm_projectNameField;
    private Button mm_emptyProjectButton;
    private Button mm_parImportedProjectButton;
    private LabeledBrowsableTextField mm_importedParField;
    private Label mm_parNameLabel;
    protected Text mm_parNameText;
    protected boolean m_editableParName = true;
    protected String m_projectName = "";
    protected String m_parName = "";
    protected boolean m_pageComplete = false;

    public NewEPModuleProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Create a new DC for Portal Applications");
    }

    public NewEPModuleProjectWizardPage(String pageName, boolean editableParNameField) {
        this(pageName);
        this.m_editableParName = editableParNameField;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(1808));
        Composite projectGroup = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText("Project Name");
        projectLabel.setFont(content.getFont());
        this.mm_projectNameField = new Text(projectGroup, 2048);
        this.mm_projectNameField.setText(this.m_projectName);
        this.mm_projectNameField.setEditable(false);
        this.mm_projectNameField.setEnabled(false);
        GridData data = new GridData(768);
        this.mm_projectNameField.setLayoutData((Object)data);
        this.mm_projectNameField.setFont(content.getFont());
        this.mm_emptyProjectButton = new Button(content, 16);
        this.mm_emptyProjectButton.setText("Create an empty project");
        this.mm_emptyProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewEPModuleProjectWizardPage.this.mm_parNameLabel.setEnabled(true);
                NewEPModuleProjectWizardPage.this.mm_parNameText.setEditable(true);
                NewEPModuleProjectWizardPage.this.mm_importedParField.setEnabled(false);
                NewEPModuleProjectWizardPage.this.mm_importedParField.setEditable(false);
            }
        });
        this.mm_parNameLabel = new Label(content, 0);
        this.mm_parNameLabel.setText("archive name: ");
        this.mm_parNameText = new Text(content, 2048);
        this.mm_parNameText.setLayoutData((Object)new GridData(768));
        this.mm_parNameText.setText(this.m_parName + ".par");
        if (this.m_editableParName) {
            this.mm_parNameText.addModifyListener((ModifyListener)this);
        } else {
            this.mm_parNameText.setEnabled(false);
        }
        this.mm_parImportedProjectButton = new Button(content, 16);
        this.mm_parImportedProjectButton.setText("Import project from a Par file");
        this.mm_parImportedProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewEPModuleProjectWizardPage.this.mm_parNameLabel.setEnabled(false);
                NewEPModuleProjectWizardPage.this.mm_parNameText.setEditable(false);
                NewEPModuleProjectWizardPage.this.mm_importedParField.setEnabled(true);
                NewEPModuleProjectWizardPage.this.mm_importedParField.setEditable(true);
                NewEPModuleProjectWizardPage.this.mm_importedParField.getTextField().setEnabled(true);
            }
        });
        this.mm_importedParField = new LabeledBrowsableTextField(content, 0, "PAR file:");
        this.validate();
        this.setControl((Control)content);
    }

    public void setInitialProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    public void setInitialArchiveName(String parName) {
        while (parName.endsWith(".par")) {
            parName = parName.substring(0, parName.length() - 4);
        }
        this.m_parName = parName;
    }

    public String getParArchiveName() {
        String archiveName;
        if (this.mm_parImportedProjectButton.getSelection() && (archiveName = this.mm_importedParField.getValue()) != null && archiveName.trim().length() > 1) {
            archiveName = archiveName.substring(archiveName.lastIndexOf(File.separatorChar) + 1, archiveName.length());
            return archiveName;
        }
        return this.m_parName;
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() == this.mm_parNameText) {
            this.setErrorMessage(this.validate());
            this.getContainer().updateButtons();
        }
    }

    public String validate() {
        String parName = this.mm_parNameText.getText().trim();
        if (!Files.isValidFileName(parName) || parName.indexOf(47) != -1 || parName.indexOf(" ") != -1 || parName.length() < 4) {
            this.m_pageComplete = false;
            return "Par file name is invalid";
        }
        if (!parName.endsWith(".par")) {
            this.m_pageComplete = false;
            return "PAR file extension must be .par";
        }
        this.m_parName = parName.substring(0, parName.length() - 4);
        this.m_pageComplete = true;
        return null;
    }

    public boolean isPageComplete() {
        return this.m_pageComplete;
    }

    public boolean isImportingPar() {
        return this.mm_parImportedProjectButton.getSelection();
    }

    public String getFilePath() {
        return this.mm_importedParField.getValue();
    }

    public String getProjectRootFolderName() {
        return ((AbstractNewEPProjectWizard)this.getWizard()).getProjectLocation();
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public void setOpenParFolder(String openParFolder) {
        if (openParFolder != null && new File(openParFolder).exists()) {
            this.mm_importedParField.setInitalDirectory(openParFolder);
        }
    }

    public void setProjectRootRootFolder(String projectRootRootFolder) {
        this.mm_projectNameField.setText(projectRootRootFolder);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mm_emptyProjectButton.setSelection(true);
        this.mm_importedParField.setEditable(false);
    }

    public String getProjectRootRootFolderName() {
        return this.getProjectRootFolderName();
    }

    public void setProjectRootRootFolderName(String name) {
        this.setProjectRootRootFolder(name);
    }

    public String getDCSubType() {
        return "Portal Application Module";
    }

    public String getImportedParName() {
        return this.mm_importedParField.getValue();
    }

    public String getSdaArchiveName() {
        return null;
    }

    public String getSdaType() {
        return null;
    }
}

