/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.dcproject;

import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.dcproject.INewDCProjectPage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCPropertiesHandler;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DTRPortalUtil;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.dcproject.PortalAppProjectCreator;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class AbstractNewEPProjectWizard
extends BasicNewResourceWizard
implements IConnectedWizard {
    protected IStartCreateProjectWizard mm_startWizard;
    private IProject mm_newProject;
    private String parName;
    private static TracerI mm_tracer = TracingManager.getTracer((Class)(class$com$sap$portal$developmentTools$ideSpecific$eclipse$wizards$dcproject$AbstractNewEPProjectWizard == null ? (class$com$sap$portal$developmentTools$ideSpecific$eclipse$wizards$dcproject$AbstractNewEPProjectWizard = AbstractNewEPProjectWizard.class$("com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.dcproject.AbstractNewEPProjectWizard")) : class$com$sap$portal$developmentTools$ideSpecific$eclipse$wizards$dcproject$AbstractNewEPProjectWizard));
    static /* synthetic */ Class class$com$sap$portal$developmentTools$ideSpecific$eclipse$wizards$dcproject$AbstractNewEPProjectWizard;

    public void init(IStartCreateProjectWizard startWizard) {
        this.mm_startWizard = startWizard;
        this.mm_newProject = startWizard.getProjectHandle();
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Enterprise Portal Project DC");
    }

    public IProject getNewProject() {
        return this.mm_newProject;
    }

    public boolean performFinish() {
        if (this.mm_startWizard == null) {
            return false;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                INewDCProjectPage newEPProjectWizardPage = (INewDCProjectPage)AbstractNewEPProjectWizard.this.getPages()[0];
                AbstractNewEPProjectWizard.this.parName = newEPProjectWizardPage.getParArchiveName();
                String sdaType = null;
                Object sdaArchiveName = null;
                sdaType = newEPProjectWizardPage.getSdaType();
                if (AbstractNewEPProjectWizard.this.mm_startWizard != null) {
                    PortalAppProjectCreator projectCreator = new PortalAppProjectCreator(AbstractNewEPProjectWizard.this.mm_startWizard, newEPProjectWizardPage);
                    projectCreator.run(monitor);
                    AbstractNewEPProjectWizard.super.selectAndReveal((IResource)AbstractNewEPProjectWizard.this.mm_newProject);
                }
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void finalProject() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
                    if (!AbstractNewEPProjectWizard.this.mm_startWizard.isLocal() && AbstractNewEPProjectWizard.this.mm_startWizard.getActivity() != null) {
                        DTRPortalUtil.addDefaultResourcesToDTR(AbstractNewEPProjectWizard.this.mm_startWizard.getActivity(), AbstractNewEPProjectWizard.this.mm_newProject);
                    }
                    AbstractNewEPProjectWizard.this.switchToEPPerspective();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean completeProject(IProject newProj, Properties properties) {
        final IProject fProject = newProj;
        final Properties fProperties = properties;
        boolean retValue = true;
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    String language = null;
                    language = ((Hashtable)fProperties).containsKey("DCLanguage") ? fProperties.getProperty("DCLanguage") : "en";
                    ICommand command = fProject.getDescription().newCommand();
                    command.setBuilderName("org.eclipse.jdt.core.javabuilder");
                    try {
                        DCPropertiesHandler.setJavaCommand(fProject.getDescription(), command);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    try {
                        String[] newNatures;
                        String[] natures;
                        IProjectDescription description;
                        if (fProject.getNature("org.eclipse.jdt.core.javanature") == null) {
                            description = fProject.getDescription();
                            natures = description.getNatureIds();
                            newNatures = new String[natures.length + 1];
                            System.arraycopy(natures, 0, newNatures, 0, natures.length);
                            newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
                            description.setNatureIds(newNatures);
                            fProject.setDescription(description, null);
                        }
                        if (fProject.getNature("com.sap.ep.applicationDevelopment.portalProjectNature") == null) {
                            description = fProject.getDescription();
                            natures = description.getNatureIds();
                            newNatures = new String[natures.length + 1];
                            System.arraycopy(natures, 0, newNatures, 0, natures.length);
                            newNatures[natures.length] = "com.sap.ep.applicationDevelopment.portalProjectNature";
                            description.setNatureIds(newNatures);
                            fProject.setDescription(description, null);
                        }
                        DCPropertiesHandler.addJRELib(fProject);
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                    IJavaProject jp = JavaCore.create((IProject)fProject);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IDESettings is = IDESettings.getInstance();
        is.setParArchiveName(newProj, DCPropertiesHandler.getParArchiveNameFromDcdef(newProj));
        return retValue;
    }

    public String getProjectName() {
        return this.mm_startWizard.getProjectHandle().getName();
    }

    protected void switchToEPPerspective() {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor persp = reg.findPerspectiveWithId("com.sap.ep.connectionManager.ui.perspective");
        if (persp == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public String getProjectLocation() {
        return this.mm_startWizard.getProjectDescription().getLocation().toOSString();
    }

    protected String getDefaultParNameFromProjectName() {
        String defaultParName = "";
        String projectName = this.mm_startWizard.getName();
        defaultParName = projectName.replace('/', '.') + ".par";
        return defaultParName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

