/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.configurationWizard;

import com.sap.portal.developmentTools.general.gui.swt.TCPPortFieldEditor;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sap.portal.developmentTools.general.wizards.configurationWizard.IConfigurationWizardStringLiterals;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConfigurationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IConfigurationWizardStringLiterals {
    private StringFieldEditor serveraddressField;
    private StringFieldEditor webappnameField;
    private TCPPortFieldEditor tcpPortField;
    private StringFieldEditor invokeBrowserCommandLineField;
    private boolean status = false;
    private String statusType;
    private String statusMessage;

    public ConfigurationPage() {
        super("PDK: Configuration", 0x800000);
        this.setDescription("The Portal Development Kit plugin needs a connection to your local portal\nin order to read information from the portal and deploy your portal components.");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ep.applicationDevelopment.help-config");
        String preferenceNamePrefix = "com.sapportals.portal.prt.opentools.general.PDKInstallation.";
        String serverAddressPreferenceName = preferenceNamePrefix + "IRJ_SERVER";
        String webappRootNamePreferenceName = preferenceNamePrefix + "IRJ_WEBAPP_NAME";
        String tcpPortPreferenceName = preferenceNamePrefix + "IRJ_PORT";
        String invokeBrowserPreferenceName = preferenceNamePrefix + "browser_cmd";
        this.serveraddressField = new StringFieldEditor(serverAddressPreferenceName, "Irj server name:", this.getFieldEditorParent());
        this.serveraddressField.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.serveraddressField);
        this.webappnameField = new StringFieldEditor(webappRootNamePreferenceName, "Irj webapp root:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.webappnameField);
        this.tcpPortField = new TCPPortFieldEditor(tcpPortPreferenceName, "Irj webapp TCP port", this.getFieldEditorParent());
        this.addField((FieldEditor)this.tcpPortField);
        this.invokeBrowserCommandLineField = new StringFieldEditor(invokeBrowserPreferenceName, "Command line to launch browser", this.getFieldEditorParent());
        this.initFieldsToFormerValues();
    }

    protected void contributeButtons(Composite parent) {
        GridLayout parentsLayout = (GridLayout)parent.getLayout();
        parentsLayout.numColumns = 1;
        int heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button testButton = new Button(parent, 8);
        testButton.setFont(super.getFont());
        testButton.setText("Test Settings");
        GridData data = new GridData(256);
        data.heightHint = heightHint;
        data.widthHint = Math.max(widthHint, testButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        testButton.setLayoutData((Object)data);
        testButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ConfigurationPage.this.testSettings();
            }
        });
    }

    public boolean performOk() {
        this.status = true;
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Verifying settings", 4);
                int port = ConfigurationPage.this.tcpPortField.getIntValue();
                String servername = ConfigurationPage.this.serveraddressField.getStringValue();
                String webappName = ConfigurationPage.this.webappnameField.getStringValue();
                String browserInvokeCmd = ConfigurationPage.this.invokeBrowserCommandLineField.getStringValue();
                monitor.worked(1);
                try {
                    PDKInstallation pdkinstall = PDKInstallation.getInstance();
                    pdkinstall.setIrjPort(port);
                    pdkinstall.setIrjServerName(servername);
                    pdkinstall.setIrjWebappName(webappName);
                    IDESettings iset = IDESettings.getInstance();
                    iset.setInvokeBrowserCmd(browserInvokeCmd);
                    PortalPlugin.getDefault().savePluginPreferences();
                    monitor.worked(1);
                    monitor.subTask("Connecting to PDK");
                    pdkinstall.pingPDK();
                    monitor.worked(1);
                    pdkinstall.updateIrjWebappFileHome();
                    pdkinstall.updateInstalledServicesOnDisk();
                    pdkinstall.doSave();
                    monitor.worked(1);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    ConfigurationPage.this.status = false;
                    ConfigurationPage.this.statusType = e.getClass().getName();
                    ConfigurationPage.this.statusMessage = e.getMessage();
                }
            }
        };
        try {
            pmd.run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            this.status = false;
            this.statusType = e.getClass().getName();
            this.statusMessage = e.getMessage();
        }
        if (!this.status) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occurred while trying to adopt the new settings.\nError type: \"" + this.statusType + "\"\nError message: \"" + this.statusMessage + "\"\n\nPlease check your settings again.\n(Note: The PDK must be running to update the settings!)"));
        }
        return this.status;
    }

    protected void initialize() {
    }

    private void testSettings() {
        Cursor c = new Cursor((Device)this.getShell().getDisplay(), 1);
        this.getShell().setCursor(c);
        boolean connectionPossible = false;
        int port = this.tcpPortField.getIntValue();
        String servername = this.serveraddressField.getStringValue();
        String webappName = this.webappnameField.getStringValue();
        String urlToPDK = null;
        try {
            PDKInstallation pdkinstall = PDKInstallation.getInstance();
            pdkinstall.setIrjPort(port);
            pdkinstall.setIrjServerName(servername);
            pdkinstall.setIrjWebappName(webappName);
            urlToPDK = pdkinstall.getIrjRootURL() + "/servlet/prt/portal";
            if (pdkinstall.isServerReachable()) {
                pdkinstall.updateIrjWebappFileHome();
                pdkinstall.doSave();
                connectionPossible = true;
            } else {
                pdkinstall.reload();
                connectionPossible = false;
            }
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        if (!connectionPossible) {
            urlToPDK = "http://www.iViewStudio.com";
        }
        String openBrowserCmdLine = this.invokeBrowserCommandLineField.getStringValue();
        boolean openBrowserPossible = false;
        try {
            Process p = Runtime.getRuntime().exec(openBrowserCmdLine + " " + urlToPDK);
            openBrowserPossible = true;
            p.waitFor();
            openBrowserPossible = p.exitValue() == 0;
        }
        catch (Throwable e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        c.dispose();
        c = new Cursor((Device)this.getShell().getDisplay(), 0);
        this.getShell().setCursor(c);
        String connectionMessage = null;
        String openBrowserMessage = null;
        int messageImageType = connectionPossible && openBrowserPossible ? 2 : 4;
        connectionMessage = connectionPossible ? "Connection  to PDK OK." : "Connection to PDK could not be established.";
        openBrowserMessage = openBrowserPossible ? "Invocation of browser process with no errors." : "Had difficulties invoking the browser process.";
        String messageText = connectionMessage + "\n" + openBrowserMessage;
        MessageDialog md = new MessageDialog(this.getShell(), "Connection Test", null, messageText, messageImageType, new String[]{"OK"}, 0);
        md.open();
    }

    protected void performDefaults() {
        this.initFieldsToFormerValues();
    }

    protected void initFieldsToFormerValues() {
        try {
            PDKInstallation pdkinstall = PDKInstallation.getInstance();
            pdkinstall.reload();
            IDESettings iset = IDESettings.getInstance();
            this.invokeBrowserCommandLineField.setStringValue(iset.getInvokeBrowserCmd());
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PortalPlugin.getDefault().getPreferenceStore();
    }
}

