/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.common;

import com.sap.portal.developmentTools.general.AbstractProfile;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.gui.swt.ProfileSelectorComposite;
import com.sap.portal.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.portal.developmentTools.general.gui.swt.SpecifyClassAndPackageComposite;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class SpecifyClassAndProfilePage
extends WizardPage
implements ModifyListener {
    private String mm_infopopID;
    private SpecifyClassAndPackageComposite mm_classPackageComposite;
    private ProfileSelectorComposite mm_profSelect;
    private int mm_componentService;
    private IProject mm_project;
    private AbstractProfiles mm_profiles;
    private Set mm_forbiddenClassNames = new HashSet();

    public SpecifyClassAndProfilePage(int componentService, String title, String description, String infopopID) {
        super("New Portal Application");
        this.setTitle(title);
        this.setDescription(description);
        this.mm_infopopID = infopopID;
        this.mm_componentService = componentService;
    }

    public void setProject(IProject project) {
        this.mm_project = project;
        try {
            this.mm_forbiddenClassNames = PortalPlugin.getAllFullyQualifiedClassNamesInProject(project);
            if (this.mm_classPackageComposite != null) {
                this.mm_classPackageComposite.setForbiddenClassNames(this.mm_forbiddenClassNames);
            }
        }
        catch (JavaModelException e) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e);
        }
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.mm_profiles = profiles;
        if (this.mm_profSelect != null) {
            this.mm_profSelect.setProfiles(profiles);
        }
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappo = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappo.getContentPane();
        container.setLayout((Layout)new GridLayout());
        this.mm_classPackageComposite = new SpecifyClassAndPackageComposite(this.mm_componentService, container, 0, this.mm_project);
        this.mm_classPackageComposite.addModifyListener(this);
        this.mm_classPackageComposite.setForbiddenClassNames(this.mm_forbiddenClassNames);
        this.setControl((Control)sappo.getTopContainer());
        if (this.mm_infopopID != null) {
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)this.mm_infopopID);
        }
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(newMessage == null);
    }

    public void modifyText(ModifyEvent e) {
        String errorMessage = this.mm_classPackageComposite.validate();
        this.setErrorMessage(errorMessage);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mm_classPackageComposite.setFocus();
        }
    }

    public String getClassName() {
        return this.mm_classPackageComposite.getClassName();
    }

    public String getPackageName() {
        return this.mm_classPackageComposite.getPackageName();
    }

    public String getFullyQualifiedClassName() {
        return this.mm_classPackageComposite.getFullyQualifiedClassName();
    }

    public AbstractProfile getSelectedProfile() {
        return this.mm_profSelect.getSelectedProfile();
    }

    public String getPortalComponentType() {
        return this.mm_classPackageComposite.getPortalComponentType();
    }

    public String getPortalComponentName() {
        return this.mm_classPackageComposite.getPortalComponentName();
    }

    public String getLocationField() {
        return this.mm_classPackageComposite.getLocationField();
    }

    public String getFullyQualifiedClassNameApi() {
        return this.mm_classPackageComposite.getFullyQualifiedClassNameApi();
    }
}

