/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.common;

import com.sap.portal.developmentTools.ePSpecific.EP6;
import com.sap.portal.developmentTools.general.AbstractProfiles;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DTRPortalUtil;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.common.SpecifyClassAndProfilePage;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public abstract class OneClassMasterIViewWizard
extends Wizard
implements IPDKCustomComponentWizard {
    protected SpecifyClassAndProfilePage mm_myPage;
    protected IProject mm_project;
    protected AbstractProfiles mm_profiles;
    private String mm_title;
    private String mm_description;
    private int mm_componentService;
    protected final String mm_templateLocation;
    private String mm_infopopID;

    public OneClassMasterIViewWizard(int componentService, String title, String description, String templateLocation, String infopopID) {
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.setNeedsProgressMonitor(true);
        this.mm_title = title;
        this.mm_componentService = componentService;
        this.mm_description = description;
        this.mm_templateLocation = templateLocation;
        this.mm_infopopID = infopopID;
    }

    public void setCurrentProject(IProject project) {
        this.mm_project = project;
        if (this.mm_myPage != null) {
            this.mm_myPage.setProject(project);
        }
    }

    public IProject getProject() {
        return this.mm_project;
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.mm_profiles = profiles;
        if (this.mm_myPage != null) {
            this.mm_myPage.setProfiles(profiles);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mm_project = (IProject)selection.getFirstElement();
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mm_myPage = new SpecifyClassAndProfilePage(this.mm_componentService, this.mm_title, this.mm_description, this.mm_infopopID);
        this.mm_myPage.setProject(this.mm_project);
        this.mm_myPage.setProfiles(this.mm_profiles);
        this.addPage((IWizardPage)this.mm_myPage);
    }

    protected abstract void doProfileTasks();

    public boolean canFinish() {
        return this.mm_myPage.getClassName() != null && this.mm_myPage.getClassName() != "";
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Processing request - ", 11);
                monitor.subTask("Requesting templates");
                monitor.worked(1);
                HashMap<String, String> templateMapApi = new HashMap<String, String>();
                templateMapApi.put("package", OneClassMasterIViewWizard.this.mm_myPage.getPackageName());
                templateMapApi.put("class-name", "I" + OneClassMasterIViewWizard.this.mm_myPage.getClassName());
                monitor.worked(1);
                HashMap<String, String> templateMap = new HashMap<String, String>();
                templateMap.put("package", OneClassMasterIViewWizard.this.mm_myPage.getPackageName());
                templateMap.put("class-name", OneClassMasterIViewWizard.this.mm_myPage.getClassName());
                templateMap.put("interface-name", "I" + OneClassMasterIViewWizard.this.mm_myPage.getClassName());
                monitor.worked(1);
                String apiOrCore = OneClassMasterIViewWizard.this.mm_myPage.getLocationField();
                String componentOrService = OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentType();
                String templateLocationTestComponent = OneClassMasterIViewWizard.this.mm_templateLocation + "/testClassTemplate.xml";
                String templateLocationComponent = OneClassMasterIViewWizard.this.mm_templateLocation + "/iViewClassTemplate.xml";
                String templateLocationServiceApi = OneClassMasterIViewWizard.this.mm_templateLocation + "/ApiServiceTemplate.xml";
                String templateLocationServiceCore = OneClassMasterIViewWizard.this.mm_templateLocation + "/CoreServiceTemplate.xml";
                EP6 ep = new EP6();
                File portalapp = null;
                try {
                    portalapp = OpentoolsFactory.getIDEInstance().createFileInProject(OneClassMasterIViewWizard.this.mm_project, new String[]{"dist", "PORTAL-INF", "portalapp.xml"}, true);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                }
                monitor.worked(1);
                monitor.subTask("Creating .java file");
                monitor.worked(1);
                try {
                    if (componentOrService.equalsIgnoreCase("service")) {
                        monitor.worked(1);
                        PortalPlugin.createJavaFileFromTemplateAndOpenIt(OneClassMasterIViewWizard.this.mm_project, OneClassMasterIViewWizard.this.mm_myPage.getFullyQualifiedClassNameApi(), templateLocationServiceApi, templateMapApi, 0);
                        monitor.worked(1);
                        PortalPlugin.createJavaFileFromTemplateAndOpenIt(OneClassMasterIViewWizard.this.mm_project, OneClassMasterIViewWizard.this.mm_myPage.getFullyQualifiedClassName(), templateLocationServiceCore, templateMap, 1);
                        if (OneClassMasterIViewWizard.this.mm_myPage.getPackageName().equalsIgnoreCase("") || OneClassMasterIViewWizard.this.mm_myPage.getPackageName() == null) {
                            monitor.worked(1);
                            ep.addService(OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentName(), portalapp);
                        } else {
                            monitor.worked(1);
                            ep.addService(OneClassMasterIViewWizard.this.mm_myPage.getPackageName() + "." + OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentName(), portalapp);
                        }
                        monitor.worked(1);
                    } else {
                        if (apiOrCore.equalsIgnoreCase("core")) {
                            monitor.worked(1);
                            if (componentOrService.equalsIgnoreCase("testcomponent")) {
                                PortalPlugin.createJavaFileFromTemplateAndOpenIt(OneClassMasterIViewWizard.this.mm_project, OneClassMasterIViewWizard.this.mm_myPage.getFullyQualifiedClassName(), templateLocationTestComponent, templateMap, 1);
                            } else {
                                PortalPlugin.createJavaFileFromTemplateAndOpenIt(OneClassMasterIViewWizard.this.mm_project, OneClassMasterIViewWizard.this.mm_myPage.getFullyQualifiedClassName(), templateLocationComponent, templateMap, 1);
                            }
                        } else {
                            monitor.worked(1);
                            if (componentOrService.equalsIgnoreCase("testcomponent")) {
                                PortalPlugin.createJavaFileFromTemplateAndOpenIt(OneClassMasterIViewWizard.this.mm_project, OneClassMasterIViewWizard.this.mm_myPage.getFullyQualifiedClassName(), templateLocationTestComponent, templateMap, 0);
                            } else {
                                PortalPlugin.createJavaFileFromTemplateAndOpenIt(OneClassMasterIViewWizard.this.mm_project, OneClassMasterIViewWizard.this.mm_myPage.getFullyQualifiedClassName(), templateLocationComponent, templateMap, 0);
                            }
                        }
                        monitor.worked(1);
                        if (OneClassMasterIViewWizard.this.mm_myPage.getPackageName().equalsIgnoreCase("") || OneClassMasterIViewWizard.this.mm_myPage.getPackageName() == null) {
                            monitor.worked(1);
                            if (componentOrService.equalsIgnoreCase("testcomponent")) {
                                ep.addTestComponent(OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentName(), portalapp);
                            } else {
                                ep.addComponent(OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentName(), portalapp);
                            }
                        } else {
                            monitor.worked(1);
                            if (componentOrService.equalsIgnoreCase("testcomponent")) {
                                ep.addTestComponent(OneClassMasterIViewWizard.this.mm_myPage.getPackageName() + "." + OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentName(), portalapp);
                            } else {
                                ep.addComponent(OneClassMasterIViewWizard.this.mm_myPage.getPackageName() + "." + OneClassMasterIViewWizard.this.mm_myPage.getClassName(), OneClassMasterIViewWizard.this.mm_myPage.getPortalComponentName(), portalapp);
                            }
                        }
                        monitor.worked(1);
                    }
                    monitor.worked(1);
                }
                catch (Exception e) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                    MessageDialog.openWarning((Shell)OneClassMasterIViewWizard.this.getShell(), (String)"Warning", (String)"Couldn't create .java file or modify the portalapp.xml.");
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            IFile portalapp = this.mm_project.getFile("dist/PORTAL-INF/portalapp.xml");
            if (!(!portalapp.isReadOnly() || DTRPortalUtil.isManagerAvailable((IResource)portalapp) && DTRPortalUtil.checkoutForEdit(this.getShell(), "portalapp", portalapp))) {
                MessageBox msgBox = new MessageBox(this.getShell(), 1);
                msgBox.setText("File is read-only");
                msgBox.setMessage("portalapp.xml file is not editable");
                msgBox.open();
                return false;
            }
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        return true;
    }
}

