/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.views.providers;

import com.sap.ide.eclipse.component.provider.ui.label.FolderFileDecoratorProvider;
import com.sap.portal.developmentTools.ideSpecific.eclipse.views.core.PortalElementManager;
import com.sap.portal.developmentTools.ideSpecific.eclipse.views.providers.BasicElementImageDescriptor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.views.providers.WrappingImageDescriptor;
import com.sap.portal.util.eclipse.ImageUtil;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class PortalObjectsLabelDecorator
extends FolderFileDecoratorProvider {
    ImageRegistry imgReg = ImageUtil.getImageRegistry();
    private IProblemChangedListener myProblemChangedListener;
    private ListenerList myListeners;

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        int deco = this.getDecorateFlag(element);
        Rectangle bounds = image.getBounds();
        Image ret = new BasicElementImageDescriptor(new WrappingImageDescriptor(image), deco, new Point(bounds.width, bounds.height)).createImage();
        return ret;
    }

    private int getDecorateFlag(Object element) {
        Element selenaElement;
        IResource res;
        int ret = 0;
        if (element != null && element instanceof Element && (res = PortalElementManager.getResourceFromElement(selenaElement = (Element)element)) != null) {
            try {
                IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                ret = this.getMaxSeverity(markers);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private int getMaxSeverity(IMarker[] markers) {
        int ret = 0;
        int i = 0;
        while (i < markers.length && ret != 1) {
            ret = this.getSeverity(markers[i]);
            ++i;
        }
        return ret;
    }

    private int getSeverity(IMarker marker) {
        int ret = 0;
        int priority = marker.getAttribute("severity", 0);
        if (priority == 1) {
            ret = 2;
        } else if (priority == 2) {
            ret = 1;
        }
        return ret;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void dispose() {
        this.imgReg = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.myListeners != null) {
            this.myListeners.remove((Object)listener);
            if (this.myListeners.isEmpty() && this.myProblemChangedListener != null) {
                JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this.myProblemChangedListener);
                this.myProblemChangedListener = null;
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ListenerList();
        }
        this.myListeners.add((Object)listener);
        if (this.myProblemChangedListener == null) {
            this.myProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    PortalObjectsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            JavaPlugin.getDefault().getProblemMarkerManager().addListener(this.myProblemChangedListener);
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.myListeners != null && !this.myListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])changedResources);
            Object[] listeners = this.myListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }
}

