/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.views.core;

import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.tssap.dii.component.DCUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.util.jdt.JDTUtils;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class PortalElementManager {
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_JSP = "jsp";
    public static final String EXTENSION_JAR = "jar";

    public static boolean isJavaSourceFolder(Element elem) {
        IResource res = PortalElementManager.getResourceFromElement(elem);
        if (!(res instanceof IFolder)) {
            return false;
        }
        IProject prj = PortalElementManager.getPortalDCProject((Element)elem.getModel());
        if (prj == null) {
            return false;
        }
        IJavaProject javPrj = JavaCore.create((IProject)prj);
        if (javPrj != null && javPrj.exists()) {
            IPackageFragmentRoot pkgRoot = null;
            pkgRoot = javPrj.getPackageFragmentRoot(res);
            if (pkgRoot != null && pkgRoot.exists()) {
                return true;
            }
        }
        return false;
    }

    public static final IResource getResourceFromElement(Element element) {
        IResource ret = FileAndFolderManagement.getInstance().getResource(element);
        return ret;
    }

    public static boolean isInPortalProject(Element element) {
        IResource res = PortalElementManager.getResourceFromElement(element);
        if (res == null) {
            return false;
        }
        IProject project = res.getProject();
        return PortalElementManager.isPortalProject(project);
    }

    public static boolean isJavaFile(Element element) {
        return "FileAndFolder".equals(element.getPropertyValue("$metaclass")) && element.getUniqueName().getLocation().endsWith(".java");
    }

    public static boolean isPortalProject(Element element) {
        IProject project = PortalElementManager.getProject(element);
        return PortalElementManager.getPortalDCProject(element) != null;
    }

    public static boolean isPortalProject(IProject project) {
        try {
            return project != null && project.hasNature("com.sap.ep.applicationDevelopment.portalProjectNature");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPortalDCProject(Element element) {
        return PortalElementManager.isPortalProject(element) && PortalElementManager.isDCProject(element);
    }

    public static IProject getProject(Element element) {
        IProject project;
        String name;
        if (element instanceof Model && (name = PortalElementManager.getElementName(element)) != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)) != null && project.exists()) {
            return project;
        }
        return null;
    }

    public static final IProject getPortalDCProject(Element element) {
        IProject project;
        String name;
        if (element instanceof Model && (name = PortalElementManager.getElementName(element)) != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)) != null && project.exists()) {
            try {
                if (project != null && project.hasNature("com.sap.ide.eclipse.component.provider.dcnature") && project.hasNature("com.sap.ep.applicationDevelopment.portalProjectNature")) {
                    return project;
                }
            }
            catch (ResourceException re) {
                System.out.println("resource doesn't exist");
                SapPortalPluginsLogger.logError((Object)project, (Throwable)re);
            }
            catch (CoreException ce) {
                SapPortalPluginsLogger.logError((Object)project, (Throwable)ce);
            }
        }
        return null;
    }

    public static boolean isPortalappXMLFile(Element elem) {
        return elem.getUniqueName().getName().equalsIgnoreCase("portalapp.xml");
    }

    public static boolean isInDistFolder(Element elem) {
        if (PortalElementManager.isFolder(elem)) {
            if (elem.getUniqueName().getName().equalsIgnoreCase("dist")) {
                return true;
            }
            if (elem.getUniqueName().toString().indexOf("dist/") != -1) {
                return true;
            }
        }
        return false;
    }

    protected static final String getElementName(Element element) {
        UniqueName uniqueName;
        String ret = null;
        if (element != null && (uniqueName = element.getUniqueName()) != null) {
            ret = uniqueName.getName();
        }
        return ret;
    }

    private static IPackageFragment getPackageFragment(Element element) {
        IPackageFragment ret = null;
        IFolder folder = PortalElementManager.getFolder(element);
        IJavaElement javaElement = JavaCore.create((IFolder)folder);
        if (javaElement instanceof IPackageFragmentRoot) {
            ret = PortalElementManager.getPackageFragmentByName(PortalElementManager.getPortalDCProject(element), "");
        } else if (javaElement instanceof IPackageFragment) {
            ret = (IPackageFragment)javaElement;
        }
        return ret;
    }

    public static boolean isPackageFragment(Element element) {
        return PortalElementManager.getPackageFragment(element) != null;
    }

    public static boolean isXMLFile(Element element) {
        return PortalElementManager.isFileWithExtension(element, EXTENSION_XML);
    }

    public static boolean isJSPFile(Element element) {
        return PortalElementManager.isFileWithExtension(element, EXTENSION_JSP);
    }

    public static boolean isJARFile(Element element) {
        return PortalElementManager.isFileWithExtension(element, EXTENSION_JAR);
    }

    public static boolean isFolder(Element element) {
        boolean ret = PortalElementManager.getFolder(element) != null;
        return ret;
    }

    public static boolean isDCProject(Element element) {
        return DCUtil.isDCProject((Element)element);
    }

    private static IFolder getFolder(Element element) {
        IFolder ret = null;
        IResource obj = PortalElementManager.getResourceFromElement(element);
        if (obj != null && obj instanceof IFolder) {
            ret = (IFolder)obj;
        }
        return ret;
    }

    private static IPackageFragment getPackageFragmentByName(IProject prj, String name) {
        try {
            IJavaProject javaProj = JavaCore.create((IProject)prj);
            if (javaProj == null) {
                return null;
            }
            IPackageFragmentRoot[] roots = JDTUtils.getSrcPackageFragmentRoots((IJavaProject)javaProj);
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] fragments = roots[i].getChildren();
                int j = 0;
                while (j < fragments.length) {
                    if (fragments[j] instanceof IPackageFragment && fragments[j].getElementName().equals(name)) {
                        return (IPackageFragment)fragments[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            SapPortalPluginsLogger.logError((Object)prj, (Throwable)exp);
            return null;
        }
        return null;
    }

    private static boolean isFileWithExtension(Element element, String extension) {
        IResource res;
        if (element != null && extension != null && (res = PortalElementManager.getResourceFromElement(element)) != null && res.getFileExtension() != null) {
            return res.getFileExtension().equalsIgnoreCase(extension);
        }
        return false;
    }
}

