/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.impl;

import com.sap.portal.developmentTools.general.api.StringBasedFileFilter;
import com.sap.portal.developmentTools.general.iDE.AbstractIDE;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.ServiceJavaBuilder;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappXmlEditor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.views.PortalDCExplorer;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMarkSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class Eclipse2IDE
extends AbstractIDE {
    protected static final String TEMPLATES = "templates";
    protected static final String SAP_PROJECT = "SAP Project";
    protected static final String SRC_CORE = "src.core";
    protected static final String SRC_API = "src.api";
    protected static final String CLASSES_API = "classes.api";
    private static QualifiedName ADDED_LIBS_QNAME = new QualifiedName((class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE == null ? (class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE = Eclipse2IDE.class$("com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE")) : class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE).getName(), "addedLibraries");
    private static QualifiedName OUTPATHS_QNAME = new QualifiedName((class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE == null ? (class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE = Eclipse2IDE.class$("com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE")) : class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE).getName(), "project_outpaths");
    private static QualifiedName SRCPATHS_QNAME = new QualifiedName((class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE == null ? (class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE = Eclipse2IDE.class$("com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE")) : class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE).getName(), "project_srcpaths");
    private static final String PATHS_DELIMITER = ",";
    static /* synthetic */ Class class$com$sap$portal$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE;
    static /* synthetic */ Class class$org$eclipse$ui$part$ISetSelectionTarget;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public String getCurrentProjectFolder(Object project) {
        IProject currentProject = (IProject)project;
        if (currentProject == null) {
            return null;
        }
        return currentProject.getLocation().toFile().getAbsolutePath();
    }

    public String getCurrentProjectName() {
        return Eclipse2IDE.getCurrentProject().getName();
    }

    public Object getCurrentProjectEP6() {
        return Eclipse2IDE.getCurrentProject();
    }

    public int getIdeType() {
        return 1;
    }

    public String getProjectName(Object project) {
        return ((IProject)project).getName();
    }

    protected IFolder createFolderInProject(String[] nameSegments, IProject project) throws Exception {
        if (nameSegments == null || nameSegments.length < 1) {
            return null;
        }
        IFolder folder = null;
        int i = 0;
        while (i < nameSegments.length) {
            folder = i == 0 ? project.getFolder(nameSegments[0]) : folder.getFolder(nameSegments[i]);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            ++i;
        }
        return folder;
    }

    public File createFileInProject(Object project, String[] nameSegments, boolean visible) throws Exception {
        IProject iProject = (IProject)project;
        IFile file = null;
        if (nameSegments == null || nameSegments.length < 1) {
            return null;
        }
        if (nameSegments.length == 1) {
            file = iProject.getFile((IPath)new Path(nameSegments[0]));
        } else {
            IFolder folder = iProject.getFolder(nameSegments[0]);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            int i = 1;
            while (i < nameSegments.length - 1) {
                if (!(folder = folder.getFolder(nameSegments[i])).exists()) {
                    folder.create(true, true, null);
                }
                ++i;
            }
            file = folder.getFile(nameSegments[nameSegments.length - 1]);
        }
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[]{20}), true, null);
        }
        return new File(file.getLocation().toOSString());
    }

    public boolean deleteFileFromProject(Object project, String[] nameSegments) throws IOException {
        File now = new File(this.getCurrentProjectFolder(project));
        int i = 0;
        while (i < nameSegments.length) {
            now = new File(now, nameSegments[i]);
            ++i;
        }
        return now.delete();
    }

    public File getFileObjectFor(Object project, String[] nameSegments) throws IOException {
        File now = new File(this.getCurrentProjectFolder(project));
        int i = 0;
        while (i < nameSegments.length) {
            now = new File(now, nameSegments[i]);
            ++i;
        }
        return now;
    }

    public List getAllFilesInProject(Object project, StringBasedFileFilter fileFilter, StringBasedFileFilter recursionFilter) throws IOException {
        ArrayList retVal = new ArrayList();
        String currentProjectFolder = this.getCurrentProjectFolder(project);
        if (currentProjectFolder != null) {
            this.getAllFilesInProjectHelper(retVal, new String[0], new File(currentProjectFolder), fileFilter, recursionFilter);
        }
        return retVal;
    }

    private void getAllFilesInProjectHelper(List toAddTo, String[] folderName, File folderNow, StringBasedFileFilter fileFilter, StringBasedFileFilter recursionFilter) throws IOException {
        File[] children = folderNow.listFiles();
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            String[] nameSegsNow = new String[folderName.length + 1];
            System.arraycopy(folderName, 0, nameSegsNow, 0, folderName.length);
            nameSegsNow[nameSegsNow.length - 1] = child.getName();
            boolean isDir = child.isDirectory();
            if (fileFilter.accept(nameSegsNow, isDir)) {
                toAddTo.add(nameSegsNow);
            }
            if (isDir && recursionFilter.accept(nameSegsNow, true)) {
                this.getAllFilesInProjectHelper(toAddTo, nameSegsNow, child, fileFilter, recursionFilter);
            }
            ++i;
        }
    }

    protected void defineFullProjectClasspath(Object project, List jarFiles) throws Exception {
        IProject currentProject = (IProject)project;
        this.defineFullProjectClasspath(currentProject, jarFiles);
    }

    private void defineFullProjectClasspath(IProject currentProject, List jarFiles) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)currentProject);
        ArrayList<String> libsAddedByOurselfBefore = new ArrayList<String>();
        String alreadyAddedLibsPropertyString = currentProject.getPersistentProperty(ADDED_LIBS_QNAME);
        if (alreadyAddedLibsPropertyString != null) {
            StringTokenizer st = new StringTokenizer(alreadyAddedLibsPropertyString, ";");
            while (st.hasMoreTokens()) {
                String libPathNow = st.nextToken();
                libsAddedByOurselfBefore.add(libPathNow);
            }
        }
        ArrayList<IClasspathEntry> allClasspathEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] formerClassPathEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < formerClassPathEntries.length) {
            IClasspathEntry formerClassPathEntry = formerClassPathEntries[i];
            if (!libsAddedByOurselfBefore.contains(formerClassPathEntry.getPath().toString())) {
                allClasspathEntries.add(formerClassPathEntry);
            }
            ++i;
        }
        StringBuffer newLibsAddedByOurselfBeforePropertyString = new StringBuffer();
        Iterator iterator = jarFiles.iterator();
        if (iterator.hasNext()) {
            this.doFullClassPathSettingHelper((String)iterator.next(), newLibsAddedByOurselfBeforePropertyString, allClasspathEntries);
        }
        while (iterator.hasNext()) {
            newLibsAddedByOurselfBeforePropertyString.append(';');
            String fileName = (String)iterator.next();
            this.doFullClassPathSettingHelper(fileName, newLibsAddedByOurselfBeforePropertyString, allClasspathEntries);
        }
        IClasspathEntry[] rawPath = allClasspathEntries.toArray(new IClasspathEntry[allClasspathEntries.size()]);
        javaProject.setRawClasspath(rawPath, null);
        currentProject.setPersistentProperty(ADDED_LIBS_QNAME, newLibsAddedByOurselfBeforePropertyString.toString());
    }

    private void doFullClassPathSettingHelper(String fileName, StringBuffer newLibsAddedByOurselfBeforePropertyString, ArrayList allClasspathEntries) {
        File file = new File(fileName);
        Path path = new Path(file.getAbsolutePath());
        newLibsAddedByOurselfBeforePropertyString.append(path.toString());
        IClasspathEntry classpathEntry = JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)false);
        allClasspathEntries.add(classpathEntry);
    }

    public void addLibrariesReferences(Object project, String[] paths) throws JavaModelException {
        int j;
        IProject iProject = (IProject)project;
        IJavaProject javaProject = JavaCore.create((IProject)iProject);
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < paths.length) {
            Path eclipsePath = new Path(paths[i]);
            boolean alreadyExists = false;
            j = 0;
            while (j < oldEntries.length) {
                if (oldEntries[j].getPath().toOSString().equalsIgnoreCase(eclipsePath.toOSString())) {
                    alreadyExists = true;
                }
                ++j;
            }
            if (!alreadyExists) {
                IClasspathEntry newClassPathEntry = JavaCore.newVariableEntry((IPath)eclipsePath, null, null);
                newEntries.add(newClassPathEntry);
            }
            ++i;
        }
        IClasspathEntry[] finalEntries = new IClasspathEntry[oldEntries.length + newEntries.size()];
        i = 0;
        while (i < oldEntries.length) {
            finalEntries[i] = oldEntries[i];
            ++i;
        }
        j = 0;
        while (j < newEntries.size()) {
            finalEntries[i + j] = (IClasspathEntry)newEntries.get(j);
            ++j;
        }
        javaProject.setRawClasspath(finalEntries, null);
    }

    public void addLibraryReference(Object project, String path) throws JavaModelException {
        IProject iProject = (IProject)project;
        IJavaProject javaProject = JavaCore.create((IProject)iProject);
        Path eclipsePath = new Path(path);
        boolean check = true;
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].getPath().toOSString().equalsIgnoreCase(eclipsePath.toOSString())) {
                check = false;
            }
            ++i;
        }
        if (check) {
            IClasspathEntry newClassPathEntry;
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            int i2 = 0;
            while (i2 < oldEntries.length) {
                newEntries[i2] = oldEntries[i2];
                ++i2;
            }
            newEntries[newEntries.length - 1] = newClassPathEntry = JavaCore.newVariableEntry((IPath)eclipsePath, null, null);
            javaProject.setRawClasspath(newEntries, null);
        }
    }

    public void openFileInEditor(Object project, String[] fileNameSegments) throws Exception {
        IProject iProject = (IProject)project;
        String projectRelativeFileName = this.fileNameSegsToRelativeName(fileNameSegments);
        IFile theIFile = iProject.getFile((IPath)new Path(projectRelativeFileName));
        PortalPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(theIFile);
    }

    public boolean rebuildCurrentProject(Object project, int[] srcPaths, int targetOutPath) throws Exception {
        IProject iProject = (IProject)project;
        iProject.build(6, null);
        iProject.refreshLocal(2, null);
        IMarker[] markers = iProject.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < markers.length) {
            if ((Integer)markers[i].getAttribute("severity") == 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getOutPathCount(Object project) throws Exception {
        String storedOutpaths = ((IProject)project).getPersistentProperty(OUTPATHS_QNAME);
        if (storedOutpaths != null) {
            return new StringTokenizer(storedOutpaths, PATHS_DELIMITER).countTokens();
        }
        return 0;
    }

    public File getOutPath(Object project, int outPathIndex) throws Exception {
        if (AbstractIDE.mm_tests) {
            IProject iTestProject = (IProject)project;
            File projectFile = iTestProject.getLocation().toFile();
            return new File(projectFile, CLASSES_API);
        }
        IProject iProject = (IProject)project;
        IJavaProject javaProject = JavaCore.create((IProject)iProject);
        IPath projectPath = iProject.getLocation();
        IPath outPath = javaProject.getOutputLocation();
        String outLocation = projectPath.toOSString();
        String outPathRelative = outPath.toOSString();
        outPathRelative = outPathRelative.substring(outPathRelative.indexOf(File.separator) + 1);
        outPathRelative = outPathRelative.substring(outPathRelative.indexOf(File.separator));
        return new File(outLocation + outPathRelative);
    }

    public int getSourcePathCount(Object project) throws Exception {
        if (AbstractIDE.mm_tests) {
            return 2;
        }
        IJavaProject jProject = Eclipse2IDE.getCurrentJavaProject(project);
        if (jProject == null) {
            throw new Exception("Current project (" + project + ") is not a Java Project");
        }
        IClasspathEntry[] entries = jProject.getRawClasspath();
        int count = 0;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public File getSrcPath(Object project, int srcPathIndex) throws Exception {
        if (AbstractIDE.mm_tests) {
            IProject iTestProject = (IProject)project;
            File projectFile = iTestProject.getLocation().toFile();
            if (srcPathIndex == 0) {
                return new File(projectFile, SRC_API);
            }
            return new File(projectFile, SRC_CORE);
        }
        IJavaProject jProject = Eclipse2IDE.getCurrentJavaProject(project);
        if (jProject == null) {
            throw new Exception("Current project (" + project + ") is not a Java Project");
        }
        IClasspathEntry[] entries = jProject.getRawClasspath();
        IClasspathEntry entry = null;
        int i = 0;
        while (i < entries.length && srcPathIndex >= 0) {
            entry = entries[i];
            if (entry.getEntryKind() == 3) {
                --srcPathIndex;
            }
            ++i;
        }
        if (entry != null) {
            String[] segs = entry.getPath().segments();
            String[] projRelSegs = new String[segs.length - 1];
            System.arraycopy(segs, 1, projRelSegs, 0, projRelSegs.length);
            return this.getFileObjectFor(project, projRelSegs);
        }
        return null;
    }

    public void updateProjectFromFilesSystem(Object project, StringBasedFileFilter exclusionFilter) throws Exception {
        IProject iProject = (IProject)project;
        if (iProject != null) {
            iProject.refreshLocal(2, null);
        }
    }

    public File getUserDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public File createJavaSourceFileInCurrentProject(Object project, String fqClassName, int sourcePathIndex) throws Exception {
        File sourcePath = this.getSrcPath(project, sourcePathIndex);
        String fileNameRelativeToSourcePath = fqClassName.replace('.', File.separatorChar) + ".java";
        File javaFile = new File(sourcePath, fileNameRelativeToSourcePath);
        this.createFileInProject(project, this.getSegmentsForFile(project, javaFile), false);
        JavaCore.create((IFile)((IProject)project).getFile(javaFile.getAbsolutePath()));
        return javaFile;
    }

    private int addSrcPathInProject(String[] srcPathFolderNameSegments, IJavaProject jProject) throws Exception {
        IClasspathEntry sourceEntry;
        if (jProject == null || srcPathFolderNameSegments == null || srcPathFolderNameSegments.length == 0) {
            throw new Exception("Parameters can't be null or empty!");
        }
        IFolder folder = null;
        folder = this.createFolderInProject(srcPathFolderNameSegments, jProject.getProject());
        IClasspathEntry[] oldEntries = jProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        int i = 0;
        while (i < oldEntries.length) {
            newEntries[i] = oldEntries[i];
            ++i;
        }
        newEntries[newEntries.length - 1] = sourceEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
        jProject.setRawClasspath(newEntries, null);
        return newEntries.length;
    }

    public int addSrcPathInProject(Object project, String[] srcPathFolderNameSegments) throws Exception {
        return this.addSrcPathInProject(srcPathFolderNameSegments, Eclipse2IDE.getCurrentJavaProject(project));
    }

    protected int addOutPathInProject(String[] outPathFolderNameSegments, IJavaProject jProject) throws Exception {
        if (jProject == null || outPathFolderNameSegments == null || outPathFolderNameSegments.length == 0) {
            throw new Exception("Parameters can't be null or empty!");
        }
        String storedOutpaths = jProject.getProject().getPersistentProperty(OUTPATHS_QNAME);
        if (!AbstractIDE.mm_tests) {
            this.createFolderInProject(outPathFolderNameSegments, jProject.getProject());
        }
        if (storedOutpaths == null || storedOutpaths.equals("")) {
            storedOutpaths = this.concatFolderSegments(outPathFolderNameSegments);
            if (!AbstractIDE.mm_tests) {
                IPath newPath = jProject.getProject().getFolder(this.concatFolderSegments(outPathFolderNameSegments)).getFullPath();
                jProject.setOutputLocation(newPath, null);
            }
        } else {
            storedOutpaths = storedOutpaths + PATHS_DELIMITER + this.concatFolderSegments(outPathFolderNameSegments);
        }
        if (!AbstractIDE.mm_tests) {
            jProject.getProject().setPersistentProperty(OUTPATHS_QNAME, storedOutpaths);
        }
        StringTokenizer t = new StringTokenizer(storedOutpaths, PATHS_DELIMITER);
        return t.countTokens();
    }

    public int addOutPathInProject(Object project, String[] outPathFolderNameSegments) throws Exception {
        return this.addOutPathInProject(outPathFolderNameSegments, Eclipse2IDE.getCurrentJavaProject(project));
    }

    private String fileNameSegsToRelativeName(String[] segments) {
        StringBuffer sb = new StringBuffer();
        sb.append(segments[0]);
        int i = 1;
        while (i < segments.length) {
            sb.append('/');
            sb.append(segments[i]);
            ++i;
        }
        return sb.toString();
    }

    private String concatFolderSegments(String[] segments, int count) {
        StringBuffer result = new StringBuffer();
        int min = Math.min(segments.length, count);
        int i = 0;
        while (i < min) {
            if (i == 0) {
                result.append(segments[0]);
            } else {
                result.append("/").append(segments[i]);
            }
            ++i;
        }
        return result.toString();
    }

    protected String concatFolderSegments(String[] segments) {
        return this.concatFolderSegments(segments, segments.length);
    }

    public void addServiceNatureToProject(IProject project) {
    }

    public Object prepareNewProject(File projectRootFolder, String[] initialSrcPathFolderNameSegments, String[] initialOutPathFolderNameSegments) throws Exception {
        return this.prepareNewProject(projectRootFolder, initialSrcPathFolderNameSegments, initialOutPathFolderNameSegments, false, null);
    }

    public Object prepareNewProject(File projectRootFolder, String[] initialSrcPathFolderNameSegments, String[] initialOutPathFolderNameSegments, String projectName) throws Exception {
        return this.prepareNewProject(projectRootFolder, initialSrcPathFolderNameSegments, initialOutPathFolderNameSegments, false, projectName);
    }

    public Object prepareNewProject(File projectRootFolder, String[] initialSrcPathFolderNameSegments, String[] initialOutPathFolderNameSegments, boolean isServiceProject) throws Exception {
        return this.prepareNewProject(projectRootFolder, initialSrcPathFolderNameSegments, initialOutPathFolderNameSegments, false, null);
    }

    public Object prepareNewProject(File projectRootFolder, String[] initialSrcPathFolderNameSegments, String[] initialOutPathFolderNameSegments, boolean isServiceProject, String projectName) throws Exception {
        String[] nature;
        File rootRootFolder;
        Path projectLocation = new Path(projectRootFolder.getAbsolutePath());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File defaultWorkspaceRootRootFolder = new File(workspace.getRoot().getLocation().toString());
        if (defaultWorkspaceRootRootFolder.equals(rootRootFolder = projectRootFolder.getParentFile())) {
            projectLocation = null;
        }
        IProject project = null;
        project = projectName != null ? workspace.getRoot().getProject(projectName) : workspace.getRoot().getProject(projectRootFolder.getName());
        IProjectDescription desc = workspace.newProjectDescription(SAP_PROJECT);
        desc.setLocation((IPath)projectLocation);
        if (isServiceProject) {
            nature = new String[]{"org.eclipse.jdt.core.javanature", PortalPlugin.getPortalNatureID()};
            desc.setNatureIds(nature);
        } else {
            nature = new String[]{"org.eclipse.jdt.core.javanature", PortalPlugin.getPortalNatureID(), PortalPlugin.getServiceNatureID()};
            desc.setNatureIds(nature);
        }
        if (!project.exists()) {
            project.create(desc, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        String name = project.getName();
        String fullpath = project.getFullPath().toOSString();
        String location = project.getLocation().toOSString();
        this.createFolderInProject(initialSrcPathFolderNameSegments, project);
        this.createFolderInProject(initialOutPathFolderNameSegments, project);
        IJavaProject jProject = JavaCore.create((IProject)project);
        fullpath = jProject.getProject().getFullPath().toOSString();
        location = jProject.getProject().getLocation().toOSString();
        this.addOutPathInProject(initialOutPathFolderNameSegments, jProject);
        IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)jProject.getPath().append(this.concatFolderSegments(initialSrcPathFolderNameSegments)));
        IClasspathEntry jreLibEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
        IClasspathEntry[] entries = new IClasspathEntry[]{sourceEntry, jreLibEntry};
        jProject.setRawClasspath(entries, null);
        IProjectDescription d = jProject.getProject().getDescription();
        ICommand builder = d.newCommand();
        builder.setBuilderName("org.eclipse.jdt.core.javabuilder");
        ICommand[] buildSpec = new ICommand[]{builder};
        d.setBuildSpec(buildSpec);
        jProject.getProject().setDescription(d, null);
        Eclipse2IDE.selectAndReveal((IResource)jProject.getProject(), PortalPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
        return project;
    }

    public List getAllNonAbstractClassesDerivedFromInCurrentProject(Object project, String fullyQualifiedName) {
        ArrayList<String> retVal = new ArrayList<String>();
        IJavaProject iProject = Eclipse2IDE.getCurrentJavaProject(project);
        try {
            IType type = iProject.findType(fullyQualifiedName);
            IRegion region = JavaCore.newRegion();
            region.add((IJavaElement)type);
            IClasspathEntry[] classpath = iProject.getResolvedClasspath(true);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry iClasspathEntry = classpath[i];
                if (iClasspathEntry.getEntryKind() == 3) {
                    IPackageFragmentRoot[] packageFragmentRoots = iProject.findPackageFragmentRoots(iClasspathEntry);
                    int j = 0;
                    while (j < packageFragmentRoots.length) {
                        region.add((IJavaElement)packageFragmentRoots[j]);
                        ++j;
                    }
                }
                ++i;
            }
            ITypeHierarchy hierarchy = iProject.newTypeHierarchy(region, null);
            IType[] classes = hierarchy.getAllSubtypes(type);
            int i2 = 0;
            while (i2 < classes.length) {
                boolean isProtected;
                IType aClass = classes[i2];
                int flags = aClass.getFlags();
                boolean isAbstract = (flags & 0x400) == 1024;
                boolean bl = isProtected = (flags & 4) == 4;
                if (!isAbstract && !isProtected) {
                    retVal.add(aClass.getFullyQualifiedName());
                }
                ++i2;
            }
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
        return retVal;
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) throws Exception {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        if (resource instanceof IProject) {
            IProject ppp = (IProject)resource;
            IResource[] members = ppp.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFolder) {
                    resource = members[i];
                    break;
                }
                ++i;
            }
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        ArrayList<Object> partReferences = new ArrayList<Object>();
        partReferences.addAll(Arrays.asList(page.getViewReferences()));
        partReferences.addAll(Arrays.asList(page.getEditorReferences()));
        Iterator iterator = partReferences.iterator();
        while (iterator.hasNext()) {
            IWorkbenchPartReference reference = (IWorkbenchPartReference)iterator.next();
            IWorkbenchPart part = reference.getPart(false);
            if (part == null) continue;
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(class$org$eclipse$ui$part$ISetSelectionTarget == null ? Eclipse2IDE.class$("org.eclipse.ui.part.ISetSelectionTarget") : class$org$eclipse$ui$part$ISetSelectionTarget);
            if (target == null) continue;
            ISetSelectionTarget finalTarget = target;
            finalTarget.selectReveal((ISelection)selection);
        }
    }

    public static IJavaProject getCurrentJavaProject(Object project) {
        return JavaCore.create((IProject)((IProject)project));
    }

    public static IProject getCurrentProject() {
        IStructuredSelection selection;
        IWorkbenchPart activePart = PortalPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof ResourceNavigator) {
            try {
                ResourceNavigator resourceNavigator = (ResourceNavigator)activePart;
                selection = (IStructuredSelection)resourceNavigator.getSite().getSelectionProvider().getSelection();
                IResource selectedResource = (IResource)selection.getFirstElement();
                if (selectedResource != null) {
                    return selectedResource.getProject();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (activePart instanceof PackageExplorerPart) {
            try {
                PackageExplorerPart packageExplorer = (PackageExplorerPart)activePart;
                selection = (IStructuredSelection)packageExplorer.getSite().getSelectionProvider().getSelection();
                if (selection.getFirstElement() instanceof IProject) {
                    return (IProject)selection.getFirstElement();
                }
                if (selection.getFirstElement() instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)selection.getFirstElement();
                    return (IProject)javaElement.getJavaProject().getAdapter(class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = Eclipse2IDE.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (activePart instanceof PortalDCExplorer) {
            PortalDCExplorer portalDCExplorer = (PortalDCExplorer)activePart;
            return portalDCExplorer.getSelectedProject();
        }
        if (activePart instanceof CompilationUnitEditor) {
            try {
                CompilationUnitEditor javaEditor = (CompilationUnitEditor)activePart;
                return ((IFileEditorInput)javaEditor.getEditorInput()).getFile().getProject();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (activePart instanceof PortalappXmlEditor) {
            try {
                PortalappXmlEditor portalappEditor = (PortalappXmlEditor)activePart;
                return portalappEditor.getProject();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ISelection simple = PortalPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        try {
            IAdaptable adaptable;
            IResource res;
            Object o;
            if (simple instanceof IStructuredSelection && (o = ((IStructuredSelection)simple).getFirstElement()) != null && o instanceof IAdaptable && (res = (IResource)(adaptable = (IAdaptable)o).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = Eclipse2IDE.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null) {
                return res.getProject();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            IAdaptable adaptable;
            IResource res;
            IDocument doc;
            if (simple instanceof IMarkSelection && (doc = (selection = (IMarkSelection)simple).getDocument()) instanceof IAdaptable && (res = (IResource)(adaptable = (IAdaptable)doc).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = Eclipse2IDE.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null) {
                return res.getProject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void deactivateApiCoreValidatorForProject(Object project) throws Exception {
        if (project == null) {
            return;
        }
        IProject iProject = (IProject)project;
        iProject.setPersistentProperty(ServiceJavaBuilder.VALIDATION_ACTIVE_FQ_NAME, "false");
    }

    public static void activateApiCoreValidatorForProject(Object project) throws Exception {
        if (project == null) {
            return;
        }
        IProject iProject = (IProject)project;
        iProject.setPersistentProperty(ServiceJavaBuilder.VALIDATION_ACTIVE_FQ_NAME, "true");
    }

    public void registerServiceApiCoreSeparationValidator(Object project) throws Exception {
        IProject proj = (IProject)project;
        IProjectDescription d = proj.getDescription();
        ICommand[] oldBuildSpec = d.getBuildSpec();
        ICommand[] newBuildSpec = new ICommand[oldBuildSpec.length + 1];
        int i = 0;
        while (i < oldBuildSpec.length) {
            ICommand iCommand;
            newBuildSpec[i] = iCommand = oldBuildSpec[i];
            ++i;
        }
        ICommand validator = d.newCommand();
        validator.setBuilderName("com.sap.ep.applicationDevelopment.applicationBuilder");
        newBuildSpec[newBuildSpec.length - 1] = validator;
        d.setBuildSpec(newBuildSpec);
        proj.setDescription(d, null);
        Eclipse2IDE.activateApiCoreValidatorForProject(proj);
    }

    public String getTemplateFolderPath() {
        String pluginPath = PortalPlugin.getIPluginDescriptor().find((IPath)new Path("")).getFile();
        pluginPath = pluginPath + File.separator + TEMPLATES;
        return pluginPath;
    }

    public void addJarReference(Object project, String path) throws JavaModelException {
        IProject iProject = (IProject)project;
        IJavaProject javaProject = JavaCore.create((IProject)iProject);
        Path eclipsePath = new Path(path);
        boolean check = true;
        if (!new File(path).exists()) {
            SapPortalPluginsLogger.logError((Object)this, (String)("Unable to add " + path + " Jar library classpath, Jar file not found."));
            return;
        }
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].getPath().toOSString().equalsIgnoreCase(eclipsePath.toOSString())) {
                check = false;
            }
            ++i;
        }
        if (check) {
            IClasspathEntry newClassPathEntry;
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            int i2 = 0;
            while (i2 < oldEntries.length) {
                newEntries[i2] = oldEntries[i2];
                ++i2;
            }
            newEntries[newEntries.length - 1] = newClassPathEntry = JavaCore.newLibraryEntry((IPath)eclipsePath, null, null);
            javaProject.setRawClasspath(newEntries, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

