/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.forms;

import com.sap.portal.developmentTools.general.editors.EditorsStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappEditorsStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappXmlEditor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.UtilPortalappEditor;
import java.util.ArrayList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalappOutlineView
extends ContentOutlinePage
implements EditorsStrings,
PortalappEditorsStrings {
    private PortalappXmlEditor mm_editor;
    private TreeViewer mm_outlineViewer;
    private Composite mm_parent;

    public PortalappOutlineView(PortalappXmlEditor mm_editor) {
        this.mm_editor = mm_editor;
    }

    public void createControl(Composite mm_parent) {
        super.createControl(mm_parent);
        this.mm_outlineViewer = this.getTreeViewer();
        this.loadForm();
        this.mm_parent = mm_parent;
    }

    private void loadForm() {
        this.mm_outlineViewer.setContentProvider((IContentProvider)new PortalappContentProvider());
        this.mm_outlineViewer.setLabelProvider((IBaseLabelProvider)new PortalappLabelProvider());
        if (this.mm_editor.getDocument() != null) {
            this.mm_outlineViewer.setInput((Object)this.mm_editor.getDocument().getDocumentElement().getParentNode());
        }
        this.mm_outlineViewer.expandAll();
        this.mm_outlineViewer.addSelectionChangedListener((ISelectionChangedListener)new OutlineSelectionListener());
        MenuManager menuMgr = new MenuManager("#ViewLabPopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                UtilPortalappEditor.fillContextMenu(menuManager, PortalappOutlineView.this.mm_outlineViewer, PortalappOutlineView.this.mm_parent.getShell(), PortalappOutlineView.this.mm_editor);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.mm_outlineViewer.getControl());
        this.mm_outlineViewer.getControl().setMenu(menu);
    }

    public void refreshView(boolean error) {
        if (!error) {
            this.mm_outlineViewer.setInput((Object)this.mm_editor.getDocument().getDocumentElement().getParentNode());
        } else {
            this.mm_outlineViewer.setInput(null);
        }
        this.mm_outlineViewer.refresh();
        this.mm_outlineViewer.expandAll();
    }

    public void refreshNode(Element element) {
        this.mm_outlineViewer.refresh((Object)element);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        super.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return super.getSelection();
    }

    class OutlineSelectionListener
    implements ISelectionChangedListener {
        OutlineSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent ev) {
            IStructuredSelection ss = (IStructuredSelection)PortalappOutlineView.this.mm_outlineViewer.getSelection();
            PortalappOutlineView.super.fireSelectionChanged(ev.getSelection());
            if (ss.getFirstElement() instanceof Element) {
                Element selectedNode = (Element)ss.getFirstElement();
                UtilPortalappEditor.DisplayShortcut(PortalappOutlineView.this.mm_editor, selectedNode);
            }
        }
    }

    class PortalappLabelProvider
    extends LabelProvider {
        PortalappLabelProvider() {
        }

        public String getText(Object element) {
            Element node = (Element)element;
            String nameNode = node.getNodeName();
            if (nameNode.equals("service") || nameNode.equals("component")) {
                nameNode = node.getAttribute("name");
                if (node.getAttributes().getNamedItem("alias") != null) {
                    nameNode = nameNode + " (alias " + node.getAttribute("alias") + ")";
                }
            } else if (nameNode.equals("application")) {
                nameNode = "Overview (" + PortalappOutlineView.this.mm_editor.getInputIFile().getProject().getName() + ")";
            } else if (nameNode.equals("application-config")) {
                nameNode = "application";
            } else {
                NamedNodeMap attributes = node.getAttributes();
                if (attributes.getLength() > 0) {
                    nameNode = nameNode + " (";
                    int i = 0;
                    while (i < attributes.getLength()) {
                        if (i != 0) {
                            nameNode = nameNode + "; ";
                        }
                        nameNode = nameNode + attributes.item(i).getNodeName() + ": " + attributes.item(i).getNodeValue();
                        ++i;
                    }
                    nameNode = nameNode + " )";
                }
            }
            return nameNode;
        }

        public Image getImage(Object element) {
            Element elem = (Element)element;
            Image image = PortalappXmlEditor.getImage(elem.getNodeName());
            return image;
        }
    }

    class PortalappContentProvider
    implements ITreeContentProvider,
    EditorsStrings,
    PortalappEditorsStrings {
        private TreeViewer viewer;

        public void propertyChange(PropertyChangeEvent evt) {
            this.viewer.refresh();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (TreeViewer)viewer;
        }

        public Object[] getChildren(Object parentElement) {
            Node parentNode = (Node)parentElement;
            if (parentNode.hasChildNodes()) {
                NodeList nodeList = parentNode.getChildNodes();
                ArrayList<Element> children = new ArrayList<Element>();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 1) {
                        String nodeName = node.getNodeName();
                        if (nodeName.equals("property") || node.getParentNode().getNodeName().equals("service") || node.getParentNode().getNodeName().equals("component") || node.getParentNode().getNodeName().equals("application-config")) break;
                        children.add((Element)node);
                    }
                    ++i;
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object parentElement) {
            Element parentNode = (Element)parentElement;
            if (parentNode.hasChildNodes()) {
                NodeList nodeList = parentNode.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    String nodeName;
                    Node node = nodeList.item(i);
                    if (!(node.getNodeType() != 1 || (nodeName = node.getNodeName()).equals("property") || node.getParentNode().getNodeName().equals("service") || node.getParentNode().getNodeName().equals("component") || node.getParentNode().getNodeName().equals("application-config"))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }
    }
}

