/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.forms;

import com.sap.portal.developmentTools.general.editors.EditorsStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.OverviewEditorPart;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.UtilPortalappEditor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.WebServicesProcessEP6;
import com.sap.portal.developmentTools.ideSpecific.eclipse.xml.PortalappUtils;
import com.sap.portal.util.eclipse.ImageUtil;
import java.util.AbstractList;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.AbstractForm;
import org.eclipse.update.ui.forms.internal.AbstractSectionForm;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverviewForm
extends ScrollableSectionForm
implements EditorsStrings {
    private Source mm_source = null;
    private Components mm_components = null;
    private Services mm_services = null;
    private Composite mm_parent = null;
    private OverviewEditorPart mm_editor = null;
    private boolean mm_docHasChanged = true;

    public OverviewForm() {
        this.setVerticalFit(true);
        this.setScrollable(true);
    }

    protected void createFormClient(Composite parent) {
        this.mm_parent = parent;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.mm_source = new Source();
        Control control = this.mm_source.createControl(parent, this.getFactory());
        GridData gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
        this.mm_components = new Components();
        control = this.mm_components.createControl(parent, this.getFactory());
        gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
        this.mm_services = new Services();
        control = this.mm_services.createControl(parent, this.getFactory());
        gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
    }

    public void loadForm(OverviewEditorPart editor) {
        this.mm_editor = editor;
        String applicationName = " (" + editor.getEditor().getProject().getName() + ")";
        this.setHeadingText("Portalapp: Overview" + applicationName);
        this.updateForm();
    }

    public void updateForm() {
        if (this.mm_docHasChanged) {
            this.mm_source.loadForm();
            this.mm_components.loadForm();
            this.mm_services.loadForm();
            this.mm_parent.layout();
            this.mm_docHasChanged = false;
            super.update();
        }
    }

    public OverviewEditorPart getEditorPart() {
        return this.mm_editor;
    }

    public void initialize(Object modelObject) {
        super.initialize(modelObject);
        this.setHeadingText("Portalapp: Overview");
        ((Composite)this.getControl()).layout(true);
    }

    public void update() {
        if (((AbstractSectionForm)this).sections != null) {
            Iterator iter = ((AbstractList)((AbstractSectionForm)this).sections).iterator();
            while (iter.hasNext()) {
                FormSection section = (FormSection)iter.next();
                section.update();
            }
        }
    }

    public void updateComponentSection() {
        this.mm_components.loadForm();
    }

    public void updateServiceSection() {
        this.mm_services.loadForm();
    }

    public void updateSourceSection() {
        this.mm_source.loadForm();
    }

    public void fireDocHasChanged() {
        this.mm_docHasChanged = true;
    }

    class Services
    extends FormSection
    implements IHyperlinkListener {
        private Composite mm_sandwich = null;
        private Composite mm_container = null;
        private Label mm_forButton = null;
        private Button mm_moreButton = null;

        public Services() {
            this.setHeaderText("Services");
            this.setDescription("");
            this.setCollapsable(true);
            OverviewForm.this.setScrollable(true);
        }

        public Composite createClient(Composite parent, FormWidgetFactory factory) {
            Composite container = factory.createComposite(parent);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 7;
            layout.numColumns = 3;
            container.setLayout((Layout)layout);
            this.mm_container = container;
            return container;
        }

        protected void handleMore() {
            UtilPortalappEditor.displayServicesShortcut(OverviewForm.this.mm_editor.getEditor());
        }

        public void loadForm() {
            NodeList servicesNodeList = OverviewForm.this.mm_editor.getEditor().getDocument().getElementsByTagName("service");
            String services = "No services";
            if (this.mm_sandwich != null && !this.mm_sandwich.isDisposed()) {
                this.mm_sandwich.dispose();
                this.mm_sandwich = null;
            }
            if (this.mm_moreButton != null && !this.mm_moreButton.isDisposed() && this.mm_forButton != null && !this.mm_forButton.isDisposed()) {
                this.mm_forButton.dispose();
                this.mm_moreButton.dispose();
                this.mm_forButton = null;
                this.mm_moreButton = null;
            }
            this.mm_sandwich = ((AbstractForm)OverviewForm.this).factory.createComposite(this.mm_container);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            this.mm_sandwich.setLayout((Layout)layout);
            if (servicesNodeList == null || servicesNodeList.getLength() == 0) {
                Label noComponentLabel = ((AbstractForm)OverviewForm.this).factory.createLabel(this.mm_sandwich, services);
                noComponentLabel.setLayoutData((Object)new GridData(32));
            } else {
                int i = 0;
                while (i < servicesNodeList.getLength()) {
                    Element service = (Element)servicesNodeList.item(i);
                    if (i == 0) {
                        services = "";
                    }
                    String node = service.getAttribute("name");
                    Label labelImage = ((AbstractForm)OverviewForm.this).factory.createLabel(this.mm_sandwich, "");
                    labelImage.setImage(ImageUtil.getImageRegistry().get("serviceEditor.gif"));
                    SelectableFormLabel selectableLabel = ((AbstractForm)OverviewForm.this).factory.createSelectableLabel(this.mm_sandwich, node);
                    ((AbstractForm)OverviewForm.this).factory.turnIntoHyperlink((Control)selectableLabel, (IHyperlinkListener)this);
                    selectableLabel.setData((Object)service);
                    selectableLabel.setLayoutData((Object)new GridData(32));
                    NodeList configProfile = service.getChildNodes();
                    int j = 0;
                    while (j < configProfile.getLength()) {
                        Node confProf = configProfile.item(j);
                        services = services + PortalappUtils.getNodesResults(confProf.getChildNodes(), true);
                        ++j;
                    }
                    ++i;
                }
            }
            this.mm_forButton = ((AbstractForm)OverviewForm.this).factory.createLabel(this.mm_container, "");
            this.mm_forButton.setLayoutData((Object)new GridData(512));
            this.mm_moreButton = ((AbstractForm)OverviewForm.this).factory.createButton(this.mm_container, "More...", 0);
            this.mm_moreButton.setLayoutData((Object)new GridData(3));
            this.mm_moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ Services this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.handleMore();
                }
            });
            this.mm_container.layout();
        }

        public void update() {
        }

        public void linkActivated(Control arg0) {
            Object data = arg0.getData();
            if (data != null) {
                Element element = (Element)data;
                UtilPortalappEditor.displayServiceShortcut(OverviewForm.this.mm_editor.getEditor(), element);
            }
        }

        public void linkEntered(Control arg0) {
        }

        public void linkExited(Control arg0) {
        }
    }

    class Components
    extends FormSection
    implements IHyperlinkListener {
        private Composite mm_container = null;
        private Composite mm_sandwich = null;
        private Label mm_forButton = null;
        private Button mm_moreButton = null;

        public Components() {
            this.setHeaderText("Components");
            this.setDescription("");
            this.setCollapsable(true);
            OverviewForm.this.setScrollable(true);
        }

        public Composite createClient(Composite parent, FormWidgetFactory factory) {
            this.mm_container = factory.createComposite(parent);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 7;
            layout.numColumns = 3;
            this.mm_container.setLayout((Layout)layout);
            return this.mm_container;
        }

        protected void handleMore() {
            UtilPortalappEditor.displayComponentsShortcut(OverviewForm.this.mm_editor.getEditor());
        }

        protected void handleRun(String component) {
            if (component != null && component.length() != 0) {
                UtilPortalappEditor.launchComponent(component, OverviewForm.this.mm_editor.getEditor());
            }
        }

        public void loadForm() {
            NodeList componentsNodeList = OverviewForm.this.mm_editor.getEditor().getDocument().getElementsByTagName("component");
            String components = "No components";
            if (this.mm_sandwich != null && !this.mm_sandwich.isDisposed()) {
                this.mm_sandwich.dispose();
                this.mm_sandwich = null;
            }
            if (this.mm_moreButton != null && !this.mm_moreButton.isDisposed() && this.mm_forButton != null && !this.mm_forButton.isDisposed()) {
                this.mm_forButton.dispose();
                this.mm_moreButton.dispose();
                this.mm_forButton = null;
                this.mm_moreButton = null;
            }
            this.mm_sandwich = ((AbstractForm)OverviewForm.this).factory.createComposite(this.mm_container);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 7;
            layout.numColumns = 3;
            this.mm_sandwich.setLayout((Layout)layout);
            this.mm_sandwich.setLayoutData((Object)new GridData(768));
            if (componentsNodeList == null || componentsNodeList.getLength() == 0) {
                Label noComponentLabel = ((AbstractForm)OverviewForm.this).factory.createLabel(this.mm_sandwich, components);
                noComponentLabel.setLayoutData((Object)new GridData(32));
            } else {
                int i = 0;
                while (i < componentsNodeList.getLength()) {
                    Element component = (Element)componentsNodeList.item(i);
                    if (i == 0) {
                        components = "";
                    }
                    String nodeName = component.getAttribute("name");
                    Label labelImage = ((AbstractForm)OverviewForm.this).factory.createLabel(this.mm_sandwich, "");
                    labelImage.setImage(ImageUtil.getImageRegistry().get("componentEditor.gif"));
                    SelectableFormLabel labelComponent = ((AbstractForm)OverviewForm.this).factory.createSelectableLabel(this.mm_sandwich, nodeName);
                    ((AbstractForm)OverviewForm.this).factory.turnIntoHyperlink((Control)labelComponent, (IHyperlinkListener)this);
                    labelComponent.setData("component", (Object)component);
                    labelComponent.setLayoutData((Object)new GridData(1));
                    Composite compo = ((AbstractForm)OverviewForm.this).factory.createComposite(this.mm_sandwich);
                    compo.setLayout((Layout)new RowLayout());
                    Button runButton = ((AbstractForm)OverviewForm.this).factory.createButton(compo, "Run...", 0);
                    runButton.setLayoutData((Object)new RowData(45, 15));
                    runButton.setData((Object)nodeName);
                    runButton.setToolTipText("Run component on the portal");
                    runButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                        private final /* synthetic */ Components this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            this.this$1.handleRun((String)((Button)e.getSource()).getData());
                        }
                    });
                    FontData fontData = runButton.getFont().getFontData()[0];
                    runButton.setFont(new Font((Device)OverviewForm.this.mm_parent.getShell().getDisplay(), fontData.getName(), (int)Math.round((double)fontData.getHeight() * 0.9), 0));
                    NodeList configProfile = component.getChildNodes();
                    int j = 0;
                    while (j < configProfile.getLength()) {
                        Node confProf = configProfile.item(j);
                        components = components + PortalappUtils.getNodesResults(confProf.getChildNodes(), true);
                        ++j;
                    }
                    ++i;
                }
            }
            this.mm_forButton = ((AbstractForm)OverviewForm.this).factory.createLabel(this.mm_container, "");
            this.mm_forButton.setLayoutData((Object)new GridData(512));
            this.mm_moreButton = ((AbstractForm)OverviewForm.this).factory.createButton(this.mm_container, "More...", 0);
            this.mm_moreButton.setLayoutData((Object)new GridData(3));
            this.mm_moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ Components this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.handleMore();
                }
            });
            this.mm_container.layout();
        }

        public void update() {
        }

        public void linkActivated(Control arg0) {
            Object data = arg0.getData("component");
            if (data != null) {
                Element element = (Element)data;
                UtilPortalappEditor.displayComponentShortcut(OverviewForm.this.mm_editor.getEditor(), element);
            }
        }

        public void linkEntered(Control arg0) {
        }

        public void linkExited(Control arg0) {
        }
    }

    class Source
    extends FormSection {
        private Label mm_applicationLabel = null;
        private Composite mm_container = null;

        public Source() {
            this.setHeaderText("Application");
            this.setDescription("");
            this.setCollapsable(true);
            OverviewForm.this.setScrollable(true);
        }

        public Composite createClient(Composite parent, FormWidgetFactory factory) {
            this.mm_container = factory.createComposite(parent);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 7;
            layout.numColumns = 5;
            this.mm_container.setLayout((Layout)layout);
            this.mm_container.setLayoutData((Object)new GridData(768));
            Label image = factory.createLabel(this.mm_container, "");
            image.setImage(ImageUtil.getImageRegistry().get("applicationEditor.gif"));
            Label alias = factory.createLabel(this.mm_container, " Alias: ");
            Display display = parent.getDisplay();
            alias.setForeground(new Color((Device)display, 0, 0, 156));
            this.mm_applicationLabel = factory.createLabel(this.mm_container, "");
            this.mm_applicationLabel.setLayoutData((Object)new GridData(1));
            Label forButton = factory.createLabel(this.mm_container, "");
            forButton.setLayoutData((Object)new GridData(512));
            Button moreButton = factory.createButton(this.mm_container, "More...", 0);
            moreButton.setLayoutData((Object)new GridData(3));
            moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ Source this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.handleMore();
                }
            });
            return this.mm_container;
        }

        protected void handleMore() {
            UtilPortalappEditor.displayApplicationShortcut(OverviewForm.this.mm_editor.getEditor());
        }

        public void loadForm() {
            NodeList applicationNodeList = OverviewForm.this.mm_editor.getEditor().getDocument().getElementsByTagName("application");
            String applicationName = WebServicesProcessEP6.findValueOfAttributeinNode(applicationNodeList.item(0), "alias");
            if (applicationName != null) {
                this.mm_applicationLabel.setText(applicationName);
            } else {
                this.mm_applicationLabel.setText("No Alias");
            }
            this.mm_container.layout();
        }

        public void update() {
        }
    }
}

