/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.editors;

import com.sap.netweaver.ep.core.preferences.Controller;
import com.sap.netweaver.ep.core.preferences.IServerConfig;
import com.sap.portal.developmentTools.general.editors.EditorsStrings;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DTRPortalUtil;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappEditorsStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappManager;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.PortalappXmlEditor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.AddPropertiesAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.AliasAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.CreatePortalObjectAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.EditAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.EditSourceAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.LaunchComponentAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.RemoveAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.RemoveAliasAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.actions.RenameAction;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.NewGenericWizard;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards.AddPropertyWizard;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.portalappWizards.EditPropertyDialog;
import com.sap.portal.util.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UtilPortalappEditor
implements PortalappEditorsStrings,
EditorsStrings {
    public static void addPropertyAction(Element selectedNode, String id, Shell mm_shell, PortalappXmlEditor editor) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            String nodeName = selectedNode.getNodeName();
            boolean createNewConfOrProfileNode = false;
            if (id != null && (id.equals("ADD_CONFIG_ACTION") || id.equals("ADD_PROFILE_ACTION"))) {
                String nameNewSelectedNode = id.equals("ADD_CONFIG_ACTION") ? (nodeName.equals("component") ? "component-config" : "service-config") : (nodeName.equals("component") ? "component-profile" : "service-profile");
                NodeList nodes = selectedNode.getElementsByTagName(nameNewSelectedNode);
                if (nodes.getLength() > 0) {
                    selectedNode = (Element)nodes.item(0);
                } else {
                    Element newNode = selectedNode.getOwnerDocument().createElement(nameNewSelectedNode);
                    selectedNode.appendChild(newNode);
                    selectedNode = (Element)selectedNode.getElementsByTagName(nameNewSelectedNode).item(0);
                    createNewConfOrProfileNode = true;
                }
            }
            AddPropertyWizard wizard = null;
            WizardDialog dialog = null;
            try {
                wizard = new AddPropertyWizard(selectedNode, editor);
                dialog = new WizardDialog(mm_shell, (IWizard)wizard);
                dialog.setPageSize(480, 220);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    if (nodeName.startsWith("component") || selectedNode.getParentNode().getNodeName().startsWith("component")) {
                        if (createNewConfOrProfileNode) {
                            editor.refreshComponentNode((Element)selectedNode.getParentNode());
                        } else {
                            editor.refreshComponentNode(selectedNode);
                        }
                    } else if (nodeName.startsWith("service") || selectedNode.getParentNode().getNodeName().startsWith("service")) {
                        if (createNewConfOrProfileNode) {
                            editor.refreshServiceNode((Element)selectedNode.getParentNode());
                        } else {
                            editor.refreshServiceNode(selectedNode);
                        }
                    } else if (selectedNode.getElementsByTagName("property").getLength() == 1) {
                        editor.getApplicationForm().getComponent().loadForm();
                    } else {
                        editor.refreshApplicationNode(selectedNode);
                    }
                    editor.fireDocHasChangedWithDocument();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageBox msgBox = new MessageBox(editor.getEditorSite().getShell(), 1);
                msgBox.setMessage("Error reading portalappConfig.xml");
                msgBox.setText("The file portalappConfig.xml is missing.");
                msgBox.open();
            }
        }
    }

    public static void removeNodeAction(Element selectedNode, Shell shell, PortalappXmlEditor editor) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            String nodeName = selectedNode.getNodeName();
            String[] tab = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(shell, "Confirmation dialog", null, "Are you sure you want to delete the \"" + nodeName + "\" node", 3, tab, 0);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                UtilPortalappEditor.removeNode(selectedNode, shell, editor, false);
            }
        }
    }

    public static void removeNodesAction(IStructuredSelection selection, Shell shell, PortalappXmlEditor editor) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            String[] tab = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(shell, "Confirmation dialog", null, "Are you sure you want to delete all selected nodes ?", 3, tab, 0);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Element selectedNode;
                int nbServices = 0;
                int nbComponents = 0;
                Iterator selectedData = selection.iterator();
                while (selectedData.hasNext()) {
                    selectedNode = (Element)selectedData.next();
                    if (!selectedNode.getNodeName().equals("component") ? selectedNode.getNodeName().equals("service") && ++nbServices == 2 : ++nbComponents == 2) break;
                }
                selectedData = selection.iterator();
                while (selectedData.hasNext()) {
                    selectedNode = (Element)selectedData.next();
                    Node parentNode = selectedNode.getParentNode();
                    if (parentNode == null || parentNode.getNodeType() != 1 || parentNode.getParentNode() == null) continue;
                    String nodeName = selectedNode.getNodeName();
                    if (nodeName.equals("property") && selectedNode.getAttribute("name").equals("className") && selectedNode.getParentNode().getNodeName().equals("service-config")) {
                        MessageDialog warning = new MessageDialog(shell, "Warning", null, "You can't delete className mandatory property for " + ((Element)parentNode.getParentNode()).getAttribute("name") + " service.", 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        warning.open();
                        continue;
                    }
                    UtilPortalappEditor.removeNode(selectedNode, shell, editor, nbComponents == 2 || nbServices == 2);
                }
                if (nbComponents == 2 || nbServices == 2) {
                    editor.fireDocHasChanged();
                    editor.updateRightForm();
                    editor.fireDocHasChangedWithDocument();
                }
            }
        }
    }

    public static boolean isParent(Element node, Element nodeParent) {
        block2: {
            do {
                if (node.getParentNode() == null) {
                    return false;
                }
                if (node.getParentNode().getNodeType() != 1) break block2;
            } while (!(node = (Element)node.getParentNode()).equals(nodeParent));
            return true;
        }
        return false;
    }

    public static void changePropertyAction(Element selectedNode, Shell mm_shell, PortalappXmlEditor editor, TreeViewer treeViewer) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            Hashtable propertyHTable;
            IProject currentProject;
            EditPropertyDialog editDialog;
            PortalappManager portalappManager = null;
            try {
                portalappManager = new PortalappManager();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            String propertyName = selectedNode.getAttribute("name");
            String propertyValue = selectedNode.getAttribute("value");
            if (propertyName != null && (editDialog = new EditPropertyDialog(currentProject = ((FileEditorInput)editor.getEditorInput()).getFile().getProject(), propertyName, propertyHTable = portalappManager.getPropertyDefinition(selectedNode.getParentNode(), propertyName), propertyValue)).open() == 0) {
                propertyValue = editDialog.getPropertyValue();
                portalappManager.setProperty(selectedNode.getParentNode(), new String[]{propertyName, propertyValue});
                treeViewer.refresh((Object)selectedNode);
                treeViewer.refresh((Object)selectedNode);
                editor.fireDocHasChangedWithDocument();
            }
        }
    }

    public static void aliasAction(Element selectedNode, Shell mm_shell, PortalappXmlEditor editor) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            String mode;
            String defaultValue;
            String nodeName = selectedNode.getNodeName();
            if (selectedNode.getAttributes().getNamedItem("alias") == null) {
                defaultValue = "";
                mode = "Add";
            } else {
                defaultValue = selectedNode.getAttribute("alias");
                mode = "Change";
            }
            IInputValidator validator = new IInputValidator(){

                public String isValid(String input) {
                    Object errorMsg = null;
                    if (input == null || input.trim().equals("")) {
                        return "";
                    }
                    if (input.length() > 255) {
                        return "Alias must be shorter than 255 char";
                    }
                    return null;
                }
            };
            InputDialog dialogI = new InputDialog(mm_shell, mode + " alias for " + nodeName, "Please enter alias value: ", defaultValue, validator);
            dialogI.setBlockOnOpen(true);
            boolean needName = true;
            while (needName) {
                dialogI.open();
                if (dialogI.getValue() == null) {
                    needName = false;
                    continue;
                }
                if (dialogI.getValue().equals("")) continue;
                needName = false;
            }
            String aliasName = dialogI.getValue();
            if (aliasName != null && aliasName.length() > 0) {
                selectedNode.setAttribute("alias", aliasName);
                if (nodeName.equals("service")) {
                    editor.getOutlinePage().refreshNode(selectedNode);
                    editor.refreshServiceNode(selectedNode);
                } else {
                    editor.getOverviewForm().updateSourceSection();
                    editor.getApplicationForm().getApplication().loadForm();
                }
                editor.fireDocHasChangedWithDocument();
            }
        }
    }

    public static void removeAliasAction(Element selectedNode, Shell shell, PortalappXmlEditor editor) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            String[] tab = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            String nodeName = selectedNode.getNodeName();
            MessageDialog dialog = new MessageDialog(shell, "Confirmation dialog", null, "Are you sure you want to delete the \"" + nodeName + "\" alias", 3, tab, 0);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                selectedNode.removeAttribute("alias");
                if (nodeName.equals("service")) {
                    editor.getOutlinePage().refreshNode(selectedNode);
                    editor.refreshServiceNode(selectedNode);
                } else {
                    editor.getOverviewForm().updateSourceSection();
                    editor.getApplicationForm().getApplication().loadForm();
                }
                editor.fireDocHasChangedWithDocument();
            }
        }
    }

    private static void removeNode(Element selectedNode, Shell shell, PortalappXmlEditor editor, boolean refreshUi) {
        String nodeName = selectedNode.getNodeName();
        Element parentNode = (Element)selectedNode.getParentNode();
        boolean mandatoryValue = false;
        boolean hasChanged = false;
        if (nodeName.equals("application-config") || nodeName.equals("components") || nodeName.equals("services")) {
            Element replaceNode = selectedNode.getOwnerDocument().createElement(selectedNode.getNodeName());
            parentNode.insertBefore(replaceNode, selectedNode);
        } else if (nodeName.equals("service-config")) {
            NodeList properties = selectedNode.getElementsByTagName("property");
            int i = 0;
            while (i < properties.getLength()) {
                if (properties.item(i).getParentNode().equals(selectedNode)) {
                    if (((Element)properties.item(i)).getAttribute("name") != null && ((Element)properties.item(i)).getAttribute("name").equals("className")) {
                        MessageDialog dialog = new MessageDialog(shell, "Warning", null, "You can't delete className mandatory property for " + parentNode.getAttribute("name") + " service.", 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.open();
                        mandatoryValue = true;
                    } else {
                        selectedNode.removeChild(properties.item(i));
                        hasChanged = true;
                    }
                }
                ++i;
            }
        }
        if (!mandatoryValue) {
            parentNode.removeChild(selectedNode);
            if (!refreshUi) {
                UtilPortalappEditor.updateRemoveAction(nodeName, parentNode, editor);
            }
        } else if (hasChanged && !refreshUi) {
            UtilPortalappEditor.updateRemoveAction(nodeName, parentNode, editor);
        }
    }

    private static void updateRemoveAction(String nodeName, Element parentNode, PortalappXmlEditor editor) {
        if (nodeName.equals("components")) {
            editor.getOverviewForm().updateComponentSection();
            editor.getOutlinePage().refreshNode(parentNode);
            editor.getComponentsForm().getComponent().loadForm();
        } else if (nodeName.equals("services")) {
            editor.getOverviewForm().updateServiceSection();
            editor.getOutlinePage().refreshNode(parentNode);
            editor.getServicesForm().getComponent().loadForm();
        } else if (nodeName.equals("component")) {
            editor.getOverviewForm().updateComponentSection();
            editor.getOutlinePage().refreshNode(parentNode);
            if (parentNode.getElementsByTagName("components").getLength() == 0) {
                editor.getComponentsForm().getComponent().loadForm();
            } else {
                editor.refreshComponentNode(parentNode);
            }
        } else if (nodeName.equals("service")) {
            editor.getOverviewForm().updateServiceSection();
            editor.getOutlinePage().refreshNode(parentNode);
            if (parentNode.getElementsByTagName("components").getLength() == 0) {
                editor.getServicesForm().getComponent().loadForm();
            } else {
                editor.refreshServiceNode(parentNode);
            }
        } else if (nodeName.equals("application-config") || parentNode.getNodeName().equals("application-config")) {
            editor.getApplicationForm().getComponent().loadForm();
            editor.getOutlinePage().refreshNode(parentNode);
        } else if (parentNode.getNodeName().equals("component") || parentNode.getParentNode().getNodeName().equals("component")) {
            editor.refreshComponentNode(parentNode);
        } else if (parentNode.getNodeName().equals("service") || parentNode.getParentNode().getNodeName().equals("service")) {
            editor.refreshServiceNode(parentNode);
        } else {
            editor.refreshComponentNode(parentNode);
            editor.refreshServiceNode(parentNode);
            editor.refreshApplicationNode(parentNode);
        }
        editor.fireDocHasChangedWithDocument();
    }

    public static void renameAction(Element selectedNode, Shell shell, PortalappXmlEditor editor) {
        if (UtilPortalappEditor.portalappCanWrite(editor)) {
            String newName;
            String nameComponent = selectedNode.getNodeName();
            String defaultValue = selectedNode.getAttribute("name");
            InputDialog dialogI = new InputDialog(shell, "Rename " + defaultValue + " " + nameComponent, "Please enter the name value: ", defaultValue, null);
            dialogI.setBlockOnOpen(true);
            boolean needName = true;
            dialogI.open();
            if (dialogI.getReturnCode() == 0 && !(newName = dialogI.getValue()).equals(defaultValue)) {
                selectedNode.setAttribute("name", newName);
                editor.getOutlinePage().refreshNode(selectedNode);
                if (nameComponent.equals("component")) {
                    editor.getOverviewForm().updateComponentSection();
                    editor.refreshComponentNode(selectedNode);
                } else {
                    editor.getOverviewForm().updateServiceSection();
                    editor.refreshServiceNode(selectedNode);
                }
                editor.fireDocHasChangedWithDocument();
            }
        }
    }

    public static void fillContextMenu(IMenuManager menuManager, TreeViewer viewer, Shell shell, PortalappXmlEditor editor) {
        ISelection selection = viewer.getSelection();
        if (selection != null) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() == 1) {
                Element selectedData = (Element)ss.getFirstElement();
                if (selectedData != null) {
                    String nameNode = selectedData.getNodeName();
                    if (nameNode.equals("application-config") || nameNode.equals("component-config") || nameNode.equals("component-profile") || nameNode.equals("service-config") || nameNode.equals("service-profile")) {
                        RemoveAction removeAction = new RemoveAction(viewer, shell, editor);
                        removeAction.setText("&Remove " + nameNode + " properties");
                        removeAction.setImageDescriptor(PortalappXmlEditor.getIcon("removeAll.gif"));
                        AddPropertiesAction addAction = new AddPropertiesAction(viewer, shell, editor);
                        addAction.setText("&Add " + nameNode + " property" + "...");
                        addAction.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                        menuManager.add((IAction)addAction);
                        menuManager.add((IAction)removeAction);
                        if (nameNode.equals("application-config")) {
                            String mode;
                            menuManager.add((IContributionItem)new Separator());
                            AliasAction addAlias = new AliasAction(viewer, shell, editor);
                            if (((Element)selectedData.getParentNode()).getAttributes().getNamedItem("alias") == null) {
                                mode = "Add";
                            } else {
                                mode = "Change";
                                RemoveAliasAction removeAliasAction = new RemoveAliasAction(viewer, shell, editor);
                                removeAliasAction.setText("&Remove  alias...");
                                removeAliasAction.setImageDescriptor(PortalappXmlEditor.getIcon("remove.gif"));
                                menuManager.add((IAction)removeAliasAction);
                            }
                            addAlias.setText(mode + " alias" + "...");
                            if (mode.equals("Add")) {
                                addAlias.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                            }
                            menuManager.add((IAction)addAlias);
                        }
                    } else if (nameNode.equals("property")) {
                        if (!selectedData.getParentNode().getNodeName().equals("property")) {
                            if (selectedData.getParentNode().getNodeName().equals("application-config")) {
                                AddPropertiesAction addPropAction = new AddPropertiesAction(viewer, shell, editor, true);
                                addPropAction.setText("&Add  property...");
                                addPropAction.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                                menuManager.add((IAction)addPropAction);
                            }
                            AddPropertiesAction addAction = new AddPropertiesAction(viewer, shell, editor);
                            addAction.setText("&Add  sub-property...");
                            addAction.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                            menuManager.add((IAction)addAction);
                        }
                        EditAction editAction = new EditAction(viewer, shell, editor);
                        editAction.setText("&Edit property...");
                        menuManager.add((IAction)editAction);
                        if (!selectedData.getAttribute("name").equals("className") || !selectedData.getParentNode().getNodeName().equals("service-config")) {
                            RemoveAction removeAction = new RemoveAction(viewer, shell, editor);
                            removeAction.setText("&Remove ");
                            removeAction.setImageDescriptor(PortalappXmlEditor.getIcon("remove.gif"));
                            menuManager.add((IAction)removeAction);
                        }
                    } else if (nameNode.equals("components") || nameNode.equals("services")) {
                        String actionName;
                        int filterType;
                        RemoveAction removeAction = new RemoveAction(viewer, shell, editor);
                        removeAction.setText("&Remove  all");
                        removeAction.setImageDescriptor(PortalappXmlEditor.getIcon("removeAll.gif"));
                        if (nameNode.equals("components")) {
                            filterType = 1;
                            actionName = "Component";
                        } else {
                            filterType = 2;
                            actionName = "Service";
                        }
                        CreatePortalObjectAction addAction = new CreatePortalObjectAction(filterType, viewer, shell, editor);
                        addAction.setText("&Create Portal Application " + actionName + "...");
                        addAction.setImageDescriptor(PortalappXmlEditor.getIcon("IView.gif"));
                        menuManager.add((IAction)addAction);
                        menuManager.add((IContributionItem)new Separator());
                        menuManager.add((IAction)removeAction);
                    } else if (nameNode.equals("component") || nameNode.equals("service")) {
                        String actionName;
                        int filterType;
                        String profileType;
                        String configType;
                        String nameType;
                        if (nameNode.equals("component")) {
                            nameType = "component";
                            configType = "component-config";
                            profileType = "component-profile";
                            filterType = 1;
                            actionName = "Component";
                        } else {
                            nameType = "service";
                            configType = "service-config";
                            profileType = "service-profile";
                            filterType = 2;
                            actionName = "Service";
                        }
                        RemoveAction removeAction = new RemoveAction(viewer, shell, editor);
                        removeAction.setText("&Remove " + nameType);
                        removeAction.setImageDescriptor(PortalappXmlEditor.getIcon("remove.gif"));
                        AddPropertiesAction addActionCongig = new AddPropertiesAction(viewer, shell, editor);
                        addActionCongig.setText(configType + "...");
                        addActionCongig.setId("ADD_CONFIG_ACTION");
                        addActionCongig.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                        AddPropertiesAction addActionProfile = new AddPropertiesAction(viewer, shell, editor);
                        addActionProfile.setText(profileType + "...");
                        addActionProfile.setId("ADD_PROFILE_ACTION");
                        addActionProfile.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                        RenameAction renameAction = new RenameAction(viewer, shell, editor);
                        renameAction.setText("&Rename " + nameType + "...");
                        MenuManager gotoMenu = new MenuManager("&Add  property in");
                        menuManager.add((IContributionItem)gotoMenu);
                        gotoMenu.add((IAction)addActionCongig);
                        gotoMenu.add((IContributionItem)new Separator());
                        gotoMenu.add((IAction)addActionProfile);
                        menuManager.add((IContributionItem)new Separator());
                        menuManager.add((IAction)removeAction);
                        menuManager.add((IAction)renameAction);
                        menuManager.add((IContributionItem)new Separator());
                        if (nameNode.equals("service")) {
                            String mode;
                            if (selectedData.getAttributes().getNamedItem("alias") == null) {
                                mode = "Add";
                            } else {
                                mode = "Change";
                                RemoveAliasAction removeAliasAction = new RemoveAliasAction(viewer, shell, editor);
                                removeAliasAction.setText("&Remove  alias");
                                removeAliasAction.setImageDescriptor(PortalappXmlEditor.getIcon("remove.gif"));
                                menuManager.add((IAction)removeAliasAction);
                            }
                            AliasAction addAlias = new AliasAction(viewer, shell, editor);
                            addAlias.setText(mode + " alias" + "...");
                            if (mode.equals("Add")) {
                                addAlias.setImageDescriptor(PortalappXmlEditor.getIcon("add.gif"));
                            }
                            menuManager.add((IAction)addAlias);
                        }
                        CreatePortalObjectAction addAction = new CreatePortalObjectAction(filterType, viewer, shell, editor);
                        addAction.setText("&Create Portal Application " + actionName + "...");
                        addAction.setImageDescriptor(PortalappXmlEditor.getIcon("IView.gif"));
                        menuManager.add((IContributionItem)new Separator());
                        menuManager.add((IAction)addAction);
                        EditSourceAction editSourceAction = new EditSourceAction(selectedData, editor);
                        editSourceAction.setText("Open source file");
                        editSourceAction.setImageDescriptor(PortalappXmlEditor.getIcon("TypeJavaClass.gif"));
                        menuManager.add((IContributionItem)new Separator());
                        menuManager.add((IAction)editSourceAction);
                        if (nameNode.equals("component")) {
                            String name = selectedData.getAttribute("name");
                            LaunchComponentAction launchAction = new LaunchComponentAction(name, editor);
                            launchAction.setImageDescriptor(PortalappXmlEditor.getIcon("run_exec.gif"));
                            launchAction.setText("Run component");
                            menuManager.add((IAction)launchAction);
                        }
                    }
                }
            } else {
                if (((Element)ss.getFirstElement()).getNodeName().equals("application")) {
                    return;
                }
                RemoveAction removeAction = new RemoveAction(viewer, shell, editor);
                removeAction.setText("&Remove  all");
                removeAction.setImageDescriptor(PortalappXmlEditor.getIcon("removeAll.gif"));
                menuManager.add((IAction)removeAction);
            }
        }
    }

    public static void createPortalObjectAction(int typeFilter, PortalappXmlEditor editor, Shell shell) {
        IProject currentProject;
        if (editor.isDirty()) {
            MessageDialog dialog = new MessageDialog(shell, "Portalapp editor", null, "You should save portalapp before launching new Portal Object Wizard or you will lose last changes. Do you want to save portalapp.xml file ?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.NO_LABEL}, 0);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                editor.doSave(null);
            }
        }
        NewGenericWizard genericWizard = (currentProject = editor.getInputIFile().getProject()) != null ? new NewGenericWizard(currentProject, typeFilter) : new NewGenericWizard();
        genericWizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog wd = new WizardDialog(shell, (IWizard)genericWizard);
        wd.open();
    }

    public static void editSourceFile(Element element, PortalappXmlEditor editor) {
        String classname_type;
        String configName_type;
        String className = "";
        if (element.getNodeName().equals("component")) {
            configName_type = "component-config";
            classname_type = "ClassName";
        } else {
            configName_type = "service-config";
            classname_type = "className";
        }
        try {
            NodeList properties = ((Element)element.getElementsByTagName(configName_type).item(0)).getElementsByTagName("property");
            int i = 0;
            while (i < properties.getLength()) {
                if (((Element)properties.item(i)).getAttribute("name").equals(classname_type)) {
                    className = ((Element)properties.item(i)).getAttribute("value");
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            MessageBox msgBox = new MessageBox(editor.getEditorSite().getShell(), 1);
            msgBox.setText("Error opening source file");
            msgBox.setMessage("Source file can not be found because " + classname_type + " property was not found");
            msgBox.open();
            return;
        }
        String fileApiLocation = "";
        String fileCoreLocation = "src.core\\";
        String fileName = Strings.replaceCharByString(className, ".", "\\") + ".java";
        IFile file = editor.getProject().getFile(fileCoreLocation + fileName);
        if (!file.exists()) {
            fileApiLocation = "src.api\\";
            file = editor.getProject().getFile(fileApiLocation + fileName);
        }
        if (file.exists()) {
            try {
                PortalPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(file);
            }
            catch (Exception e1) {
                MessageBox msgBox = new MessageBox(editor.getEditorSite().getShell(), 1);
                msgBox.setText("Error opening source file");
                msgBox.setMessage("Error editing " + fileName + " file");
                msgBox.open();
            }
        } else {
            MessageBox msgBox = new MessageBox(editor.getEditorSite().getShell(), 1);
            msgBox.setText("Error opening source file");
            msgBox.setMessage(fileName + " file can not be found on " + fileCoreLocation + " and " + fileApiLocation + " locations.");
            msgBox.open();
        }
    }

    public static void launchComponent(String component, PortalappXmlEditor editor) {
        IServerConfig lastServer = Controller.getInstance().getLastServerConfig();
        IDESettings is = IDESettings.getInstance();
        if (lastServer == null) {
            IServerConfig defaultServer = Controller.getInstance().getDefaultServerConfig();
            if (defaultServer == null) {
                MessageDialog diag = new MessageDialog(editor.getSite().getShell(), "Server definition error", null, "No server defined: Check your setting", 1, new String[]{"OK"}, 0);
                diag.open();
            } else {
                String host = defaultServer.getHost();
                int port = defaultServer.getPort();
                UtilPortalappEditor.showUrl("http://" + host + ":" + port + "/irj/servlet/prt/portal/prtroot/" + is.getParShortName(editor.getProject()) + "." + component);
            }
        } else {
            String host = lastServer.getHost();
            int port = lastServer.getPort();
            UtilPortalappEditor.showUrl("http://" + host + ":" + port + "/irj/servlet/prt/portal/prtroot/" + is.getParShortName(editor.getProject()) + "." + component);
        }
    }

    private static void showUrl(String url) {
        boolean win32 = SWT.getPlatform().equals("win32");
        if (win32) {
            Program.launch((String)url);
        }
    }

    public static void DisplayShortcut(PortalappXmlEditor editor, Element selectedNode) {
        String selectedNodeName = selectedNode.getNodeName();
        if (selectedNodeName.equals("component")) {
            UtilPortalappEditor.displayComponentShortcut(editor, selectedNode);
        } else if (selectedNodeName.equals("components")) {
            UtilPortalappEditor.displayComponentsShortcut(editor);
        } else if (selectedNodeName.equals("service")) {
            UtilPortalappEditor.displayServiceShortcut(editor, selectedNode);
        } else if (selectedNodeName.equals("services")) {
            UtilPortalappEditor.displayServicesShortcut(editor);
        } else if (selectedNodeName.equals("application-config")) {
            UtilPortalappEditor.displayApplicationShortcut(editor);
        } else if (selectedNodeName.equals("application")) {
            if (editor.getOverviewForm().getEditorPart() == null) {
                editor.getOverviewForm().loadForm(editor.getOverviewEditorPart());
            } else {
                editor.getOverviewEditorPart().setFocus();
            }
            editor.getOverviewEditor();
        } else {
            editor.getSourceEditor();
        }
    }

    public static void displayApplicationShortcut(PortalappXmlEditor editor) {
        if (editor.getApplicationForm().getEditorPart() == null) {
            editor.getApplicationForm().loadForm(editor.getApplicationEditorPart());
        } else {
            editor.getApplicationEditorPart().setFocus();
        }
        editor.getApplicationEditor();
    }

    public static void displayServicesShortcut(PortalappXmlEditor editor) {
        editor.getServicesEditor();
        if (editor.getServicesForm().getEditorPart() == null) {
            editor.getServicesForm().loadForm(editor.getServiceEditorPart());
        } else {
            editor.getServiceEditorPart().setFocus();
        }
    }

    public static void displayComponentsShortcut(PortalappXmlEditor editor) {
        editor.getComponentsEditor();
        if (editor.getComponentsForm().getEditorPart() == null) {
            editor.getComponentsForm().loadForm(editor.getComponentEditorPart());
        } else {
            editor.getComponentEditorPart().setFocus();
        }
    }

    public static void displayComponentShortcut(PortalappXmlEditor editor, Element selectedNode) {
        UtilPortalappEditor.displayComponentsShortcut(editor);
        editor.getComponentsForm().getComponent().getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedNode), true);
        editor.getComponentsForm().getComponent().getViewer().collapseAll();
        editor.getComponentsForm().getComponent().getViewer().expandToLevel((Object)selectedNode, 2);
    }

    public static void displayServiceShortcut(PortalappXmlEditor editor, Element selectedNode) {
        UtilPortalappEditor.displayServicesShortcut(editor);
        editor.getServicesForm().getComponent().getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedNode), true);
        editor.getServicesForm().getComponent().getViewer().collapseAll();
        editor.getServicesForm().getComponent().getViewer().expandToLevel((Object)selectedNode, 2);
    }

    private static boolean portalappCanWrite(PortalappXmlEditor editor) {
        if (!editor.canWrite()) {
            if (DTRPortalUtil.isManagerAvailable((IResource)editor.getInputIFile())) {
                return DTRPortalUtil.checkoutForEdit(editor.getSite().getShell(), "portalapp", editor.getInputIFile());
            }
            MessageBox msgBox = new MessageBox(editor.getSite().getShell(), 8);
            msgBox.setText("File is read-only");
            msgBox.setMessage("portalapp.xml file is not editable");
            msgBox.open();
            return false;
        }
        return true;
    }
}

