/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.editors;

import com.sap.portal.developmentTools.general.editors.EditorsStrings;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.ComponentsEditorPart;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.OverviewEditorPart;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.SourceEditor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.UpdateTimerTask;
import com.sap.portal.developmentTools.ideSpecific.eclipse.editors.xml.XMLEditor;
import com.sap.portal.developmentTools.ideSpecific.eclipse.forms.ComponentsForm;
import com.sap.portal.developmentTools.ideSpecific.eclipse.forms.OverviewForm;
import com.sap.portal.developmentTools.ideSpecific.eclipse.forms.PortalappOutlineView;
import com.sap.portal.util.eclipse.ImageUtil;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.deployment.DeploymentException;
import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortalappXmlEditor
extends MultiPageEditorPart
implements EditorsStrings {
    private IEditorInput mm_input = null;
    private Document mm_document = null;
    private PortalappOutlineView mm_outlinePage;
    private Descriptor mm_portalappDescriptor = null;
    private boolean mm_hasChanged = false;
    private boolean mm_sourceHasChangedWithOurAction = true;
    private boolean mm_canWrite = true;
    private long fModificationStamp = -1L;
    private boolean mm_fireUpdateDocWithSource = true;
    private boolean mm_sourceHasError = false;
    private boolean mm_isUpdating = false;
    private Timer mm_myTymer;
    private UpdateTimerTask mm_updateTimerTask;
    private PropertyChangeSupport pceListeners;
    private AbstractTextEditor mm_sourceEditor = new SourceEditor(this);
    private ComponentsEditorPart mm_servicesEditor = new ComponentsEditorPart(this, "Services", 0, "service");
    private ComponentsEditorPart mm_componentsEditor = new ComponentsEditorPart(this, "Components", 0, "component");
    private ComponentsEditorPart mm_applicationEditor = new ComponentsEditorPart(this, "Application", 0, "application");
    private OverviewEditorPart mm_overviewEditor = new OverviewEditorPart(this, "Portalapp Overview", 0);
    private static final int PAGE_OVERVIEW_EDITOR = 0;
    private static final int PAGE_APPLICATION_EDITOR = 1;
    private static final int PAGE_COMPONENTS_EDITOR = 2;
    private static final int PAGE_SERVICES_EDITOR = 3;
    private static final int PAGE_SOURCE_EDITOR = 4;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public void getOverviewEditor() {
        this.setActivePage(0);
    }

    public void setActivePage(int pageNumber) {
        if (this.mm_isUpdating) {
            return;
        }
        if (this.getActivePage() == 4 && this.mm_sourceHasError) {
            this.catchErrorLoadingDocument();
            return;
        }
        super.setActivePage(pageNumber);
        this.listenEditorInputChanged();
    }

    public void setFocus() {
        this.listenEditorInputChanged();
        super.setFocus();
    }

    protected void listenEditorInputChanged() {
        long stamp;
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (this.fModificationStamp == -1L) {
            this.fModificationStamp = p.getSynchronizationStamp((Object)this.mm_input);
        }
        if ((stamp = p.getModificationStamp((Object)this.mm_input)) != this.fModificationStamp) {
            this.fModificationStamp = stamp;
            if (stamp != p.getSynchronizationStamp((Object)this.mm_input)) {
                if (this.initDocument()) {
                    this.fireDocHasChanged();
                    this.updateRightForm();
                    this.updateSourceWithDocument();
                    this.mm_hasChanged = false;
                    this.firePropertyChange(257);
                } else {
                    MessageBox msgBox = new MessageBox(this.getEditorSite().getShell(), 2);
                    msgBox.setText("File closed");
                    msgBox.setMessage("File has been moved or project renamed. Please open file from it's new location.");
                    msgBox.open();
                }
            }
        }
    }

    public Document getDocument() {
        return this.mm_document;
    }

    public PortalappOutlineView getOutlinePage() {
        return this.mm_outlinePage;
    }

    public IDocument getSourceDocument() {
        return ((XMLEditor)this.getSourceEditorCustom()).getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public void pageChange(int arg0) {
        if (this.mm_isUpdating) {
            super.setActivePage(4);
            return;
        }
        if (this.mm_sourceHasError) {
            this.catchErrorLoadingDocument();
            return;
        }
        super.pageChange(arg0);
        this.listenEditorInputChanged();
    }

    public boolean checkDocumentIsValid() {
        if (this.mm_document != null) {
            NodeList componentsList = this.mm_document.getElementsByTagName("component");
            int i = 0;
            while (i < componentsList.getLength()) {
                if (componentsList.item(i).getAttributes().getNamedItem("name") == null) {
                    return this.confirmSave("Attribute name is mandatory for component node. Are you sure you want to save ?");
                }
                ++i;
            }
            NodeList servicesList = this.mm_document.getElementsByTagName("service");
            int i2 = 0;
            while (i2 < servicesList.getLength()) {
                if (servicesList.item(i2).getAttributes().getNamedItem("name") == null) {
                    return this.confirmSave("Attribute name is mandatory for service node. Are you sure you want to save ?");
                }
                Element serviceNode = (Element)servicesList.item(i2);
                NodeList propertiesService = serviceNode.getElementsByTagName("property");
                boolean ok = false;
                int j = 0;
                while (j < propertiesService.getLength()) {
                    if (((Element)propertiesService.item(j)).getAttribute("name").equals("className")) {
                        ok = true;
                        break;
                    }
                    ++j;
                }
                if (!ok) {
                    return this.confirmSave("Property className is mandatory for service. Are you sure you want to save ?");
                }
                ++i2;
            }
            return true;
        }
        return true;
    }

    public void getApplicationEditor() {
        this.setActivePage(1);
    }

    public void getComponentsEditor() {
        this.setActivePage(2);
    }

    public void getServicesEditor() {
        this.setActivePage(3);
    }

    public void getSourceEditor() {
        this.setActivePage(4);
    }

    public IEditorPart getSourceEditorCustom() {
        return this.mm_sourceEditor;
    }

    protected void createPages() {
        try {
            this.addPage((IEditorPart)this.mm_overviewEditor, this.getEditorInput());
            this.addPage((IEditorPart)this.mm_applicationEditor, this.getEditorInput());
            this.addPage((IEditorPart)this.mm_componentsEditor, this.getEditorInput());
            this.addPage((IEditorPart)this.mm_servicesEditor, this.getEditorInput());
            this.addPage((IEditorPart)this.mm_sourceEditor, this.getEditorInput());
        }
        catch (PartInitException e) {
            SapPortalPluginsLogger.logError(null, (Throwable)e);
            return;
        }
        this.setPageText(0, "Overview");
        this.setPageText(1, "Application");
        this.setPageText(2, "Components");
        this.setPageText(3, "Services");
        this.setPageText(4, "Source");
        if (this.initDocument()) {
            this.getOverviewEditorPart().update();
        } else {
            this.mm_sourceHasError = true;
            super.setActivePage(4);
        }
        this.addSourceDocumentListener();
    }

    protected void addSourceDocumentListener() {
        IDocument doc = this.getSourceDocument();
        doc.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (PortalappXmlEditor.super.getActivePage() == 4) {
                    if (PortalappXmlEditor.this.mm_fireUpdateDocWithSource) {
                        if (!PortalappXmlEditor.this.mm_isUpdating) {
                            PortalappXmlEditor.this.mm_isUpdating = true;
                            PortalappXmlEditor.this.mm_updateTimerTask = new UpdateTimerTask(PortalappXmlEditor.this, Display.getDefault());
                            PortalappXmlEditor.this.mm_myTymer.schedule((TimerTask)PortalappXmlEditor.this.mm_updateTimerTask, 600L);
                        } else {
                            if (PortalappXmlEditor.this.mm_updateTimerTask != null) {
                                PortalappXmlEditor.this.mm_updateTimerTask.cancel();
                            }
                            PortalappXmlEditor.this.mm_updateTimerTask = new UpdateTimerTask(PortalappXmlEditor.this, Display.getDefault());
                            PortalappXmlEditor.this.mm_isUpdating = true;
                            PortalappXmlEditor.this.mm_myTymer.schedule((TimerTask)PortalappXmlEditor.this.mm_updateTimerTask, 600L);
                        }
                    }
                } else if (!PortalappXmlEditor.this.mm_sourceHasChangedWithOurAction && PortalappXmlEditor.this.updateDocumentWithSource(true)) {
                    PortalappXmlEditor.this.updateRightForm();
                }
                PortalappXmlEditor.this.mm_sourceHasChangedWithOurAction = false;
                PortalappXmlEditor.this.mm_fireUpdateDocWithSource = true;
            }
        });
    }

    public void updateRightForm() {
        if (this.getActivePage() == 1) {
            this.getApplicationEditorPart().update();
        } else if (this.getActivePage() == 2) {
            this.getComponentEditorPart().update();
        } else if (this.getActivePage() == 3) {
            this.getServiceEditorPart().update();
        } else if (this.getActivePage() == 0) {
            this.getOverviewEditorPart().update();
        }
    }

    public ComponentsForm getServicesForm() {
        return (ComponentsForm)this.mm_servicesEditor.getForm();
    }

    public ComponentsForm getComponentsForm() {
        return (ComponentsForm)this.mm_componentsEditor.getForm();
    }

    public ComponentsForm getApplicationForm() {
        return (ComponentsForm)this.mm_applicationEditor.getForm();
    }

    public OverviewForm getOverviewForm() {
        return (OverviewForm)this.mm_overviewEditor.getForm();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!this.isValidContentType(input)) {
            throw new PartInitException("The file is not a valid portalapp.xml file.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.mm_input = input;
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
        this.mm_myTymer = new Timer();
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = PortalappXmlEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(required)) {
            if (this.mm_outlinePage == null) {
                this.mm_outlinePage = new PortalappOutlineView(this);
            }
            return this.mm_outlinePage;
        }
        return super.getAdapter(required);
    }

    public boolean isDirty() {
        return this.mm_hasChanged;
    }

    private void writeDocument(PrintWriter writer) {
        DOMSource source = new DOMSource(this.mm_document);
        StreamResult result = new StreamResult(writer);
        TransformerFactory transFactory = Descriptor.getTransformerFactory();
        try {
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            MessageBox msgBox = new MessageBox(this.getEditorSite().getShell(), 1);
            msgBox.setText("Error updating editor");
            msgBox.setMessage("Problem with configuration of the Transformer Factories occur. Can't update editor source.");
            msgBox.open();
        }
    }

    private boolean initDocument() {
        IFile inputIFile = this.getInputIFile();
        if (inputIFile.getLocation() == null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
            return false;
        }
        File inputFile = new File(inputIFile.getLocation().toOSString());
        if (this.mm_canWrite) {
            this.mm_canWrite = inputFile.canWrite();
        }
        this.mm_portalappDescriptor = new Descriptor("application");
        try {
            this.mm_document = this.mm_portalappDescriptor.load(inputFile);
            if (this.addUsefullNodes()) {
                this.updateSourceWithDocument();
            }
            return true;
        }
        catch (DeploymentException e) {
            super.setActivePage(4);
            return false;
        }
    }

    public IFile getInputIFile() {
        return ((IFileEditorInput)this.mm_input).getFile();
    }

    public void fireDocHasChangedWithDocument() {
        if (!this.mm_hasChanged) {
            this.mm_hasChanged = true;
            this.firePropertyChange(257);
        }
        this.updateSourceWithDocument();
    }

    public void fireDocHasChanged() {
        if (this.mm_outlinePage != null) {
            this.mm_outlinePage.refreshView(false);
        }
        this.getServicesForm().fireDocHasChanged();
        this.getComponentsForm().fireDocHasChanged();
        this.getApplicationForm().fireDocHasChanged();
        this.getOverviewForm().fireDocHasChanged();
    }

    public boolean mm_hasChanged() {
        return this.mm_hasChanged;
    }

    public void updateSourceWithDocument() {
        IDocument doc = this.getSourceDocument();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.writeDocument(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException e) {
            SapPortalPluginsLogger.logError(null, (Throwable)e);
        }
        this.mm_sourceHasChangedWithOurAction = true;
        this.mm_fireUpdateDocWithSource = false;
        doc.set(swriter.toString());
    }

    public boolean addUsefullNodes() {
        boolean nodeIsAdded = false;
        Element appliNode = (Element)this.mm_document.getElementsByTagName("application").item(0);
        if (appliNode.getElementsByTagName("services").getLength() == 0) {
            Element newNode = this.mm_document.createElement("services");
            appliNode.appendChild(newNode);
            nodeIsAdded = true;
        }
        Element servicesNode = (Element)appliNode.getElementsByTagName("services").item(0);
        if (appliNode.getElementsByTagName("components").getLength() == 0) {
            Element newNode = this.mm_document.createElement("components");
            appliNode.insertBefore(newNode, servicesNode);
            nodeIsAdded = true;
        }
        Element componentsNode = (Element)this.mm_document.getElementsByTagName("components").item(0);
        if (this.mm_document.getElementsByTagName("application-config").getLength() == 0) {
            Element newNode = this.mm_document.createElement("application-config");
            appliNode.insertBefore(newNode, componentsNode);
            nodeIsAdded = true;
        }
        if (nodeIsAdded) {
            this.mm_hasChanged = true;
            this.firePropertyChange(257);
        }
        return nodeIsAdded;
    }

    public boolean updateDocumentWithSource(boolean catchException) {
        IDocument doc = this.getSourceDocument();
        String xmlString = doc.get();
        ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
        this.mm_document = null;
        try {
            this.mm_document = this.mm_portalappDescriptor.load((InputStream)is);
            this.addUsefullNodes();
            this.fireDocHasChanged();
            this.mm_sourceHasError = false;
            return true;
        }
        catch (DeploymentException e) {
            if (this.mm_outlinePage != null) {
                this.mm_outlinePage.refreshView(true);
            }
            this.mm_sourceHasError = true;
            if (catchException) {
                this.catchErrorLoadingDocument();
            }
            return false;
        }
    }

    protected boolean confirmSave(String errorMessage) {
        MessageDialog dialog = new MessageDialog(null, "Portalapp editor", null, errorMessage, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.NO_LABEL}, 1);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    protected void catchErrorLoadingDocument() {
        MessageDialog dialog = new MessageDialog(null, "Portalapp editor", null, "The source page has errors. Other pages cannot be used until these errors are corrected.", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        super.setActivePage(4);
        dialog.open();
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        return input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput) ? name.startsWith("portalapp.xml") : name.equals("portalapp.xml");
    }

    public void doSave(IProgressMonitor monitor) {
        this.savePortalapp(monitor);
    }

    public boolean savePortalapp(IProgressMonitor monitor) {
        if (this.getActivePage() == 4 && this.mm_sourceHasError && !this.confirmSave("Your document has errors. Are you sure you want to save ?")) {
            return false;
        }
        if (!this.checkDocumentIsValid()) {
            return false;
        }
        try {
            this.getDocumentProvider().saveDocument(monitor, (Object)this.mm_input, this.getDocumentProvider().getDocument((Object)this.mm_input), true);
            this.mm_hasChanged = false;
            this.firePropertyChange(257);
            return true;
        }
        catch (Exception e) {
            MessageBox msgBox = new MessageBox(this.getSite().getShell(), 1);
            msgBox.setText("Error saving file");
            msgBox.setMessage("Can't save file. Check that the project is open and try again.");
            msgBox.open();
            return false;
        }
    }

    public String getTitle() {
        return this.mm_sourceEditor.getTitle();
    }

    public void doSaveAs() {
        this.mm_sourceEditor.doSaveAs();
        this.mm_hasChanged = false;
    }

    public void gotoMarker(IMarker marker) {
        this.getSourceEditor();
        this.mm_sourceEditor.gotoMarker(marker);
    }

    public boolean isSaveAsAllowed() {
        boolean isSaveAsAllowed = this.mm_sourceEditor.isSaveAsAllowed();
        return isSaveAsAllowed;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.mm_sourceEditor.getDocumentProvider();
    }

    public static ImageDescriptor getIcon(String name) {
        ImageDescriptor descriptor = null;
        try {
            URL url = new URL(PortalPlugin.getDefault().getDescriptor().getInstallURL(), "icons/" + name);
            descriptor = ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            SapPortalPluginsLogger.logError(null, (Throwable)e);
        }
        return descriptor;
    }

    public ComponentsEditorPart getComponentEditorPart() {
        return this.mm_componentsEditor;
    }

    public ComponentsEditorPart getServiceEditorPart() {
        return this.mm_servicesEditor;
    }

    public OverviewEditorPart getOverviewEditorPart() {
        return this.mm_overviewEditor;
    }

    public ComponentsEditorPart getApplicationEditorPart() {
        return this.mm_applicationEditor;
    }

    public IProject getProject() {
        return this.getInputIFile().getProject();
    }

    public boolean canWrite() {
        return !this.getInputIFile().isReadOnly();
    }

    public void updateDocumentWithSourceAction() {
        this.updateDocumentWithSource(false);
        if (!this.mm_hasChanged) {
            this.mm_hasChanged = true;
            this.firePropertyChange(257);
        }
        this.mm_isUpdating = false;
    }

    public void callDisplay() {
        Display.getDefault().asyncExec((Runnable)this.mm_updateTimerTask);
    }

    public static Image getImage(String name) {
        if (name.equals("application-config")) {
            return ImageUtil.getImageRegistry().get("applicationEditor.gif");
        }
        if (name.equals("component")) {
            return ImageUtil.getImageRegistry().get("componentEditor.gif");
        }
        if (name.equals("service")) {
            return ImageUtil.getImageRegistry().get("serviceEditor.gif");
        }
        if (name.equals("property")) {
            return ImageUtil.getImageRegistry().get("PortalappXmlEditor.gif");
        }
        return ImageUtil.getImageRegistry().get("node.gif");
    }

    public void refreshComponentNode(Element node) {
        if (this.getComponentsForm().getEditorPart() == null) {
            this.getComponentsForm().loadForm(this.getComponentEditorPart());
        }
        this.getComponentsForm().getComponent().getViewer().refresh((Object)node);
    }

    public void refreshServiceNode(Element node) {
        if (this.getServicesForm().getEditorPart() == null) {
            this.getServicesForm().loadForm(this.getServiceEditorPart());
        }
        this.getServicesForm().getComponent().getViewer().refresh((Object)node);
    }

    public void refreshApplicationNode(Element node) {
        if (this.getApplicationForm().getEditorPart() == null) {
            this.getApplicationForm().loadForm(this.getApplicationEditorPart());
        }
        this.getApplicationForm().getComponent().getViewer().refresh((Object)node);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

