/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.portal.developmentTools.general.api.IPropertySystem;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.dcproject.IPortalDCStrings;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Property;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DCPropertiesHandler
implements IPortalDCStrings {
    public static String getFlatDcdefProperty(IProject project, String namespace, String property) {
        String value = null;
        try {
            IDCExtendedProject dcProj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            DevelopmentComponent dc = dcProj.getDCNode().getDevelopmentComponent(true);
            Property prop = dc.getProperty(property, namespace);
            if (prop != null) {
                value = prop.getValue();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (RepositoryAccessException e) {
            e.printStackTrace();
        }
        catch (InvalidDefinitionException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static void setFlatDcdefProperty(IProject project, String namespace, String property, String value) {
        try {
            IDCExtendedProject dcProj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            DevelopmentComponent dc = dcProj.getDCNode().getDevelopmentComponent(true);
            Property prop = dc.getProperty(property, namespace);
            if (prop != null) {
                prop.setValue(value);
            } else {
                prop = dc.addProperty(property, namespace, value);
            }
            dcProj.getDCNode().getDCProxy().serializeDefinition();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (RepositoryAccessException e) {
            e.printStackTrace();
        }
        catch (InvalidDefinitionException e) {
            e.printStackTrace();
        }
        catch (DevConfigException e) {
            e.printStackTrace();
        }
    }

    public static String getParArchiveNameFromDcdef(IProject project) {
        String parName = DCPropertiesHandler.getFlatDcdefProperty(project, "http://xml.sap.com/2004/06/PortalPlatform", "par-archive-name");
        if (parName.endsWith(".par")) {
            return parName.substring(0, parName.length() - 4);
        }
        return parName;
    }

    public static void setParArchiveNameToDcdef(IProject project, String archiveName) {
        if (archiveName.endsWith(".par")) {
            archiveName = archiveName.substring(0, archiveName.length() - 4);
        }
        IDESettings is = IDESettings.getInstance();
        IPropertySystem propSyst = OpentoolsFactory.getPropertySystemInstance();
        is.setParArchiveName(project, archiveName);
        DCPropertiesHandler.setFlatDcdefProperty(project, "http://xml.sap.com/2004/06/PortalPlatform", "par-archive-name", archiveName);
    }

    public static void setZipSrc(IProject project, boolean value) {
        String val = "false";
        if (value) {
            val = "true";
        }
        DCPropertiesHandler.setFlatDcdefProperty(project, "http://xml.sap.com/2004/06/PortalPlatform", "package-sources", val);
    }

    public static void checkNatureOrAddIt(IProjectDescription desc, String nature) {
        String[] natures = desc.getNatureIds();
        if (!desc.hasNature(nature)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = nature;
            desc.setNatureIds(newNatures);
        }
    }

    public static void addJRELib(IProject project) {
        try {
            IClasspathEntry jreLibEntry;
            IJavaProject jProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = jProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            int i = 0;
            while (i < entries.length) {
                newEntries[i] = entries[i];
                ++i;
            }
            newEntries[newEntries.length - 1] = jreLibEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
            jProject.setRawClasspath(newEntries, null);
            jProject.setOutputLocation(jProject.getPath().append("test"), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e3) {
            e3.printStackTrace();
        }
    }

    public static void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldJavaCommand = DCPropertiesHandler.getJavaCommand(description);
        if (oldJavaCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldJavaCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
    }

    private static ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }
}

