/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.buildtool.IBuildResult;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DCBuildWrapper {
    IProject mm_currentProject;
    IProgressMonitor mm_monitor;
    IDevelopmentComponentNode mm_dcNode;

    public DCBuildWrapper(IProgressMonitor monitor, IProject selectedProject) {
        this.mm_monitor = monitor;
        this.mm_currentProject = selectedProject;
    }

    public void run() throws CoreException, DevConfigException, BuildException {
        this.mm_monitor.subTask("Building DC Project");
        Object deployFolder = null;
        IDCExtendedProject dcPrj = (IDCExtendedProject)this.mm_currentProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        this.mm_dcNode = dcPrj.getDCNode();
        IDCProxy dcProxy = this.mm_dcNode.getDCProxy();
        String buildVariant = dcProxy.getDevelopmentConfiguration().getDefaultBuildVariant(dcProxy.getCompartment().getName());
        IBuildResult buildResult = dcProxy.make(buildVariant, null, null);
        if (buildResult.getResultCode() == 2) {
            throw new BuildException(buildResult.getResultMessage());
        }
        if (buildResult.getResultCode() == 3) {
            throw new BuildException(buildResult.getResultMessage());
        }
        this.mm_monitor.worked(1);
    }

    public static String getDeployFolder(IProject project) {
        String deployFolder = null;
        try {
            IDCExtendedProject dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
            IDCProxy dcProxy = dcNode.getDCProxy();
            String buildVariant = dcProxy.getDevelopmentConfiguration().getDefaultBuildVariant(dcProxy.getCompartment().getName());
            deployFolder = dcNode.getDeployableFolder(buildVariant);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (DevConfigException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deployFolder;
    }

    public static boolean checkModulePARProject(IProject project) {
        try {
            IDCExtendedProject dcProj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            if (dcProj == null || dcProj.getDCNode() == null) {
                return false;
            }
            DevelopmentComponent dc = dcProj.getDCNode().getDevelopmentComponent(true);
            return dc.getComponentType().getSubType().equals("Portal Application Module");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (RepositoryAccessException e) {
            e.printStackTrace();
        }
        catch (InvalidDefinitionException e) {
            e.printStackTrace();
        }
        return false;
    }
}

