/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.ideSpecific.eclipse;

import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.IParIdePlugin;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.iDE.AbstractIDE;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCBuildWrapper;
import com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.portal.util.BaseStringBufferPool;
import com.sap.portal.util.Templating;
import com.sap.portal.util.eclipse.FinishResult;
import com.sap.portal.util.eclipse.FinishResultPool;
import com.sap.portal.util.eclipse.ImageUtil;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PortalPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "com.sap.ep.applicationDevelopment";
    public static Hashtable REGISTERED_PLUGINS = new Hashtable();
    public static final int FILTER_ALL_PROJECTS = 0;
    public static final int FILTER_PORTAL_PROJECTS = 1;
    public static final int FILTER_PORTAL_DC_PROJECTS = 2;
    public static final int FILTER_PORTAL_PAR_PROJECTS = 3;
    private static PortalPlugin mm_plugin;
    private static IPluginDescriptor mm_descriptor;
    private static final String PORTAL_NATURE_RELATIVE_ID = "portalProjectNature";
    private static final String SERVICE_NATURE_RELATIVE_ID = "serviceProjectNature";
    private static final String PORTAL_NATURE_ID_OLD = "com.sapportals.developmentTools.portalProjectNature";
    private static final String SERVICE_NATURE_ID_OLD = "com.sapportals.developmentTools.serviceProjectNature";
    private static final String CONFIGURATION_PAGE_ID = "com.sap.ep.applicationDevelopment.configuration";
    public static final String APPLICATION_BUILDER_ID = "com.sap.ep.applicationDevelopment.applicationBuilder";
    public static final String APPLICATION_BUILDER_MARKER_ID = "com.sap.ep.applicationDevelopment.applicationProblemMarker";
    public static final String REPORT_MARKER_ID = "com.sap.ep.applicationDevelopment.pluginProblemMarker";
    public static final String SAP_LOGO = "sap_logo";
    private static File mm_root;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;

    public PortalPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        mm_plugin = this;
        mm_descriptor = descriptor;
        mm_root = new File(descriptor.find((IPath)new Path("")).getFile());
        BaseStringBufferPool.init();
        try {
            String versionPlugin;
            URL pluginUrl = PortalPlugin.getIPluginDescriptor().find((IPath)new Path(""));
            PluginVersionIdentifier versionId = PortalPlugin.getIPluginDescriptor().getVersionIdentifier();
            int major = versionId.getMajorComponent();
            int minor = versionId.getMinorComponent();
            int service = versionId.getServiceComponent();
            JavaToWsdl.VERSION_ECLIPSEPLUGIN = versionPlugin = "" + major + "." + minor + "." + service;
            SapPortalPluginsLogger.logInfo((Object)((Object)this), (String)"Startup in progress");
        }
        catch (Exception e1) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e1);
        }
        try {
            OpentoolsFactory.init("com.sap.portal.developmentTools.ideSpecific.eclipse.impl.Eclipse2EP6OpentoolsFactory");
            SapPortalPluginsLogger.logInfo((Object)((Object)this), (String)"Factory initialized !");
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e, (String)"Factory initialization failed !");
        }
        FinishResultPool.getInstance().getReport(mm_descriptor.getLabel());
    }

    public String getRootPath() {
        return mm_root.getAbsolutePath();
    }

    public String getIconResourcePath() {
        return this.getRootPath() + File.separator + "icons";
    }

    public static void registerPlugin(String pluginId, IParIdePlugin aPlugin) {
        REGISTERED_PLUGINS.put(pluginId, aPlugin);
    }

    public static FinishResult getCurrentReport() {
        return (FinishResult)FinishResultPool.getInstance().getReport(PortalPlugin.getIPluginDescriptor().getLabel());
    }

    public static void releaseCurrentReport() {
        FinishResultPool.getInstance().release(PortalPlugin.getIPluginDescriptor().getLabel());
    }

    public static IPluginDescriptor getIPluginDescriptor() {
        return mm_descriptor;
    }

    public static String getConfigurationPageID() {
        return CONFIGURATION_PAGE_ID;
    }

    public static String getPluginID() {
        return PortalPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static String getPortalNatureID() {
        return PortalPlugin.getPluginID() + "." + PORTAL_NATURE_RELATIVE_ID;
    }

    public static String getOldPortalNatureID() {
        return PORTAL_NATURE_ID_OLD;
    }

    public static String getServiceNatureID() {
        return PortalPlugin.getPluginID() + "." + SERVICE_NATURE_RELATIVE_ID;
    }

    public static String getOldServiceNatureID() {
        return SERVICE_NATURE_ID_OLD;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        try {
            URL url = new URL(this.getDescriptor().getInstallURL(), "icons/SAP_logo.gif");
            reg.put(SAP_LOGO, ImageDescriptor.createFromURL((URL)url));
        }
        catch (MalformedURLException e) {
            SapPortalPluginsLogger.logError((Object)((Object)this), (Throwable)e);
        }
    }

    public static PortalPlugin getDefault() {
        return mm_plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PortalPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            SapPortalPluginsLogger.logError(null, (Throwable)e);
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    public static List getProjectsInWorkspaceRoot(IWorkspaceRoot root, int filter) {
        ArrayList<IProject> retVal = new ArrayList<IProject>();
        try {
            IResource[] children = root.members();
            if (filter == 0) {
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    IProject iProject = child instanceof IProject ? (IProject)child : (IProject)child.getAdapter(class$org$eclipse$core$resources$IProject == null ? PortalPlugin.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                    retVal.add(iProject);
                    ++i;
                }
            } else if (filter == 1) {
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    IProject iProject = child instanceof IProject ? (IProject)child : (IProject)child.getAdapter(class$org$eclipse$core$resources$IProject == null ? PortalPlugin.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                    if (iProject != null && iProject.isOpen() && (iProject.getNature(PortalPlugin.getPortalNatureID()) != null || iProject.getDescription().hasNature(PortalPlugin.getOldPortalNatureID()))) {
                        retVal.add(iProject);
                    }
                    ++i;
                }
            } else if (filter == 2) {
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    IProject iProject = child instanceof IProject ? (IProject)child : (IProject)child.getAdapter(class$org$eclipse$core$resources$IProject == null ? PortalPlugin.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                    if (iProject != null && iProject.isOpen() && iProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature") && iProject.hasNature(PortalPlugin.getPortalNatureID()) && DCBuildWrapper.checkModulePARProject(iProject)) {
                        retVal.add(iProject);
                    }
                    ++i;
                }
            } else if (filter == 3) {
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    IProject iProject = child instanceof IProject ? (IProject)child : (IProject)child.getAdapter(class$org$eclipse$core$resources$IProject == null ? PortalPlugin.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                    if (iProject != null && iProject.isOpen() && !iProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature") && (iProject.hasNature(PortalPlugin.getPortalNatureID()) || iProject.getDescription().hasNature(PortalPlugin.getOldPortalNatureID()))) {
                        retVal.add(iProject);
                    }
                    if (iProject != null && iProject.isOpen() && iProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature") && iProject.hasNature(PortalPlugin.getPortalNatureID()) && DCBuildWrapper.checkModulePARProject(iProject)) {
                        retVal.add(iProject);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            SapPortalPluginsLogger.logError(null, (Throwable)e);
        }
        return retVal;
    }

    public static Set getAllFullyQualifiedClassNamesInProject(IProject project) throws JavaModelException {
        HashSet retVal = new HashSet();
        IJavaProject jProject = Eclipse2IDE.getCurrentJavaProject(project);
        IClasspathEntry[] classpath = jProject.getResolvedClasspath(true);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry iClasspathEntry = classpath[i];
            if (iClasspathEntry.getEntryKind() == 3) {
                IPackageFragmentRoot[] packageFragmentRoots = jProject.findPackageFragmentRoots(iClasspathEntry);
                int j = 0;
                while (j < packageFragmentRoots.length) {
                    PortalPlugin.recurseIJavaElementAndAddElementNamesToList((IJavaElement)packageFragmentRoots[j], retVal);
                    ++j;
                }
            }
            ++i;
        }
        return retVal;
    }

    private static void recurseIJavaElementAndAddElementNamesToList(IJavaElement javaElement, Collection toAddTo) {
        switch (javaElement.getElementType()) {
            case 5: {
                try {
                    IType[] types = ((ICompilationUnit)javaElement).getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        IType type = types[i];
                        toAddTo.add(type.getFullyQualifiedName());
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
                break;
            }
            case 4: {
                IPackageFragment iPackageFragment = (IPackageFragment)javaElement;
                toAddTo.add(iPackageFragment.getElementName());
                try {
                    IJavaElement[] children = iPackageFragment.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        PortalPlugin.recurseIJavaElementAndAddElementNamesToList(children[i], toAddTo);
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
                break;
            }
            case 3: {
                try {
                    IJavaElement[] children = ((IPackageFragmentRoot)javaElement).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        PortalPlugin.recurseIJavaElementAndAddElementNamesToList(children[i], toAddTo);
                        ++i;
                    }
                    break;
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
            }
        }
    }

    public static void recurseIJavaElementAndAddTypesToList(IJavaElement javaElement, Collection toAddTo) {
        switch (javaElement.getElementType()) {
            case 7: {
                try {
                    toAddTo.add(javaElement);
                    IType type = (IType)javaElement;
                    IJavaElement[] children = type.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        IJavaElement child = children[i];
                        PortalPlugin.recurseIJavaElementAndAddTypesToList(child, toAddTo);
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
                break;
            }
            case 5: {
                try {
                    ICompilationUnit iCompilationUnit = (ICompilationUnit)javaElement;
                    IJavaElement[] jElems = iCompilationUnit.getChildren();
                    int i = 0;
                    while (i < jElems.length) {
                        IJavaElement jElem = jElems[i];
                        PortalPlugin.recurseIJavaElementAndAddTypesToList(jElem, toAddTo);
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
                break;
            }
            case 4: {
                IPackageFragment iPackageFragment = (IPackageFragment)javaElement;
                try {
                    IJavaElement[] children = iPackageFragment.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        PortalPlugin.recurseIJavaElementAndAddTypesToList(children[i], toAddTo);
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
                break;
            }
            case 3: {
                try {
                    IJavaElement[] children = ((IPackageFragmentRoot)javaElement).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        PortalPlugin.recurseIJavaElementAndAddTypesToList(children[i], toAddTo);
                        ++i;
                    }
                    break;
                }
                catch (JavaModelException e) {
                    SapPortalPluginsLogger.logError(null, (Throwable)e);
                }
            }
        }
    }

    public static void saveAllDirtyEditorsForProject(IProject project, IProgressMonitor monitor) {
        IWorkbenchWindow[] workbenchWindows = PortalPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchWindow workbenchWindow = workbenchWindows[i];
            IWorkbenchPage[] pages = workbenchWindow.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] dirtyEditors = page.getDirtyEditors();
                int k = 0;
                while (k < dirtyEditors.length) {
                    IEditorPart dirtyEditor = dirtyEditors[k];
                    IFile iFile = (IFile)dirtyEditor.getEditorInput().getAdapter(class$org$eclipse$core$resources$IFile == null ? PortalPlugin.class$("org.eclipse.core.resources.IFile") : class$org$eclipse$core$resources$IFile);
                    if (iFile.getProject().equals((Object)project)) {
                        dirtyEditor.doSave(monitor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void createJavaFileFromTemplateAndOpenIt(IProject project, String fullyQualifiedClassName, String templateLocation, Map templateMap, int sourceIndex) throws Exception {
        URL pluginInstallURL = PortalPlugin.getIPluginDescriptor().find((IPath)new Path(""));
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        File beanClassFile = ideInstance.createJavaSourceFileInCurrentProject(project, fullyQualifiedClassName, sourceIndex);
        FileWriter beanClassWriter = new FileWriter(beanClassFile);
        InputStream templateStream = new URL(pluginInstallURL, templateLocation).openStream();
        Templating.writeTemplateToWriter(templateMap, templateStream, beanClassWriter);
        templateStream.close();
        beanClassWriter.close();
        String classFileAbsolutPath = beanClassFile.getAbsolutePath();
        String[] relBeanClassFileName = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(classFileAbsolutPath.substring(projectPath.length(), classFileAbsolutPath.length()));
        ideInstance.openFileInEditor(project, relBeanClassFileName);
    }

    public void earlyStartup() {
    }

    public ImageRegistry getImageRegistry() {
        return ImageUtil.getImageRegistry();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

