/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.wizards.sapnewproject;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sap.portal.developmentTools.general.wizards.sapnewproject.ISAPNPWizardPage;
import java.io.File;

public class SAPNewProjectWizardTemplate {
    public static Object project;

    public static boolean initializeWizardPage(Object parentGUIThing, ISAPNPWizardPage page) {
        boolean success = true;
        try {
            PDKInstallation pdk = null;
            pdk = PDKInstallation.getInstance();
            if (!pdk.isConfiguredOnce()) {
                OpentoolsFactory.getGuiSystem().invokeConfigurationWizard(parentGUIThing);
            }
            if (!pdk.isConfiguredOnce()) {
                success = false;
            } else {
                IDESettings iset = IDESettings.getInstance();
                String projectRootRootFolder = iset.getProjectRootRootFolder();
                if (projectRootRootFolder == null) {
                    projectRootRootFolder = "";
                }
                page.setProjectRootRootFolderName(projectRootRootFolder);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "An error occurred", e, parentGUIThing);
        }
        return success;
    }

    public static boolean finishNewProjectWizard(ISAPNPWizardPage _textPage, Object parentGUIThing, boolean invokeNewClassWizard) {
        boolean success = true;
        IGUI guiSystem = OpentoolsFactory.getGuiSystem();
        try {
            IDESettings iset = IDESettings.getInstance();
            iset.setProjectRootRootFolder(_textPage.getProjectRootRootFolderName());
        }
        catch (Exception e) {
            e.printStackTrace();
            guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
        }
        File f = new File(_textPage.getProjectRootRootFolderName(), _textPage.getProjectName());
        if (f.exists()) {
            String errorMessage = "Folder " + _textPage.getProjectName() + " already exists as subfolder of " + _textPage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
            System.out.println(errorMessage);
            guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
            success = false;
        }
        if (success) {
            try {
                project = OpentoolsFactory.getEPInstance().createNewIViewProject(_textPage.getProjectRootRootFolderName(), _textPage.getProjectName(), false);
            }
            catch (Exception fnfex) {
                fnfex.printStackTrace();
                guiSystem.showErrorMessage("Error", "An error has occured while trying to create the project structure", fnfex, parentGUIThing);
            }
            if (invokeNewClassWizard) {
                guiSystem.invokeNewIViewClassWizard(parentGUIThing);
            }
        }
        return success;
    }
}

