/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.wizards.openArchive;

import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sap.portal.developmentTools.general.wizards.openArchive.IOpenArchiveWizardPage;
import java.io.File;

public class OpenArchiveWizardTemplate {
    public static Object project;

    public static boolean initalizeWizardPage(Object guiThingForModalDialog, IOpenArchiveWizardPage openArchivePage) {
        try {
            PDKInstallation pdk = PDKInstallation.getInstance();
            if (!pdk.isConfiguredOnce()) {
                OpentoolsFactory.getGuiSystem().invokeConfigurationWizard(guiThingForModalDialog);
            }
            if (pdk.isConfiguredOnce()) {
                IDESettings is = IDESettings.getInstance();
                openArchivePage.setOpenParFolder(is.getOpenParDefaultFolder());
                openArchivePage.setProjectRootRootFolder(is.getProjectRootRootFolder());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "Sorry, an error occured creating the new project", e, guiThingForModalDialog);
            return false;
        }
    }

    public static Object finishOpenArchivePage(IOpenArchiveWizardPage _textPage, Object guiThingForModalDialog) {
        File f;
        IGUI guiSystem = OpentoolsFactory.getGuiSystem();
        boolean success = true;
        String fileName = _textPage.getFilePath();
        String projectRootFolderName = _textPage.getProjectRootFolderName();
        String projectName = _textPage.getProjectName();
        project = null;
        File zipFile = new File(fileName);
        if (!zipFile.exists() || zipFile.isDirectory()) {
            String errorMessage = "Sorry, could not find the specified file '" + fileName + "'.\n";
            guiSystem.showErrorMessage("Error", errorMessage, new Exception("File does not exist: " + zipFile.getAbsolutePath()), guiThingForModalDialog);
            success = false;
        }
        if ((f = new File(projectRootFolderName, projectName)).exists()) {
            String errorMessage = "Folder " + projectName + " already exists as subfolder of " + projectRootFolderName + ".\nPlease specifiy a different project name or root folder.";
            guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + zipFile.getAbsolutePath()), guiThingForModalDialog);
            success = false;
        }
        if (success) {
            try {
                IDESettings iset = IDESettings.getInstance();
                iset.setOpenParDefaultFolder(zipFile.getParent());
                iset.setProjectRootRootFolder(projectRootFolderName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                EP epInstance = OpentoolsFactory.getEPInstance();
                if (fileName.endsWith(".par") || fileName.endsWith(".par.bak") || fileName.endsWith(".zar") || fileName.endsWith(".zar.bak")) {
                    project = epInstance.createNewIViewProjectFromPar(projectRootFolderName, projectName, zipFile);
                }
            }
            catch (Throwable t) {
                guiSystem.showErrorMessage("Error", "Sorry, an error occured creating the new project", t, guiThingForModalDialog);
                t.printStackTrace();
            }
        }
        return project;
    }
}

