/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.wizards.configurationWizard;

import com.sap.portal.developmentTools.general.api.IGUI;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.PDKInstallation;
import com.sap.portal.developmentTools.general.wizards.configurationWizard.IConfigurationWizardPage;
import com.sap.portal.developmentTools.general.wizards.configurationWizard.IConfigurationWizardStringLiterals;

public class ConfigurationWizardTemplate
implements IConfigurationWizardStringLiterals {
    public static void initializeConfigurationPage(IConfigurationWizardPage _textPage) {
    }

    public static boolean finishConfigurationPage(IConfigurationWizardPage _textPage, Object guiThingForModalDialog) {
        int optionPaneAnswer = 0;
        try {
            PDKInstallation pdkinstall = PDKInstallation.getInstance();
            IGUI gui = OpentoolsFactory.getGuiSystem();
            int port = Integer.parseInt(_textPage.getIrjServerPortAsString());
            String servername = _textPage.getIrjServerName();
            String webappName = _textPage.getIrjWebappName();
            pdkinstall.setIrjPort(port);
            pdkinstall.setIrjServerName(servername);
            pdkinstall.setIrjWebappName(webappName);
            optionPaneAnswer = 0;
            String failureMessage = "Could not locate Server with a running PDK at http://" + servername + ":" + port + "/" + webappName + "/...\nPossible causes could be: server address is wrong or the com.sap.pdk.util.DevelopmentTools component is not installed.\nRetry or check your settings.";
            while (!pdkinstall.isServerReachable() && optionPaneAnswer == 0) {
                optionPaneAnswer = gui.showOptionDialog(guiThingForModalDialog, failureMessage, "Connection failed", 2, IConfigurationWizardStringLiterals.uploadConnectFailureOptions, "Retry");
            }
            pdkinstall.updateIrjWebappFileHome();
            pdkinstall.doSave();
            try {
                pdkinstall.getInstalledServices();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "Sorry, an error occurred", e);
        }
        return optionPaneAnswer == 0;
    }
}

