/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.uploader;

import com.sap.netweaver.ep.core.preferences.Controller;
import com.sap.netweaver.ep.core.preferences.IServerConfig;
import com.sap.netweaver.ep.core.preferences.ServerConfig;
import com.sap.netweaver.ep.ui.EnterprisePortalPlugin;
import com.sap.netweaver.ep.ui.preferences.PreferencePage;
import com.sap.portal.developmentTools.general.api.EP;
import com.sap.portal.developmentTools.general.api.IDE;
import com.sap.portal.developmentTools.general.api.OpentoolsFactory;
import com.sap.portal.developmentTools.general.settings.IDESettings;
import com.sap.portal.developmentTools.general.wizards.upload.DeployEngine;
import com.sap.portal.developmentTools.ideSpecific.eclipse.PortalPlugin;
import com.sap.portal.developmentTools.ideSpecific.eclipse.dcutils.DCBuildWrapper;
import com.sap.portal.developmentTools.ideSpecific.eclipse.wizards.sapmakepar.QuickPARUploadWizard;
import com.tssap.dii.component.DCUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class QuickPARUploader
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String QUICK_PAR_UPLOAD = "com.sap.developmentTools.actions.QUICK_PAR_UPLOAD";
    private final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    private Object mm_part;
    private String mm_actionId;
    private IProject mm_selectedProject;
    private String mm_parFileName;
    private IServerConfig mm_uploadServer = null;
    private boolean mm_uploadComplete = false;
    private boolean mm_errorStatus = false;
    private String mm_statusMessage;

    public void init(IViewPart view) {
        this.mm_part = view;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mm_part = targetPart;
    }

    public void run(IAction action) {
        String actionId = action.getId();
        if (this.mm_selectedProject == null) {
            IEditorInput editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
            if (editor instanceof FileEditorInput && editor != null) {
                FileEditorInput editorInput = (FileEditorInput)editor;
                this.mm_selectedProject = editorInput.getFile().getProject();
            } else {
                return;
            }
        }
        if (ServerConfig.getServerList().isEmpty()) {
            ServerConfig.loadServerList();
        }
        IServerConfig defaultServer = Controller.getInstance().getDefaultServerConfig();
        IServerConfig lastServer = Controller.getInstance().getLastServerConfig();
        if (lastServer != null) {
            this.mm_uploadServer = lastServer;
        } else if (defaultServer != null) {
            this.mm_uploadServer = defaultServer;
        }
        if (this.mm_uploadServer == null || this.mm_uploadServer.getPassword() == null || !EnterprisePortalPlugin.getDefault().getPreferenceStore().getBoolean(PreferencePage.ID_REMEMBER_PASSWORDS)) {
            QuickPARUploadWizard wizard = new QuickPARUploadWizard(this.mm_selectedProject);
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
            wd.open();
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IDESettings is = IDESettings.getInstance();
                    IDE ideInstance = OpentoolsFactory.getIDEInstance();
                    EP epInstance = OpentoolsFactory.getEPInstance();
                    File prospectedParFile = null;
                    QuickPARUploader.this.mm_uploadComplete = false;
                    QuickPARUploader.this.mm_errorStatus = false;
                    boolean isZipArchiveSrc = true;
                    boolean includeNonJavaSources = true;
                    boolean shortNames = true;
                    QuickPARUploader.this.mm_parFileName = is.getParArchiveName(QuickPARUploader.this.mm_selectedProject);
                    try {
                        prospectedParFile = new File(QuickPARUploader.this.mm_parFileName);
                    }
                    catch (Exception e) {
                        QuickPARUploader.this.mm_errorStatus = true;
                        QuickPARUploader.this.mm_statusMessage = "Unable to create PAR archive.";
                        e.printStackTrace();
                    }
                    monitor.beginTask("Processing request...", 3);
                    monitor.subTask("Building project...");
                    try {
                        if (!ideInstance.rebuildCurrentProject(QuickPARUploader.this.mm_selectedProject, new int[]{0}, 0)) {
                            QuickPARUploader.this.mm_errorStatus = true;
                            QuickPARUploader.this.mm_statusMessage = "Build of the project " + QuickPARUploader.this.mm_selectedProject.getName() + " failed.";
                            monitor.done();
                            return;
                        }
                    }
                    catch (Exception e) {
                        QuickPARUploader.this.mm_errorStatus = true;
                        QuickPARUploader.this.mm_statusMessage = "Build of the project " + QuickPARUploader.this.mm_selectedProject.getName() + " failed 2.";
                        monitor.done();
                        return;
                    }
                    monitor.worked(1);
                    monitor.subTask("Creating PAR file...");
                    try {
                        epInstance.makeParArchiveFromProject(QuickPARUploader.this.mm_selectedProject, QuickPARUploader.this.mm_parFileName, prospectedParFile, isZipArchiveSrc, includeNonJavaSources, shortNames);
                    }
                    catch (Exception e) {
                        QuickPARUploader.this.mm_errorStatus = true;
                        QuickPARUploader.this.mm_statusMessage = "Creation of PAR file " + QuickPARUploader.this.mm_parFileName + " failed.";
                        e.printStackTrace();
                        monitor.done();
                        return;
                    }
                    monitor.worked(1);
                    monitor.subTask("Deploying PAR file...");
                    try {
                        DeployEngine deployEngine = new DeployEngine(QuickPARUploader.this.mm_uploadServer);
                        deployEngine.deploy(QuickPARUploader.this.mm_parFileName);
                        QuickPARUploader.this.mm_uploadComplete = true;
                    }
                    catch (Exception e) {
                        QuickPARUploader.this.mm_errorStatus = true;
                        QuickPARUploader.this.mm_statusMessage = "Connection refused to " + QuickPARUploader.this.mm_uploadServer.getAlias() + " server.";
                        e.printStackTrace();
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(this.shell).run(true, true, runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mm_errorStatus) {
                MessageDialog.openError((Shell)this.shell, (String)"Error", (String)this.mm_statusMessage);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object obj = ss.getFirstElement();
            IProject currentProject = null;
            if (obj instanceof IJavaElement) {
                currentProject = ((IJavaElement)obj).getJavaProject().getProject();
            } else if (obj instanceof IResource) {
                currentProject = ((IResource)obj).getProject();
            }
            try {
                if (currentProject == null || !currentProject.isOpen() || !currentProject.hasNature(PortalPlugin.getPortalNatureID()) && !currentProject.getDescription().hasNature(PortalPlugin.getOldPortalNatureID()) || DCUtil.isDCProject((IProject)currentProject) && !DCBuildWrapper.checkModulePARProject(currentProject)) {
                    action.setEnabled(false);
                    return;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                return;
            }
            action.setEnabled(true);
            this.mm_selectedProject = currentProject;
            return;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow wbWindow) {
    }
}

