/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.developmentTools.general.settings;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.portal.developmentTools.general.Service;
import com.sap.portal.developmentTools.general.uploader.PARArchiveUploaderConstants;
import com.sap.portal.util.Stream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class PDKRequestResult
implements PARArchiveUploaderConstants {
    public static final PDKRequestResult UPLOAD_OK_RESULT_SINGLETON = new UploadOKResult();
    protected byte[] xmlData;

    public abstract int getResultType();

    public abstract Object getResultData();

    public byte[] getXmlData() {
        return this.xmlData;
    }

    public static PDKRequestResult createResultObject(InputStream xmlStream) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Stream.copyStream(xmlStream, baos);
            byte[] xmlData = baos.toByteArray();
            DocumentBuilderFactoryImpl df = new DocumentBuilderFactoryImpl();
            DocumentBuilder builder = df.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlData));
            Element responseElement = doc.getDocumentElement();
            String resultCode = responseElement.getAttribute("type");
            if (resultCode.equals("error")) {
                return new ErrorResult(responseElement, xmlData);
            }
            if (resultCode.equals("upload")) {
                return UPLOAD_OK_RESULT_SINGLETON;
            }
            if (resultCode.equals("getList")) {
                return new ServicesListResult(responseElement, xmlData);
            }
            if (resultCode.equals("getRootDir")) {
                return new GetIrjWebappFileHomeResult(responseElement, xmlData);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        throw new NoSuchMethodError("could not evaluate the server response.");
    }

    private static String getFirstTextValue(Element elem) {
        String result = null;
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 3) {
                result = list.item(i).getNodeValue();
                break;
            }
            ++i;
        }
        return result;
    }

    public static class GetIrjWebappFileHomeResult
    extends PDKRequestResult {
        private File home;

        public GetIrjWebappFileHomeResult(Element responseElement, byte[] xmlData) {
            this.xmlData = xmlData;
            String text = PDKRequestResult.getFirstTextValue(responseElement);
            File f = new File(text);
            if (f.exists()) {
                this.home = f;
            }
        }

        public int getResultType() {
            return 2;
        }

        public Object getResultData() {
            return this.home;
        }
    }

    public static final class ServicesListResult
    extends PDKRequestResult {
        List services;

        ServicesListResult(Element responseElement, byte[] xmlData) {
            this.xmlData = xmlData;
            this.services = new ArrayList();
            NodeList serviceElems = responseElement.getElementsByTagName("Service");
            int i = 0;
            while (i < serviceElems.getLength()) {
                Service now = ServicesListResult.initServiceFromJDOM((Element)serviceElems.item(i));
                this.services.add(now);
                ++i;
            }
            NodeList pARElems = responseElement.getElementsByTagName("PAR");
            int i2 = 0;
            while (i2 < pARElems.getLength()) {
                Service now = ServicesListResult.initServiceFromJDOM((Element)pARElems.item(i2));
                this.services.add(now);
                ++i2;
            }
        }

        public int getResultType() {
            return 0;
        }

        public Object getResultData() {
            return this.services;
        }

        private static Service initServiceFromJDOM(Element serviceElem) {
            boolean isAComponent = !serviceElem.getNodeName().equals("Service");
            String name = serviceElem.getAttribute("name");
            String shortDesc = null;
            NodeList shortDescList = serviceElem.getElementsByTagName("short-desc");
            if (shortDescList.getLength() > 0) {
                shortDesc = PDKRequestResult.getFirstTextValue((Element)shortDescList.item(0));
            }
            ArrayList<String> jarRefs = new ArrayList<String>();
            NodeList jarRefElementsList = serviceElem.getElementsByTagName("jar");
            int i = 0;
            while (i < jarRefElementsList.getLength()) {
                Element element = (Element)jarRefElementsList.item(i);
                jarRefs.add(element.getAttribute("path"));
                ++i;
            }
            Service retVal = new Service(name, shortDesc, jarRefs, isAComponent);
            return retVal;
        }
    }

    public static final class UploadOKResult
    extends PDKRequestResult {
        UploadOKResult() {
        }

        public int getResultType() {
            return 1;
        }

        public Object getResultData() {
            return null;
        }
    }

    public static final class ErrorResult
    extends PDKRequestResult {
        private String errorStackTrace;

        ErrorResult(Element responseElement, byte[] xmlData) {
            this.errorStackTrace = PDKRequestResult.getFirstTextValue(responseElement);
            this.xmlData = xmlData;
        }

        public int getResultType() {
            return -1;
        }

        public Object getResultData() {
            return this.errorStackTrace;
        }
    }
}

